import { Injectable } from '@angular/core';
import { DateTimeObject } from './objects';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./animation.service";
export class HelperService {
    constructor(model, animationService) {
        this.model = model;
        this.animationService = animationService;
    }
    val(value, def) {
        return value != null && value.trim() !== '' ? value : (def || '');
    }
    findPosY(obj, mainClassName, noScroll) {
        let curtop = noScroll ? 0 : this.getScrollYOffset(obj, mainClassName);
        if (obj.offsetParent) {
            while (obj.className !== mainClassName) {
                curtop += obj.offsetTop;
                if (!obj.offsetParent) {
                    break;
                }
                obj = obj.offsetParent;
            }
        }
        else if (obj.y) {
            curtop += obj.y;
        }
        return curtop;
    }
    getScrollYOffset(obj, mainClassName) {
        let scrolltop = 0;
        if (obj.parentElement) {
            while (obj.className !== mainClassName) {
                if ('scrollTop' in obj) {
                    scrolltop -= obj.scrollTop;
                }
                if (!obj.parentElement) {
                    break;
                }
                obj = obj.parentElement;
            }
        }
        return scrolltop;
    }
    findPosX(obj, mainClassName, noScroll) {
        let curleft = noScroll ? 0 : this.getScrollXOffset(obj, mainClassName);
        if (obj.offsetParent) {
            while (obj.className !== mainClassName) {
                curleft += obj.offsetLeft;
                if (!obj.offsetParent) {
                    break;
                }
                obj = obj.offsetParent;
            }
        }
        else if (obj.x) {
            curleft += obj.x;
        }
        return curleft;
    }
    getScrollXOffset(obj, mainClassName) {
        let scrollleft = 0;
        if (obj.parentElement) {
            while (obj.className !== mainClassName) {
                if ('scrollLeft' in obj) {
                    scrollleft -= obj.scrollLeft;
                }
                if (!obj.parentElement) {
                    break;
                }
                obj = obj.parentElement;
            }
        }
        return scrollleft;
    }
    showHelpWindow(url) {
        let helpLanguage = 'en';
        switch (this.model.options.cultureName) {
            case 'ru': helpLanguage = 'ru';
            // case 'de': helpLanguage = 'de';
        }
        this.openNewWindow('https://www.stimulsoft.com/' + helpLanguage + '/documentation/online/' + url);
    }
    openNewWindow(url, name, specs) {
        return window.open(url, name, specs);
    }
    scrollToAnchor(anchorName, componentGuid) {
        let aHyperlinks = this.model.controls.reportPanel.el.nativeElement.getElementsByTagName("a");
        const identicalAnchors = [];
        if (anchorName) {
            anchorName = anchorName.replace(/!!#92/g, '\\');
        }
        if (componentGuid) {
            for (let i = 0; i < aHyperlinks.length; i++) {
                if (aHyperlinks[i].getAttribute('guid') === componentGuid) {
                    identicalAnchors.push(aHyperlinks[i]);
                }
            }
        }
        if (identicalAnchors.length === 0) {
            let guidIndex = anchorName.indexOf("#GUID#");
            if (identicalAnchors.length == 0) {
                let aHyperlinks = this.model.controls.reportPanel.el.nativeElement.getElementsByTagName("a");
                for (var i = 0; i < aHyperlinks.length; i++) {
                    if (aHyperlinks[i].name && ((guidIndex >= 0 && (aHyperlinks[i].name.indexOf(anchorName.substring(guidIndex + 6)) >= 0 || anchorName.substring(0, guidIndex) == aHyperlinks[i].name)) || aHyperlinks[i].name == anchorName))
                        identicalAnchors.push(aHyperlinks[i]);
                }
            }
        }
        if (identicalAnchors.length > 0) {
            const anchor = identicalAnchors[0];
            const anchorParent = anchor.parentElement || anchor;
            let anchorHeight = anchorParent.offsetHeight;
            const anchorOffsetTop = anchorParent.offsetTop;
            identicalAnchors.forEach((identicalAnchor) => {
                const nextAnchorParent = identicalAnchor.parentElement || identicalAnchor;
                if (nextAnchorParent.offsetTop > anchorOffsetTop) {
                    anchorHeight = Math.max(anchorHeight, nextAnchorParent.offsetTop - anchorOffsetTop + nextAnchorParent.offsetHeight);
                }
            });
            const date = new Date();
            const endTime = date.getTime() + this.model.options.scrollDuration;
            const targetTop = this.findPosY(anchor, this.model.options.appearance.scrollbarsMode ? 'stiJsViewerReportPanel' : null, true) - anchorParent.offsetHeight * 2;
            this.animationService.showAnimationForScroll(this.model.controls.reportPanel.el.nativeElement, targetTop, endTime, () => {
                const page = this.getPageFromAnchorElement(anchor);
                const anchorParentTopPos = this.findPosY(anchorParent, 'stiJsViewerReportPanel', true);
                const pageTopPos = page ? this.findPosY(page, 'stiJsViewerReportPanel', true) : anchorParentTopPos;
                this.removeBookmarksLabel();
                const label = document.createElement('div');
                this.model.controls.bookmarksLabel = label;
                label.className = 'stiJsViewerBookmarksLabel';
                const labelMargin = 20 * (this.model.reportParams.zoom / 100);
                const labelWidth = page ? page.offsetWidth - labelMargin - 6 : anchorParent.offsetWidth;
                const labelHeight = anchorHeight - 2;
                label.style.width = labelWidth + 'px';
                label.style.height = labelHeight + 'px';
                const margins = page.pageAttributes.margins?.replace('px', '').split(' ');
                const pageLeftMargin = page.pageAttributes.margins ? this.strToInt(margins[3]) : 0;
                const pageTopMargin = page.pageAttributes.margins ? this.strToInt(margins[0]) : 0;
                label.style.marginLeft = (labelMargin / 2 - pageLeftMargin) + 'px';
                label.style.marginTop = (anchorParentTopPos - pageTopPos - pageTopMargin - (this.model.reportParams.zoom / 100) - 1) + 'px';
                page.insertBefore(label, page.childNodes[0]);
            });
        }
    }
    removeBookmarksLabel() {
        if (this.model.controls.bookmarksLabel) {
            this.model.controls.bookmarksLabel.parentElement.removeChild(this.model.controls.bookmarksLabel);
            this.model.controls.bookmarksLabel = null;
        }
    }
    getPageFromAnchorElement(anchorElement) {
        let obj = anchorElement;
        while (obj.parentElement) {
            if (obj.className && obj.className.indexOf('stiJsViewerPage') === 0) {
                return obj;
            }
            obj = obj.parentElement;
        }
        return obj;
    }
    strToInt(value) {
        const result = parseInt(value, 10);
        return result || 0;
    }
    strToDouble(value) {
        if (value === null) {
            return null;
        }
        const result = parseFloat(value.toString().replace(',', '.').trim());
        return result || 0;
    }
    copyObject(o) {
        if (!o || 'object' !== typeof o) {
            return o;
        }
        const c = 'function' === typeof o.pop ? [] : {};
        let p;
        let v;
        for (p in o) {
            if (o.hasOwnProperty(p)) {
                v = o[p];
                if (v && 'object' === typeof v) {
                    c[p] = this.copyObject(v);
                }
                else {
                    c[p] = v;
                }
            }
        }
        return c;
    }
    getCountObjects(objectArray) {
        let count = 0;
        if (objectArray) {
            for (const singleObject in objectArray) {
                count++;
            }
        }
        return count;
    }
    replaceMonths(value) {
        for (let i = 1; i <= 12; i++) {
            let enName = '';
            let locName = '';
            switch (i) {
                case 1:
                    enName = 'January';
                    locName = this.model.loc('MonthJanuary');
                    break;
                case 2:
                    enName = 'February';
                    locName = this.model.loc('MonthFebruary');
                    break;
                case 3:
                    enName = 'March';
                    locName = this.model.loc('MonthMarch');
                    break;
                case 4:
                    enName = 'April';
                    locName = this.model.loc('MonthApril');
                    break;
                case 5:
                    enName = 'May';
                    locName = this.model.loc('MonthMay');
                    break;
                case 6:
                    enName = 'June';
                    locName = this.model.loc('MonthJune');
                    break;
                case 7:
                    enName = 'July';
                    locName = this.model.loc('MonthJuly');
                    break;
                case 8:
                    enName = 'August';
                    locName = this.model.loc('MonthAugust');
                    break;
                case 9:
                    enName = 'September';
                    locName = this.model.loc('MonthSeptember');
                    break;
                case 10:
                    enName = 'October';
                    locName = this.model.loc('MonthOctober');
                    break;
                case 11:
                    enName = 'November';
                    locName = this.model.loc('MonthNovember');
                    break;
                case 12:
                    enName = 'December';
                    locName = this.model.loc('MonthDecember');
                    break;
            }
            const enShortName = enName.substring(0, 3);
            const locShortName = locName.substring(0, 3);
            value = value.replace(enName, i).replace(enName.toLowerCase(), i).replace(enShortName, i).replace(enShortName.toLowerCase(), i);
            value = value.replace(locName, i).replace(locName.toLowerCase(), i).replace(locShortName, i).replace(locShortName.toLowerCase(), i);
        }
        return value;
    }
    getDate(dateTimeObj) {
        return new Date(dateTimeObj.year, dateTimeObj.month - 1, dateTimeObj.day, dateTimeObj.hours, dateTimeObj.minutes, dateTimeObj.seconds);
    }
    getDateTimeObject(date) {
        if (!date) {
            date = new Date();
        }
        const dateTimeObject = new DateTimeObject();
        dateTimeObject.year = date.getFullYear();
        dateTimeObject.month = date.getMonth() + 1;
        dateTimeObject.day = date.getDate();
        dateTimeObject.hours = date.getHours();
        dateTimeObject.minutes = date.getMinutes();
        dateTimeObject.seconds = date.getSeconds();
        return dateTimeObject;
    }
    getDateTimeFromString(value, format) {
        const charIsDigit = (ch) => {
            return ('0123456789'.indexOf(ch) >= 0);
        };
        if (!value) {
            return new Date();
        }
        value = this.replaceMonths(value);
        let dateTime = new Date();
        // If the date format is not specified, then deserializator for getting date and time is applied
        if (format === null) {
            format = 'dd.MM.yyyy hh:mm:ss';
        }
        // Otherwise the format is parsed. Now only numeric date and time formats are supported
        let year = 1970;
        let month = 1;
        let day = 1;
        let hour = 0;
        let minute = 0;
        let second = 0;
        let millisecond = 0;
        let char = '';
        let pos = 0;
        const values = [];
        // Parse date and time into separate numeric values
        while (pos < value.length) {
            char = value.charAt(pos);
            if (charIsDigit(char)) {
                values.push(char);
                pos++;
                while (pos < value.length && charIsDigit(value.charAt(pos))) {
                    values[values.length - 1] += value.charAt(pos);
                    pos++;
                }
                values[values.length - 1] = this.strToInt(values[values.length - 1]);
            }
            pos++;
        }
        pos = 0;
        let charCount = 0;
        let index = -1;
        let is12hour = false;
        // Parsing format and replacement of appropriate values of date and time
        while (pos < format.length) {
            char = format.charAt(pos);
            charCount = 0;
            if (char === 'Y' || char === 'y' || char === 'M' || char === 'd' || char === 'h' || char === 'H' ||
                char === 'm' || char === 's' || char === 'f' || char === 'F' || char === 't' || char === 'z') {
                index++;
                while (pos < format.length && format.charAt(pos) === char) {
                    pos++;
                    charCount++;
                }
            }
            switch (char) {
                case 'Y': // full year
                    year = values[index];
                    break;
                case 'y': // year
                    if (values[index] < 1000) {
                        year = 2000 + values[index];
                    }
                    else {
                        year = values[index];
                    }
                    break;
                case 'M': // month
                    month = values[index];
                    break;
                case 'd': // day
                    day = values[index];
                    break;
                case 'h': // (hour 12)
                    is12hour = true;
                    hour = values[index];
                    break;
                case 'H': // (hour 24)
                    hour = values[index];
                    break;
                case 'm': // minute
                    minute = values[index];
                    break;
                case 's': // second
                    second = values[index];
                    break;
                case 'f': // second fraction
                case 'F': // second fraction, trailing zeroes are trimmed
                    millisecond = values[index];
                    break;
                case 't': // PM or AM
                    if (value.toLowerCase().indexOf('am') >= 0 && hour === 12) {
                        hour = 0;
                    }
                    if (value.toLowerCase().indexOf('pm') >= 0 && hour < 12) {
                        hour += 12;
                    }
                    break;
                default:
                    pos++;
                    break;
            }
        }
        dateTime = new Date(year || new Date().getFullYear(), month - 1 || 0, day || 1, hour || 0, minute || 0, second, millisecond || 0);
        if (!dateTime || isNaN(dateTime)) {
            return new Date();
        }
        return dateTime;
    }
    getStringDateTime(object, dateTimeType) {
        if (dateTimeType === 'Date') {
            object.hours = 0;
            object.minutes = 0;
            object.seconds = 0;
        }
        return object.month + '/' + object.day + '/' + object.year + ' ' +
            (object.hours > 12 ? object.hours - 12 : object.hours) + ':' + object.minutes + ':' + object.seconds + ' ' +
            (object.hours < 12 ? 'AM' : 'PM');
    }
    dateTimeObjectToString(dateTimeObject, typeDateTimeObject) {
        const date = new Date(dateTimeObject.year, dateTimeObject.month - 1, dateTimeObject.day, dateTimeObject.hours, dateTimeObject.minutes, dateTimeObject.seconds);
        if (this.model.options.appearance.parametersPanelDateFormat !== '') {
            return this.formatDate(date, this.model.options.appearance.parametersPanelDateFormat);
        }
        return this.dateToLocaleString(date, typeDateTimeObject);
    }
    dateToLocaleString(date, dateTimeType) {
        const timeString = date.toLocaleTimeString();
        const isAmericanFormat = timeString.toLowerCase().indexOf('am') >= 0 || timeString.toLowerCase().indexOf('pm') >= 0;
        let formatDate = isAmericanFormat ? 'MM/dd/yyyy' : 'dd.MM.yyyy';
        const yyyy = date.getFullYear();
        const yy = yyyy.toString().substring(2);
        const M = date.getMonth() + 1;
        const MM = M < 10 ? '0' + M : M;
        const d = date.getDate();
        const dd = d < 10 ? '0' + d : d;
        formatDate = formatDate.replace(/yyyy/i, yyyy);
        formatDate = formatDate.replace(/yy/i, yy);
        formatDate = formatDate.replace(/MM/i, MM);
        formatDate = formatDate.replace(/M/i, M);
        formatDate = formatDate.replace(/dd/i, dd);
        formatDate = formatDate.replace(/d/i, d);
        let h = date.getHours();
        let tt = '';
        if (isAmericanFormat) {
            tt = h < 12 ? ' AM' : ' PM';
            h = h > 12 ? h - 12 : h;
            if (h === 0) {
                h = 12;
            }
        }
        else {
            h = h < 10 ? '0' + h : h;
        }
        let m = date.getMinutes();
        m = m < 10 ? '0' + m : m;
        let s = date.getSeconds();
        s = s < 10 ? '0' + s : s;
        const formatTime = h + ':' + m + ':' + s + tt;
        if (dateTimeType === 'Time') {
            return formatTime;
        }
        if (dateTimeType === 'Date') {
            return formatDate;
        }
        return formatDate + ' ' + formatTime;
    }
    formatDate(formatDate, formatString) {
        const yyyy = formatDate.getFullYear();
        const yy = yyyy.toString().substring(2);
        const m = formatDate.getMonth() + 1;
        const mm = m < 10 ? '0' + m : m;
        const d = formatDate.getDate();
        const dd = d < 10 ? '0' + d : d;
        const h = formatDate.getHours();
        const hh = h < 10 ? '0' + h : h;
        const h12 = h > 12 ? h - 12 : (h > 0 ? h : 12);
        const hh12 = h12 < 10 ? '0' + h12 : h12;
        const n = formatDate.getMinutes();
        const nn = n < 10 ? '0' + n : n;
        const s = formatDate.getSeconds();
        const ss = s < 10 ? '0' + s : s;
        const tt = h < 12 ? 'AM' : 'PM';
        formatString = formatString.replace(/yyyy/gi, yyyy);
        formatString = formatString.replace(/yy/gi, yy);
        formatString = formatString.replace(/Y/, yyyy);
        formatString = formatString.replace(/MM/g, mm);
        formatString = formatString.replace(/M/g, m);
        formatString = formatString.replace(/dd/g, dd);
        formatString = formatString.replace(/d/g, d);
        formatString = formatString.replace(/hh/g, hh12);
        formatString = formatString.replace(/h/g, h12);
        formatString = formatString.replace(/HH/g, hh);
        formatString = formatString.replace(/H/g, h);
        formatString = formatString.replace(/mm/g, nn);
        formatString = formatString.replace(/m/g, n);
        formatString = formatString.replace(/ss/g, ss);
        formatString = formatString.replace(/s/g, s);
        formatString = formatString.replace(/tt/gi, tt);
        formatString = formatString.replace(/t/gi, tt.substr(0, 1));
        return formatString;
    }
    getStringKey(key, params) {
        if (key === null) {
            return '';
        }
        return ((params.type === 'DateTime') ? this.dateTimeObjectToString(key, params.dateTimeType) : key);
    }
    stringToTime(timeStr) {
        const timeArray = timeStr.split(':');
        const time = { hours: 0, minutes: 0, seconds: 0 };
        time.hours = this.strToInt(timeArray[0]);
        if (timeArray.length > 1) {
            time.minutes = this.strToInt(timeArray[1]);
        }
        if (timeArray.length > 2) {
            time.seconds = this.strToInt(timeArray[2]);
        }
        if (time.hours < 0) {
            time.hours = 0;
        }
        if (time.minutes < 0) {
            time.minutes = 0;
        }
        if (time.seconds < 0) {
            time.seconds = 0;
        }
        if (time.hours > 23) {
            time.hours = 23;
        }
        if (time.minutes > 59) {
            time.minutes = 59;
        }
        if (time.seconds > 59) {
            time.seconds = 59;
        }
        return time;
    }
    newGuid() {
        const chars = '0123456789abcdefghijklmnopqrstuvwxyz'.split('');
        const uuid = [];
        const rnd = Math.random;
        let r;
        uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
        uuid[14] = '4';
        for (let i = 0; i < 36; i++) {
            if (!uuid[i]) {
                r = 0 | rnd() * 16;
                uuid[i] = chars[(i === 19) ? (r & 0x3) | 0x8 : r & 0xf];
            }
        }
        return uuid.join('');
    }
    getCountDaysOfMonth(year, month) {
        const countDaysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
        let count = countDaysInMonth[month];
        if (month === 1) {
            if (year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0)) {
                count = 29;
            }
            else {
                count = 28;
            }
        }
        return count;
    }
    setObjectToCenter(object, defaultTop) {
        const leftPos = (this.model.viewerSize.width / 2 - object.offsetWidth / 2);
        const topPos = this.model.options.appearance.fullScreenMode ? (this.model.viewerSize.height / 2 - object.offsetHeight / 2) : (defaultTop ? defaultTop : 250);
        return { left: Math.max(leftPos, 0), top: Math.max(topPos, 0) };
    }
    checkCloudAuthorization(action) {
        return true;
    }
    getCookie_(name) {
        const cookie = ' ' + document.cookie;
        const search = ' ' + name + '=';
        let setStr = null;
        let offset = 0;
        let end = 0;
        if (cookie.length > 0) {
            offset = cookie.indexOf(search);
            if (offset !== -1) {
                offset += search.length;
                end = cookie.indexOf(';', offset);
                if (end === -1) {
                    end = cookie.length;
                }
                setStr = unescape(cookie.substring(offset, end));
            }
        }
        return setStr;
    }
    getCookie(name) {
        if (this.model.options.standaloneJsMode || typeof localStorage === 'undefined' || name.indexOf('sti_') == 0 || name.indexOf('login') == 0) {
            return this.getCookie_(name);
        }
        let value = localStorage.getItem(name);
        if (value != null) {
            return value;
        }
        else {
            value = this.getCookie_(name);
            if (value != null) {
                this.removeCookie(name);
                localStorage.setItem(name, value);
            }
            return value;
        }
    }
    removeCookie(name) {
        document.cookie = name + '=;expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/';
    }
    setCookie(name, value, path, domain, secure, expires) {
        if (this.model.options.standaloneJsMode || typeof localStorage === 'undefined' || name.indexOf('sti_') === 0 || name.indexOf('login') === 0) {
            // save to cookies
            if (value && typeof (value) === 'string' && value.length >= 4096) {
                return;
            }
            const pathName = location.pathname;
            const expDate = new Date();
            expDate.setTime(expDate.getTime() + (365 * 24 * 3600 * 1000));
            document.cookie = name + '=' + escape(value) +
                '; expires=' + (expires || expDate['toGMTString']()) +
                ((path) ? '; path=' + path : '; path=/') +
                ((domain) ? '; domain=' + domain : '') +
                ((secure) ? '; secure' : '');
        }
        else {
            // save to localstorage
            localStorage.setItem(name, value);
        }
    }
    getNavigatorName() {
        if (!navigator) {
            return 'Unknown';
        }
        const userAgent = navigator.userAgent;
        if (userAgent.indexOf('Edge') >= 0) {
            return 'Edge';
        }
        if (userAgent.indexOf('MSIE') >= 0 || userAgent.indexOf('Trident') >= 0) {
            return 'MSIE';
        }
        if (userAgent.indexOf('Gecko') >= 0) {
            if (userAgent.indexOf('Chrome') >= 0) {
                return 'Chrome';
            }
            if (userAgent.indexOf('Safari') >= 0) {
                return 'Safari';
            }
            return 'Mozilla';
        }
        if (userAgent.indexOf('Opera') >= 0) {
            return 'Opera';
        }
    }
    isTouchDevice() {
        return ('ontouchstart' in document.documentElement);
    }
    isMobileDevice() {
        return /iPhone|iPad|iPod|Macintosh|Android|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
    }
    getHumanFileSize(value, decimals) {
        const i = Math.floor(Math.log(value) / Math.log(1024));
        return ((value / Math.pow(1024, i)).toFixed(decimals)) + ' ' + ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'][i];
    }
    getZoomMenuItems() {
        const items = [{ name: 'Zoom25', caption: '25%', img: '' },
            { name: 'Zoom50', caption: '50%', img: '' },
            { name: 'Zoom75', caption: '75%', img: '' },
            { name: 'Zoom100', caption: '100%', img: '' },
            { name: 'Zoom150', caption: '150%', img: '' },
            { name: 'Zoom200', caption: '200%', img: '' }];
        if (this.model.options.toolbar.displayMode !== 'Separated') {
            items.push({ type: 'separator' });
            items.push({ name: 'ZoomOnePage', caption: this.model.loc('ZoomOnePage'), img: 'ZoomOnePage.png' });
            items.push({ name: 'ZoomPageWidth', caption: this.model.loc('ZoomPageWidth'), img: 'ZoomPageWidth.png' });
        }
        return items;
    }
    get helpLinks() {
        return {
            Print: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Save: 'user-manual/index.html?viewer_reports.htm#toolbar',
            SendEmail: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Bookmarks: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Parameters: 'user-manual/index.html?viewer_reports.htm#toolbar',
            FirstPage: 'user-manual/index.html?viewer_reports.htm#statusbar',
            PrevPage: 'user-manual/index.html?viewer_reports.htm#statusbar',
            NextPage: 'user-manual/index.html?viewer_reports.htm#statusbar',
            LastPage: 'user-manual/index.html?viewer_reports.htm#statusbar',
            FullScreen: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Zoom: 'user-manual/index.html?viewer_reports.htm#statusbar',
            ViewMode: 'user-manual/index.html?viewer_reports.htm#displayingmode',
            Editor: 'user-manual/index.html?viewer_reports.htm#toolbar',
            Find: 'user-manual/index.html?viewer_reports.htm#searchpanel',
            DashboardToolbar: 'user-manual/index.html?viewer_dashboards.htm#controlbuttonsofthedashboard',
            DashboardElementToolbar: 'user-manual/index.html?viewer_dashboards.htm#elementcontrols',
            DashboardExport: 'user-manual/index.html?exports_dashboards.htm',
            DashboardPdfExport: 'user-manual/index.html?exports_dashboards.htm#pdfexportsettings',
            DashboardExcelExport: 'user-manual/index.html?exports_dashboards.htm#excelexportsettings',
            DashboardImageExport: 'user-manual/index.html?exports_dashboards.htm#imageexportsettings',
            DashboardDataExport: 'user-manual/index.html?exports_dashboards.htm#exportsettingsofdata'
        };
    }
    getBackText(withoutBrackets) {
        const backText = String.fromCharCode(84) + 'r' + String.fromCharCode(105) + 'a';
        if (withoutBrackets) {
            return backText + String.fromCharCode(108);
        }
        return String.fromCharCode(91) + backText + String.fromCharCode(108) + String.fromCharCode(93);
    }
}
HelperService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: HelperService, deps: [{ token: i1.ModelService }, { token: i2.AnimationService }], target: i0.ɵɵFactoryTarget.Injectable });
HelperService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: HelperService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: HelperService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.AnimationService }]; } });
//# sourceMappingURL=data:application/json;base64,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