import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./page.service";
export class FullScreenService {
    constructor(model, pageService) {
        this.model = model;
        this.pageService = pageService;
    }
    changeFullScreenMode(fullScreenMode) {
        this.model.options.appearance.fullScreenMode = fullScreenMode;
        const viewer = this.model.controls.viewer.el.nativeElement;
        if (fullScreenMode) {
            this.model.fullScreenOptions = {
                scrollbarsMode: this.model.options.appearance.scrollbarsMode,
                zIndex: viewer.style.zIndex,
                position: viewer.style.position,
                width: viewer.style.width,
                height: viewer.style.height,
                overflow: document.body.style.overflow
            };
            this.model.options.appearance.scrollbarsMode = true;
            viewer.style.zIndex = '1000000';
            viewer.style.position = this.model.options.reportDesignerMode ? 'absolute' : 'fixed';
            viewer.style.width = null;
            viewer.style.height = null;
            document.body.style.overflow = 'hidden';
        }
        else if (this.model.fullScreenOptions) {
            this.model.options.appearance.scrollbarsMode = this.model.fullScreenOptions.scrollbarsMode;
            viewer.style.zIndex = this.model.fullScreenOptions.zIndex;
            viewer.style.position = this.model.fullScreenOptions.position;
            viewer.style.width = this.model.fullScreenOptions.width;
            viewer.style.height = this.model.fullScreenOptions.height;
            document.body.style.overflow = this.model.fullScreenOptions.overflow;
            this.model.fullScreenOptions = null;
        }
        this.pageService.calculateLayout();
    }
}
FullScreenService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FullScreenService, deps: [{ token: i1.ModelService }, { token: i2.PageService }], target: i0.ɵɵFactoryTarget.Injectable });
FullScreenService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FullScreenService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FullScreenService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.PageService }]; } });
//# sourceMappingURL=data:application/json;base64,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