import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./helper.service";
import * as i3 from "./animation.service";
export class FindService {
    constructor(model, helper, animationService) {
        this.model = model;
        this.helper = helper;
        this.animationService = animationService;
        this.symbols = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890';
        this.findLabels = [];
        this.text = '';
        this.lastFindText = '';
        this.matchCase = false;
        this.matchWholeWord = false;
        this.findMode = false;
        model.controls.findPanel.getVisibility().subscribe((value) => {
            if (!value) {
                this.hideFindLabels();
                this.lastFindText = '';
            }
        });
    }
    hideFindLabels() {
        this.findLabels.forEach((findLabel) => {
            const parentElement = findLabel.parentElement;
            parentElement.removeChild(findLabel);
            if (parentElement.oldPositionStyle) {
                parentElement.style.position = parentElement.oldPositionStyle;
            }
        });
        this.findLabels = [];
        this.findMode = false;
        this.lastFindText = '';
    }
    selectFindLabel(direction) {
        if (this.findLabels.length === 0) {
            return;
        }
        let selectedIndex = 0;
        const labels = this.findLabels;
        for (let i = 0; i < labels.length; i++) {
            if (labels[i].isSelected) {
                labels[i].setSelected(false);
                selectedIndex = i;
                break;
            }
        }
        if (direction === 'Next') {
            selectedIndex++;
            if (selectedIndex > labels.length - 1) {
                selectedIndex = 0;
            }
        }
        else {
            selectedIndex--;
            if (selectedIndex < 0) {
                selectedIndex = labels.length - 1;
            }
        }
        labels[selectedIndex].setSelected(true);
        this.goToFindedElement(labels[selectedIndex]);
    }
    showFindLabels() {
        this.hideFindLabels();
        this.findMode = true;
        this.lastFindText = this.text;
        const text = this.matchCase ? this.text : this.text.toLowerCase();
        this.model.pages.forEach(page => {
            const pageElements = page.page.getElementsByTagName('*');
            for (const pageElement of pageElements) {
                let innerText = pageElement.innerHTML;
                if (innerText && pageElement.childNodes.length === 1 && pageElement.childNodes[0].nodeName === '#text') {
                    if (!this.matchCase) {
                        innerText = innerText.toLowerCase();
                    }
                    if (innerText.indexOf(text) >= 0) {
                        if (this.matchWholeWord && !this.isWholeWord(innerText, text)) {
                            continue;
                        }
                        const label = document.createElement('div');
                        label.ownerElement = pageElement;
                        label.className = 'stiJsViewerFindLabel';
                        label.style.width = (pageElement.offsetWidth - 4) + 'px';
                        const labelHeight = pageElement.offsetHeight - 4;
                        label.style.height = labelHeight + 'px';
                        label.style.top = '0px';
                        label.style.left = '0px';
                        label.ownerElement.oldPositionStyle = label.ownerElement.style.position;
                        if (label.ownerElement.style.position !== 'absolute' && label.ownerElement.style.position !== 'fixed') {
                            label.ownerElement.style.position = 'relative';
                        }
                        pageElement.insertBefore(label, pageElement.childNodes[0]);
                        label.setSelected = function (state) {
                            this.isSelected = state;
                            this.style.border = '2px solid ' + (state ? 'red' : '#8a8a8a');
                        };
                        if (this.findLabels.length === 0) {
                            label.setSelected(true);
                        }
                        this.findLabels.push(label);
                    }
                }
            }
        });
        if (this.findLabels.length > 0) {
            this.goToFindedElement(this.findLabels[0]);
        }
    }
    goToFindedElement(findLabel) {
        if (findLabel && findLabel.ownerElement) {
            const targetTop = this.helper.findPosY(findLabel.ownerElement, this.model.options.appearance.scrollbarsMode ? 'stiJsViewerReportPanel' : null, true) - findLabel.ownerElement.offsetHeight - 50;
            const d = new Date();
            const endTime = d.getTime() + this.model.options.scrollDuration;
            this.animationService.showAnimationForScroll(this.model.controls.reportPanel.el.nativeElement, targetTop, endTime, () => { });
        }
    }
    isWholeWord(str, word) {
        const index = str.indexOf(word);
        const preSymbol = str.substring(index - 1, index);
        const nextSymbol = str.substring(index + word.length, index + word.length + 1);
        return ((preSymbol === '' || this.symbols.indexOf(preSymbol) === -1) && (nextSymbol === '' || this.symbols.indexOf(nextSymbol) === -1));
    }
}
FindService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindService, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.AnimationService }], target: i0.ɵɵFactoryTarget.Injectable });
FindService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.AnimationService }]; } });
//# sourceMappingURL=data:application/json;base64,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