import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./controller.service";
import * as i2 from "./model.service";
import * as i3 from "./helper.service";
export class EditableFieldsService {
    constructor(controller, model, helper) {
        this.controller = controller;
        this.model = model;
        this.helper = helper;
        this.visible = false;
        this.editableFields = [];
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'Editor':
                    this.visible = !this.visible;
                    if (this.visible) {
                        this.showAllEditableFields();
                    }
                    else {
                        this.hideAllEditableFields();
                    }
                    break;
            }
        });
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetPages' && this.visible) {
                setTimeout(() => this.showAllEditableFields());
            }
            else {
                this.visible = false;
            }
        });
    }
    showAllEditableFields() {
        this.editableFields = [];
        this.model.pages.forEach((page, pageIndex) => {
            const pageElements = page.page.getElementsByTagName('*');
            for (const pageElement of pageElements) {
                const editableStrAttr = pageElement.getAttribute('editable');
                if (editableStrAttr) {
                    const attrArray = editableStrAttr.split(';');
                    const params = {};
                    params.compIndex = attrArray[0];
                    params.pageIndex = this.model.reportParams.viewMode === 'SinglePage' ? this.model.reportParams.pageNumber : pageIndex.toString();
                    params.type = attrArray[1];
                    if (params.type === 'CheckBox') {
                        this.showCheckBoxEditableField(pageElement, params, attrArray);
                    }
                    else if (params.type === 'Text') {
                        this.showTextEditableField(pageElement, params);
                    }
                    else if (params.type === 'RichText') {
                        this.showRichTextEditableField(pageElement, params);
                    }
                }
            }
        });
    }
    hideAllEditableFields() {
        if (this.currentEditableTextArea) {
            this.currentEditableTextArea.onblur();
        }
        this.editableFields.forEach((eField) => {
            eField.className = eField.className.replace(' stiEditableField stiEditableFieldSelected', '');
            eField.onclick = null;
            eField.style.outline = '';
        });
    }
    showCheckBoxEditableField(editableCell, params, attrArray) {
        if (!editableCell.sizes) {
            let imgElements = editableCell.getElementsByTagName('IMG');
            if (imgElements.length === 0) {
                imgElements = editableCell.getElementsByTagName('SVG');
            }
            if (imgElements.length === 0) {
                imgElements = editableCell.getElementsByTagName('svg');
            }
            const imgElement = (imgElements.length > 0) ? imgElements[0] : null;
            if (!imgElement) {
                return;
            }
            if (imgElement.offsetWidth) {
                editableCell.sizes = {
                    inPixels: imgElement.offsetWidth > imgElement.offsetHeight ? imgElement.offsetHeight : imgElement.offsetWidth,
                    widthStyle: imgElement.style.width,
                    heightStyle: imgElement.style.height
                };
            }
            else {
                editableCell.sizes = {
                    inPixels: imgElement.clientWidth > imgElement.clientHeight ? imgElement.clientHeight : imgElement.clientWidth,
                    widthStyle: imgElement.clientWidth + 'px',
                    heightStyle: imgElement.clientHeight + 'px'
                };
            }
        }
        if (this.helper.getNavigatorName() !== 'Google Chrome') {
            editableCell.style.outline = '1px solid gray';
        }
        editableCell.style.textAlign = 'center';
        editableCell.className += ' stiEditableField stiEditableFieldSelected';
        const trueSvgImage = this.getSvgCheckBox(attrArray[3], attrArray[5], this.helper.strToInt(attrArray[6]), attrArray[7], editableCell.sizes.inPixels);
        const falseSvgImage = this.getSvgCheckBox(attrArray[4], attrArray[5], this.helper.strToInt(attrArray[6]), attrArray[7], editableCell.sizes.inPixels);
        params.falseImage = `<div style="width: ${editableCell.sizes.widthStyle}; height: ${editableCell.sizes.heightStyle}; "> ${trueSvgImage}  </div>`;
        params.trueImage = `<div style="width: ${editableCell.sizes.widthStyle}; height: ${editableCell.sizes.heightStyle}; "> ${falseSvgImage} </div>`;
        params.checked = attrArray[2] === 'true' || attrArray[2] === 'True';
        editableCell.params = params;
        if (!editableCell.hasChanged) {
            editableCell.checked = params.checked;
            editableCell.innerHTML = params.checked ? params.trueImage : params.falseImage;
        }
        editableCell.onclick = () => {
            editableCell.checked = !editableCell.checked;
            editableCell.innerHTML = editableCell.checked ? params.trueImage : params.falseImage;
            editableCell.hasChanged = true;
            this.addEditableParameters(editableCell);
        };
        this.editableFields.push(editableCell);
    }
    showTextEditableField(editableCell, params) {
        editableCell.className += ' stiEditableField stiEditableFieldSelected';
        if (this.helper.getNavigatorName() !== 'Google Chrome') {
            editableCell.style.outline = '1px solid gray';
        }
        editableCell.params = params;
        editableCell.jsObject = this;
        editableCell.onclick = () => {
            if (editableCell.editMode) {
                return;
            }
            if (this.currentEditableTextArea) {
                this.currentEditableTextArea.onblur();
            }
            editableCell.editMode = true;
            const textArea = document.createElement('textarea');
            textArea.style.width = (editableCell.offsetWidth - 5) + 'px';
            textArea.style.height = (editableCell.offsetHeight - 5) + 'px';
            textArea.style.maxWidth = (editableCell.offsetWidth - 5) + 'px';
            textArea.style.maxHeight = (editableCell.offsetHeight - 5) + 'px';
            textArea.className = editableCell.className.replace(' stiEditableField stiEditableFieldSelected', '') + ' stiEditableTextArea';
            textArea.style.border = '0px';
            let textContainer = editableCell;
            var includedInnerDiv = function (el) {
                return (el.firstChild && el.firstChild.nodeName && el.firstChild.nodeName.toLowerCase() == "div");
            };
            while (includedInnerDiv(textContainer)) {
                textContainer = textContainer.childNodes[0];
            }
            textArea.value = textContainer.innerHTML.replace(/<br>/g, '\n');
            editableCell.appendChild(textArea);
            textArea.focus();
            this.currentEditableTextArea = textArea;
            textArea.onblur = () => {
                editableCell.editMode = false;
                const newText = textArea.value;
                textContainer.innerHTML = newText.replace(/\n/g, '<br>');
                if (this && textArea.parentNode) {
                    textArea.parentNode.removeChild(textArea);
                }
                this.currentEditableTextArea = null;
                this.addEditableParameters(editableCell, newText);
            };
            let this_ = this;
            let textArea_ = textArea;
            textArea_.getPrevTextField = (index) => {
                if (index > 0) {
                    for (var i = index - 1; i >= 0; i--) {
                        var field = this_.editableFields[i];
                        if (field.params.type == "Text") {
                            return field;
                        }
                    }
                }
                return null;
            };
            textArea_.getNextTextField = (index) => {
                if (index < this_.editableFields.length - 1) {
                    for (var i = index + 1; i < this_.editableFields.length; i++) {
                        var field = this_.editableFields[i];
                        if (field.params.type == "Text") {
                            return field;
                        }
                    }
                }
                return null;
            };
            textArea_.onkeydown = function (e) {
                if (e && e.keyCode == 9) {
                    if (this_.editableFields) {
                        var index = this_.editableFields.indexOf(editableCell);
                        var field = /*this_.SHIFT_pressed ? textArea_.getPrevTextField(index) : */ textArea_.getNextTextField(index);
                        if (field) {
                            e.preventDefault();
                            field.onclick();
                        }
                    }
                }
            };
        };
        this.editableFields.push(editableCell);
    }
    showRichTextEditableField(editableCell, params) {
    }
    addEditableParameters(editableCell, newText) {
        if (!this.model.reportParams.editableParameters) {
            this.model.reportParams.editableParameters = {};
        }
        const params = {};
        params.type = editableCell.params.type;
        if (params.type === 'CheckBox') {
            params.checked = editableCell.checked;
        }
        if (params.type === 'Text') {
            params.text = newText != null ? newText : editableCell.innerHTML;
        }
        if (!this.model.reportParams.editableParameters[editableCell.params.pageIndex]) {
            this.model.reportParams.editableParameters[editableCell.params.pageIndex] = {};
        }
        this.model.reportParams.editableParameters[editableCell.params.pageIndex][editableCell.params.compIndex] = params;
    }
    getSvgCheckBox(style, contourColor, size, backColor, width) {
        const head = `<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0" y="0" width="${width}px" height="${width}px">`;
        const path = `<path stroke="${contourColor}" stroke-width="${size}" fill="${backColor}" stroke-linecap="round" stroke-linejoin="round" transform="scale(${(1 / (200 / width))})" d="`;
        let shape = '';
        switch (style) {
            case 'Cross':
                shape = 'm 62.567796,147.97593 c -0.55,-0.14223 -2.162828,-0.5128 -3.584062,-0.82348 -3.647667,-0.79738 -9.670499,-5.83775 -14.242817,-11.91949 l ' +
                    '-3.902341,-5.19058 5.080199,-1.13481 c 7.353071,-1.64253 13.640456,-5.71752 21.826811,-14.14646 l 7.208128,-7.42171 ' +
                    '-6.410736,-7.513354 c -11.773129,-13.79803 -14.346726,-23.01954 -8.627769,-30.91434 2.894109,-3.9952 11.818482,-12.369333 ' +
                    '13.182086,-12.369333 0.411356,0 1.063049,1.6875 1.448207,3.750003 0.980474,5.25038 6.456187,16.76587 10.936694,23 2.075266,2.8875 ' +
                    '3.991125,5.25 4.257464,5.25 0.266339,0 3.775242,-3.4875 7.797566,-7.75 16.397034,-17.37615 29.674184,-19.76481 38.280564,-6.88699 ' +
                    '4.15523,6.21753 4.18631,8.07093 0.14012,8.3552 -5.84833,0.41088 -17.16241,8.5342 -25.51465,18.319104 l -4.63153,5.42599 ' +
                    '4.87803,4.31529 c 6.55108,5.79533 18.8991,11.89272 25.84076,12.76002 3.0455,0.38051 5.53727,1.10582 5.53727,1.6118 0,2.7809 ' +
                    '-9.26611,14.41872 -13.03,16.36511 -7.96116,4.11687 -16.36991,0.71207 -32.764584,-13.26677 l -4.985957,-4.25125 -7.086791,8.97188 c ' +
                    '-3.897736,4.93454 -8.82141,10.1198 -10.9415,11.52281 -3.906121,2.58495 -8.86588,4.41339 -10.691162,3.94136 z';
                break;
            case 'Check':
                shape = 'M 60.972125,162.49704 C 51.172676,136.72254 43.561975,123.37669 35.370344,117.6027 l -4.45827,-3.14248 2.75159,-2.89559 c 3.875121,-4.07793 ' +
                    '10.034743,-7.49924 14.902472,-8.27747 3.859874,-0.61709 4.458306,-0.38024 8.535897,3.37835 2.660692,2.45254 6.265525,7.60856 9.167226,13.11196 ' +
                    '2.630218,4.98849 4.910542,9.06999 5.067388,9.06999 0.156846,0 2.31372,-3.0375 4.793052,-6.75 C 96.259164,91.956015 129.68299,58.786374 157.56485,41.281603 l ' +
                    '8.84913,-5.555656 2.2633,2.631238 2.26329,2.631237 -7.76266,6.294183 C 139.859,66.19023 108.01682,105.51363 89.042715,138.83563 c -6.680477,11.73214 ' +
                    '-7.172359,12.31296 -15.090788,17.81963 -4.501873,3.13071 -9.044031,6.30443 -10.093684,7.05271 -1.708923,1.21826 -2.010678,1.09165 -2.886118,-1.21093 z';
                break;
            case 'CrossRectangle':
                shape = 'm 24.152542,102.04237 0,-72.499996 74.5,0 74.499998,0 0,72.499996 0,72.5 -74.499998,0 -74.5,0 0,-72.5 z m 133.758188,0.25 -0.25819,-57.249996 ' +
                    '-58.999998,0 -59,0 -0.259695,55.999996 c -0.142833,30.8 -0.04446,56.5625 0.218615,57.25 0.375181,0.98048 13.207991,1.25 59.517885,1.25 l ' +
                    '59.039573,0 -0.25819,-57.25 z m -90.574091,43.18692 c -1.823747,-0.3912 -4.926397,-1.85716 -6.894778,-3.25768 -3.319254,-2.36169 -12.289319,-12.40741 ' +
                    '-12.289319,-13.76302 0,-0.32888 2.417494,-1.13897 5.372209,-1.80021 7.185193,-1.60797 13.747505,-5.93496 21.803114,-14.3763 l 6.675323,-6.99496 ' +
                    '-6.379078,-7.31436 C 64.931387,85.71231 61.643682,76.29465 65.471903,68.89169 67.054097,65.83207 78.56175,54.542374 80.098251,54.542374 c 0.45744,0 ' +
                    '1.146839,1.6875 1.531997,3.75 0.980474,5.250386 6.456187,16.765876 10.936694,22.999996 2.075266,2.8875 3.991125,5.25 4.257464,5.25 0.266339,0 ' +
                    '3.775244,-3.4875 7.797564,-7.75 16.39704,-17.376139 29.67419,-19.764806 38.28057,-6.88698 4.15523,6.21752 4.18631,8.07092 0.14012,8.35519 -5.82996,0.40959 ' +
                    '-18.23707,9.34942 -25.91566,18.67328 -3.90068,4.73647 -3.97203,4.95414 -2.2514,6.86861 3.19054,3.54997 13.7039,10.54321 18.97191,12.61967 2.83427,1.11716 ' +
                    '7.43737,2.33421 10.22912,2.70455 2.79175,0.37034 5.07591,0.9956 5.07591,1.38947 0,2.11419 -8.37504,13.20895 -11.6517,15.4355 -8.39423,5.70403 ' +
                    '-16.63203,2.77 -34.14289,-12.16054 l -4.985955,-4.25125 -7.086791,8.97188 c -9.722344,12.3085 -16.524852,16.55998 -23.948565,14.96754 z';
                break;
            case 'CheckRectangle':
                shape = 'm 19.915254,103.5 0,-72.5 71.942245,0 71.942241,0 6.55727,-4.11139 6.55726,-4.11139 1.96722,2.36139 c 1.08197,1.298765 1.98219,2.644166 2.00049,2.98978 ' +
                    '0.0183,0.345615 -2.44173,2.53784 -5.46673,4.87161 l -5.5,4.243219 0,69.378391 0,69.37839 -74.999991,0 -75.000005,0 0,-72.5 z m 133.999996,3.87756 c ' +
                    '0,-49.33933 -0.12953,-53.514947 -1.62169,-52.276568 -2.78014,2.307312 -15.68408,17.90053 -24.32871,29.399008 -10.4919,13.955575 -23.47926,33.53736 ' +
                    '-29.514025,44.5 -4.457326,8.09707 -5.134776,8.80812 -14.291256,15 -5.28667,3.575 -9.903486,6.62471 -10.259592,6.77712 -0.356107,0.15242 -1.912439,-2.99758 ' +
                    '-3.458515,-7 -1.546077,-4.00241 -5.258394,-12.41205 -8.249593,-18.68809 -4.285436,-8.99155 -6.676569,-12.64898 -11.27758,-17.25 C 47.70282,104.62757 ' +
                    '44.364254,102 43.495254,102 c -2.798369,0 -1.704872,-1.66044 3.983717,-6.049158 5.593548,-4.31539 13.183139,-7.091307 16.801313,-6.145133 3.559412,0.930807 ' +
                    '9.408491,8.154973 13.919775,17.192241 l 4.46286,8.94025 4.54378,-6.83321 C 95.518219,96.605618 108.21371,81.688517 125.80695,63.75 L 143.21531,46 l ' +
                    '-53.650021,0 -53.650035,0 0,57.5 0,57.5 59.000005,0 58.999991,0 0,-53.62244 z';
                break;
            case 'CrossCircle':
                shape = 'M 83.347458,173.13597 C 61.069754,168.04956 42.193415,152.8724 32.202285,132.01368 23.4014,113.63986 23.679644,89.965903 32.91889,71.042373 ' +
                    '41.881579,52.685283 60.867647,37.139882 80.847458,31.799452 c 10.235111,-2.735756 31.264662,-2.427393 40.964762,0.600679 26.18668,8.174684 ' +
                    '46.06876,28.926852 51.62012,53.879155 2.43666,10.952327 1.56754,28.058524 -1.98036,38.977594 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 ' +
                    '-6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033911,0.23456 -15.484931,-0.10267 -19.500002,-1.01939 z M 112.4138,158.45825 c 17.13137,-3.13002 ' +
                    '33.71724,-15.96081 41.41353,-32.03742 14.8975,-31.119027 -1.10807,-67.659584 -34.40232,-78.540141 -6.71328,-2.193899 -9.93541,-2.643501 ' +
                    '-19.07755,-2.661999 -9.354252,-0.01893 -12.16228,0.37753 -18.768532,2.649866 -17.155451,5.900919 -29.669426,17.531424 -36.438658,33.866137 ' +
                    '-2.152301,5.193678 -2.694658,8.35455 -3.070923,17.89744 -0.518057,13.139047 0.741843,19.201887 6.111644,29.410237 4.106815,7.80733 15.431893,19.09359 ' +
                    '23.36818,23.28808 12.061362,6.37467 27.138828,8.6356 40.864629,6.1278 z M 69.097458,133.41654 c -2.8875,-2.75881 -5.25,-5.35869 -5.25,-5.77751 ' +
                    '0,-0.41882 5.658529,-6.30954 12.57451,-13.0905 l 12.57451,-12.329 L 76.198053,89.392633 63.399628,76.565738 68.335951,71.554056 c 2.714978,-2.756426 ' +
                    '5.304859,-5.011683 5.75529,-5.011683 0.450432,0 6.574351,5.611554 13.608709,12.470121 l 12.78974,12.470119 4.42889,-4.553471 c 2.43588,-2.50441 ' +
                    '8.39186,-8.187924 13.23551,-12.630032 l 8.80663,-8.076559 5.34744,5.281006 5.34743,5.281007 -12.96155,12.557899 -12.96154,12.557897 13.13318,13.16027 ' +
                    '13.13319,13.16027 -5.18386,4.66074 c -2.85112,2.5634 -5.70472,4.66073 -6.34134,4.66073 -0.63661,0 -6.5434,-5.4 -13.12621,-12 -6.58281,-6.6 -12.3871,-12 ' +
                    '-12.89844,-12 -0.511329,0 -6.593363,5.60029 -13.515627,12.44509 l -12.585935,12.44508 -5.25,-5.016 z';
                break;
            case 'DotCircle':
                shape = 'M 81.652542,170.5936 C 59.374838,165.50719 40.498499,150.33003 30.507369,129.47131 21.706484,111.09749 21.984728,87.42353 31.223974,68.5 ' +
                    '40.186663,50.14291 59.172731,34.597509 79.152542,29.257079 89.387653,26.521323 110.4172,26.829686 120.1173,29.857758 c 26.18668,8.174684 ' +
                    '46.06876,28.926852 51.62012,53.879152 2.43666,10.95233 1.56754,28.05853 -1.98036,38.9776 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 ' +
                    '-6.3909,2.08202 -10.18566,2.59644 -21.27805,2.88446 -9.033907,0.23456 -15.484927,-0.10267 -19.499998,-1.01939 z m 29.999998,-15.098 c 20.68862,-4.34363 ' +
                    '38.01874,-20.45437 44.09844,-40.9956 2.36228,-7.9813 2.36228,-22.0187 0,-30 C 150.08927,65.371023 134.63549,50.297336 114.65254,44.412396 ' +
                    '106.5531,42.027127 90.741304,42.026386 82.695253,44.4109 62.460276,50.407701 46.686742,66.039241 41.6053,85.13096 c -1.948821,7.32201 -1.86506,23.11641 ' +
                    '0.158766,29.93754 8.730326,29.42481 38.97193,46.91812 69.888474,40.4271 z M 90.004747,122.6703 C 76.550209,117.63801 69.825047,101.82445 ' +
                    '75.898143,89.5 c 2.136718,-4.33615 7.147144,-9.356192 11.754399,-11.776953 5.578622,-2.931141 16.413098,-2.927504 22.052908,0.0074 18.03,9.382663 ' +
                    '19.07573,32.784373 1.91442,42.841563 -5.57282,3.26589 -15.830952,4.2617 -21.615123,2.09829 z';
                break;
            case 'DotRectangle':
                shape = 'm 23.847458,101.19491 0,-72.499995 74.5,0 74.499992,0 0,72.499995 0,72.5 -74.499992,0 -74.5,0 0,-72.5 z m 133.999992,-0.008 0,-57.507925 ' +
                    '-59.249992,0.25793 -59.25,0.25793 -0.25819,57.249995 -0.258189,57.25 59.508189,0 59.508182,0 0,-57.50793 z m -94.320573,33.85402 c -0.37368,-0.37368 ' +
                    '-0.679419,-15.67942 -0.679419,-34.01275 l 0,-33.333335 35.513302,0 35.51329,0 -0.2633,33.749995 -0.2633,33.75 -34.570573,0.26275 c -19.013819,0.14452 ' +
                    '-34.876319,-0.043 -35.25,-0.41666 z';
                break;
            case 'NoneCircle':
                shape = 'M 83.5,170.5936 C 61.222296,165.50719 42.345957,150.33003 32.354827,129.47131 23.553942,111.09749 23.832186,87.423523 33.071432,68.5 ' +
                    '42.034121,50.14291 61.020189,34.597509 81,29.257079 c 10.235111,-2.735756 31.26466,-2.427393 40.96476,0.600679 26.18668,8.174684 46.06876,28.926852 ' +
                    '51.62012,53.879155 2.43666,10.95232 1.56754,28.058527 -1.98036,38.977597 -6.65679,20.48707 -25.64801,38.95163 -47.32647,46.01402 -6.3909,2.08202 ' +
                    '-10.18566,2.59644 -21.27805,2.88446 -9.033909,0.23456 -15.484929,-0.10267 -19.5,-1.01939 z m 30,-15.098 c 20.68862,-4.34363 38.01874,-20.45437 ' +
                    '44.09844,-40.9956 2.36228,-7.9813 2.36228,-22.018707 0,-29.999997 C 151.93673,65.371023 136.48295,50.297336 116.5,44.412396 108.40056,42.027127 ' +
                    '92.588762,42.026386 84.542711,44.410896 64.307734,50.407697 48.5342,66.039237 43.452758,85.130959 c -1.948821,7.322 -1.86506,23.116411 ' +
                    '0.158766,29.937541 8.730326,29.42481 38.97193,46.91812 69.888476,40.4271 z';
                break;
            case 'NoneRectangle':
                shape = 'm 24.152542,102.04237 0,-72.499997 74.5,0 74.500008,0 0,72.499997 0,72.5 -74.500008,0 -74.5,0 0,-72.5 z m 133.758198,0.25 ' +
                    '-0.25819,-57.249997 -59.000008,0 -59,0 -0.259695,55.999997 c -0.142833,30.8 -0.04446,56.5625 0.218615,57.25 0.375181,0.98048 ' +
                    '13.207991,1.25 59.517885,1.25 l 59.039583,0 -0.25819,-57.25 z';
                break;
        }
        return head + path + shape + '" /></svg>';
    }
}
EditableFieldsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: EditableFieldsService, deps: [{ token: i1.ControllerService }, { token: i2.ModelService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
EditableFieldsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: EditableFieldsService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: EditableFieldsService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ControllerService }, { type: i2.ModelService }, { type: i3.HelperService }]; } });
//# sourceMappingURL=data:application/json;base64,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