import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./controller.service";
import * as i2 from "./model.service";
import * as i3 from "./helper.service";
export class DrillDownService {
    constructor(controller, model, helper) {
        this.controller = controller;
        this.model = model;
        this.helper = helper;
        controller.getMessage().subscribe((message) => {
            if (message.action !== 'InitVars' && message.action !== 'viewer_loaded') {
                this.model.options.drillDownInProgress = false;
                const parameters = message.data;
                if (this.model.drillDownButtons.length === 0) {
                    this.addButton(parameters.reportFileName, {});
                }
                if (message.action === 'DrillDown') {
                    const useDbsDrillDownPanel = false; // jsObject.controls.dashboardsPanel && jsObject.controls.dashboardsPanel.visible && jsObject.controls.dashboardsPanel.selectedButton;
                    if (useDbsDrillDownPanel) {
                        // jsObject.controls.dashboardsPanel.addDrillDownButton(null, parameters.drillDownGuid, parameters.drillDownParameters, parameters.previewSettings, parameters.reportFileName);
                    }
                    this.showDrillDownPage(parameters.reportFileName, parameters.drillDownGuid, parameters.drillDownParameters, useDbsDrillDownPanel);
                }
            }
        });
    }
    showDrillDownPage(reportFileName, drillDownGuid, drillDownParameters, useDbsDrillDownPanel) {
        if (useDbsDrillDownPanel) {
            return;
        }
        let buttonExist = false;
        this.model.drillDownButtons.forEach((b) => {
            if (b.reportParams.drillDownGuid === drillDownGuid) {
                this.model.drillDownButtons.forEach(bt => bt.selected = false);
                buttonExist = b.selected = b.visible = true;
                this.model.reportParams.drillDownParameters = b.reportParams.drillDownParameters;
            }
        });
        if (!buttonExist) {
            this.addButton(reportFileName);
            this.model.reportParams.drillDownParameters = drillDownParameters;
            this.model.reportParams.pageNumber = 0;
            this.model.reportParams.pagesWidth = 0;
            this.model.reportParams.pagesHeight = 0;
        }
    }
    addButton(caption, reportParams = {}) {
        this.model.drillDownButtons.forEach(b => b.selected = false);
        this.model.drillDownButtons.push({ caption, selected: true, reportParams, visible: true });
        this.updateVisibility();
    }
    updateVisibility() {
        this.model.controls.drillDownPanel.visible = this.model.drillDownButtons.length > 1;
    }
    saveState() {
        const sButton = this.model.drillDownButtons.find(b => b.selected);
        if (sButton) {
            sButton.reportParams = this.model.getReportParams();
        }
    }
}
DrillDownService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownService, deps: [{ token: i1.ControllerService }, { token: i2.ModelService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Injectable });
DrillDownService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ControllerService }, { type: i2.ModelService }, { type: i3.HelperService }]; } });
//# sourceMappingURL=data:application/json;base64,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