import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "./http-client.service";
import * as i2 from "./model.service";
import * as i3 from "./styles.service";
import * as i4 from "./page.service";
import * as i5 from "./helper.service";
import * as i6 from "../forms/form.service";
import * as i7 from "./full-screen.service";
import * as i8 from "../menu/menu.service";
import * as i9 from "./animation.service";
export class ControllerService {
    constructor(httpClient, model, stylesService, pageService, helper, formService, fullScreenService, menuService, styleService, animationService) {
        this.httpClient = httpClient;
        this.model = model;
        this.stylesService = stylesService;
        this.pageService = pageService;
        this.helper = helper;
        this.formService = formService;
        this.fullScreenService = fullScreenService;
        this.menuService = menuService;
        this.styleService = styleService;
        this.animationService = animationService;
        this.subject = new Subject();
        this.actionSubject = new Subject();
        setInterval(() => {
            if (this.model.httpError) {
                if (this.model.httpError.error?.text) {
                    this.showError(this.model.httpError.error?.text);
                }
                else if (this.model.httpError.message) {
                    this.showError(null, this.model.httpError.message);
                }
                else if (this.model.httpError.error instanceof ErrorEvent) {
                    this.showError(this.model.httpError.error.message);
                }
                this.model.httpError = null;
            }
            if (this.model.navigateNode) {
                this.postBookmarkNodeAction(this.model.navigateNode);
                this.model.navigateNode = null;
            }
        }, 250);
        this.setupHandlers();
    }
    setupHandlers() {
        this.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'OpenReport':
                    setTimeout(() => {
                        this.styleService.addCustomFontStyles(message.data?.customFonts);
                        if (this.model.options.appearance.fullScreenMode) {
                            this.fullScreenService.changeFullScreenMode(true);
                        }
                        if (message.data?.stimulsoftFontContent && !this.model.options.stimulsoftFontContentLoaded) {
                            this.model.options.stimulsoftFontContentLoaded = message.data.stimulsoftFontContent;
                            this.styleService.addCustomFontStyles([{
                                    contentForCss: message.data.stimulsoftFontContent,
                                    originalFontFamily: 'Stimulsoft'
                                }]);
                        }
                    });
                    break;
            }
        });
        this.model.controls.bookmarksPanel.getVisibility().subscribe((value) => {
            if (value && this.model.options.isMobileDevice) {
                this.model.controls.parametersPanel.visible = false;
            }
            if (value) {
                this.hideToolbar();
            }
            else {
                this.showToolbar();
            }
        });
        this.model.controls.parametersPanel.getVisibility().subscribe((value) => {
            if (value && this.model.options.isMobileDevice) {
                this.model.controls.bookmarksPanel.visible = false;
            }
            if (value) {
                this.hideToolbar();
            }
            else {
                this.showToolbar();
            }
        });
        this.menuService.getVisibility().subscribe((menu) => {
            this.hideToolbar();
        });
    }
    hideToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            this.model.controls.toolbar.visible = false;
            this.model.controls.navigatePanel.visible = false;
        }
    }
    showToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            this.model.controls.toolbar.visible = true;
            this.model.controls.navigatePanel.visible = true;
            setTimeout(() => {
                this.keepToolbar();
            }, 300);
        }
    }
    keepToolbar() {
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            clearTimeout(this.model.toolbarHideTimer);
            this.model.toolbarHideTimer = setTimeout(() => {
                this.hideToolbar();
            }, 4000);
        }
    }
    getMessage() {
        return this.subject.asObservable();
    }
    getActionMessage() {
        return this.actionSubject.asObservable();
    }
    post(action, cAction, postData, responseType = 'json', subAction) {
        this.model.controls.navigatePanel.enabled = false;
        this.model.controls.toolbar.enabled = false;
        let url;
        if (!cAction) {
            url = this.model.requestUrl.replace('{action}', action === 'GetReport' || this.model.options.server.cacheMode === 'None' ? this.model.options.actions.getReport : this.model.options.actions.viewerEvent);
        }
        else {
            url = this.model.requestUrl.replace('{action}', cAction);
        }
        if (postData) {
            postData.action = action;
        }
        else {
            postData = { action };
        }
        this.httpClient.post(url, this.model.createPostParameters(postData), responseType).subscribe(data => {
            this.model.showProgress = false;
            this.model.controls.navigatePanel.enabled = true;
            this.model.controls.toolbar.enabled = true;
            if (data === 'ServerError:The report is not specified.' && this.model.options?.isReportRecieved) {
                this.model.options.isReportRecieved = false;
                this.model.reportParams.prevPageNumber = this.model.reportParams.pageNumber;
                this.post('GetReport');
                return;
            }
            if (data) {
                this.model.reportParams = data;
                this.startRefreshReportTimer(data.refreshTime);
                if (data.reportDisplayMode) {
                    this.model.options.displayModeFromReport = data.reportDisplayMode;
                }
            }
            this.subject.next({ action, data, subAction });
        });
    }
    loadViewer() {
        const url = this.model.requestUrl.replace('{action}', this.model.action);
        this.httpClient.post(url, this.model.createPostParameters({ action: 'AngularViewerData' }, true, false), 'json').subscribe(data => {
            this.model.clear();
            this.stylesService.setupStyle(atob(data['styles']), 'viewer');
            this.model.options = data;
            this.checkTrExp();
            this.initAutoUpdateCache();
            this.subject.next({ action: 'viewer_loaded' });
            this.getReport();
        });
    }
    getReport() {
        this.model.options.paramsVariablesStartValues = null;
        this.post('GetReport');
    }
    getPages() {
        this.post('GetPages');
    }
    postExport(format, settings, elementName, isDashboardExport = false) {
        const data = {
            action: isDashboardExport ? 'ExportDashboard' : 'ExportReport',
            exportFormat: format,
            exportSettings: settings,
            elementName
        };
        const doc = settings && settings.OpenAfterExport && this.model.options.appearance.openExportedReportWindow === '_blank' ? this.helper.openNewWindow('about:blank', '_blank').document : null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.exportReport), data, doc);
        this.actionSubject.next({ action: 'ExportReport', data });
    }
    loadFile(fileName, content) {
        if (typeof content !== 'string' || content === '') {
            return;
        }
        if (content.indexOf('<?xml') === 0 || content.indexOf('{') === 0) {
            content = btoa(content);
        }
        const data = {
            action: 'OpenReport',
            openingFileName: fileName || 'Report.mdc',
            base64Data: content.indexOf('base64,') > 0 ? content.substr(content.indexOf('base64,') + 7) : content
        };
        if (fileName && (fileName.toLowerCase().indexOf('.mdx') >= 0 || fileName.toLowerCase().indexOf('.mrx') >= 0)) {
            this.formService.showForm('passwordForm', data);
        }
        else {
            this.postOpen(data);
        }
    }
    postOpen(data) {
        this.model.clearViewerState();
        this.model.reportParams.reportFileName = data.openingFileName;
        this.post('OpenReport', this.model.options.actions.openReport, data);
    }
    action(event) {
        switch (event.name) {
            case 'Find':
                this.model.controls.findPanel.visible = !this.model.controls.findPanel.visible;
                return;
            case 'Bookmarks':
                this.model.controls.bookmarksPanel.visible = !this.model.controls.bookmarksPanel.visible;
                return;
            case 'Parameters':
                this.model.controls.parametersPanel.visible = !this.model.controls.parametersPanel.visible;
                return;
            case 'BookmarkAction':
                if (this.model.reportParams.pageNumber === event.bookmarkPage || this.model.reportParams.viewMode !== 'SinglePage') {
                    this.helper.scrollToAnchor(event.bookmarkAnchor, event.componentGuid);
                    return;
                }
                else {
                    this.model.reportParams.pageNumber = event.bookmarkPage;
                    this.model.options.bookmarkAnchor = event.bookmarkAnchor;
                    this.model.options.componentGuid = event.componentGuid;
                }
                break;
            case 'GoToPage':
                this.model.reportParams.pageNumber = event.value;
                this.scrollToPage();
                break;
            case 'FirstPage':
                this.model.reportParams.pageNumber = 0;
                this.scrollToPage();
                break;
            case 'PrevPage':
                this.model.reportParams.pageNumber = Math.max(0, this.model.reportParams.pageNumber - 1);
                this.scrollToPage();
                break;
            case 'NextPage':
                this.model.reportParams.pageNumber = Math.min(this.model.reportParams.pagesCount - 1, this.model.reportParams.pageNumber + 1);
                this.scrollToPage();
                break;
            case 'LastPage':
                this.model.reportParams.pageNumber = this.model.reportParams.pagesCount - 1;
                this.scrollToPage();
                break;
            case 'ViewModeSinglePage':
                this.model.reportParams.viewMode = 'SinglePage';
                break;
            case 'ViewModeContinuous':
                this.model.reportParams.viewMode = 'Continuous';
                break;
            case 'ViewModeMultiplePages':
                this.model.reportParams.viewMode = 'MultiplePages';
                break;
            case 'Zoom25':
                this.model.reportParams.zoom = 25;
                break;
            case 'Zoom50':
                this.model.reportParams.zoom = 50;
                break;
            case 'Zoom75':
                this.model.reportParams.zoom = 75;
                break;
            case 'Zoom100':
                this.model.reportParams.zoom = 100;
                break;
            case 'Zoom150':
                this.model.reportParams.zoom = 150;
                break;
            case 'Zoom200':
                this.model.reportParams.zoom = 200;
                break;
            case 'ZoomOnePage':
            case 'ZoomPageWidth':
                this.model.reportParams.zoom = event.name === 'ZoomPageWidth' ? this.pageService.getZoomByPageWidth() : this.pageService.getZoomByPageHeight();
                break;
            case 'Submit':
                this.model.reportParams.editableParameters = null;
                if (this.model.reportParams.type === 'Report') {
                    this.model.reportParams.pageNumber = 0;
                }
                if (this.model.options.isMobileDevice) {
                    this.model.controls.parametersPanel.visible = false;
                }
                this.actionSubject.next({ action: 'Variables' });
                return;
            case 'Reset':
                if (this.model.options.paramsVariablesStartValues) {
                    this.model.options.paramsVariables = this.model.options.paramsVariablesStartValues;
                }
                this.actionSubject.next({ action: 'Reset' });
                return;
            case 'Editor':
                this.actionSubject.next({ action: 'Editor', data: {} });
                return;
            case 'Resources':
                this.model.controls.resourcesPanel.visible = !this.model.controls.resourcesPanel.visible;
                return;
            case 'PrintPdf':
            case 'PrintWithPreview':
            case 'PrintWithoutPreview':
                this.actionSubject.next({ action: 'Print', data: { format: event.name } });
                return;
            case 'Print':
                let format = 'PrintPdf';
                switch (this.model.options.toolbar.printDestination) {
                    case 'Pdf':
                        format = 'PrintPdf';
                        break;
                    case 'Direct':
                        format = 'PrintWithoutPreview';
                        break;
                    case 'WithPreview':
                        format = 'PrintWithPreview';
                        break;
                }
                this.actionSubject.next({ action: 'Print', data: { format } });
                return;
            case 'Open':
                this.model.openDialogFileMask = null;
                setTimeout(() => {
                    this.model.openDialogFileMask = '.mdc,.mdz,.mdx,.mrt,.mrz,.mrx';
                });
                return;
            case 'ResourceView':
                this.postReportResource(event.value.name, 'View');
                return;
            case 'ResourceSaveFile':
                this.postReportResource(event.value.name, 'SaveFile');
                return;
            case 'FullScreen':
                this.fullScreenService.changeFullScreenMode(!this.model.options.appearance.fullScreenMode);
                return;
            case 'About':
                this.actionSubject.next({ action: 'About' });
                return;
            case 'Pin':
                this.model.options.toolbar.autoHide = !this.model.options.toolbar.autoHide;
                this.pageService.calculateLayout();
                if (this.model.options.toolbar.autoHide) {
                    setTimeout(() => {
                        this.hideToolbar();
                    }, 200);
                }
                return;
            case 'Design':
                this.actionSubject.next({ action: 'Design' });
                break;
            default:
                if (event.name.indexOf('saveMenu') === 0) {
                    this.actionSubject.next({ action: 'Export', data: { format: event.name.substr(8) } });
                    return;
                }
                else if (event.name.indexOf('sendEmailMenu') === 0) {
                    this.actionSubject.next({ action: 'SendEmail', data: { format: event.name.substr(13) } });
                    return;
                }
        }
        this.getPages();
    }
    scrollToPage() {
        if (this.model.reportParams.viewMode === 'Continuous') {
            let panel = this.model.controls.reportPanel.el.nativeElement;
            const endTime = (new Date()).getTime() + this.model.options.scrollDuration;
            let targetTop = this.model.pages[this.model.reportParams.pageNumber].page.offsetTop;
            this.animationService.showAnimationForScroll(panel, targetTop, endTime, () => { });
        }
    }
    showError(message, messageText) {
        let type = 'Error';
        // Check for error in 'ServerError:' string format
        if (message != null && typeof (message) === 'string' && message.substr(0, 12) === 'ServerError:') {
            if (message.length <= 13) {
                messageText = 'An unknown error occurred (the server returned an empty value).';
            }
            else {
                messageText = message.substr(12);
            }
        }
        // Check for error in JSON format
        if (message != null && message.success === false && message.type && message.text) {
            type = message.type;
            messageText = message.text;
        }
        this.model.errorMessage = { error: 'Unknown error', type };
        if (messageText != null) {
            if (messageText === 'The report is not specified.' && !this.model.options.appearance.showReportIsNotSpecifiedMessage) {
                return true;
            }
            this.model.errorMessage = { error: messageText.replace('\n', '<br>'), type };
            if (this.model.images) {
                this.formService.showForm('errorMessageForm');
            }
            else {
                alert(messageText);
            }
            this.actionSubject.next({ action: 'Error' });
            return true;
        }
        return false;
    }
    postReportResource(resourceName, viewType) {
        const data = {
            action: 'ReportResource',
            reportResourceParams: {
                resourceName,
                viewType
            }
        };
        const doc = viewType === 'View' ? this.helper.openNewWindow('about:blank', '_blank').document : null;
        const url = this.model.requestUrl;
        this.httpClient.postForm(url.replace('{action}', this.model.options.actions.viewerEvent), data, doc);
    }
    postBookmarkNodeAction(node) {
        node.selected = true;
        this.action({ name: 'BookmarkAction', bookmarkPage: node.page, bookmarkAnchor: node.url.replace(/\\\'/g, '\'').substr(1), componentGuid: node.compunentGuid });
    }
    viewerResized() {
        this.menuService.closeAllMenus();
    }
    initAutoUpdateCache() {
        if (this.model.options.server.allowAutoUpdateCache) {
            if (this.model.timerAutoUpdateCache) {
                clearInterval(this.model.timerAutoUpdateCache);
            }
            this.model.timerAutoUpdateCache = setInterval(() => this.post('UpdateCache'), this.model.options.server.timeoutAutoUpdateCache);
        }
    }
    startRefreshReportTimer(timeout) {
        if (this.model.refreshReportTimer != null) {
            clearInterval(this.model.refreshReportTimer);
            this.model.refreshReportTimer = null;
        }
        if (timeout && timeout > 0) {
            this.model.refreshReportTimer = setInterval(() => {
                if (!this.model.showProgress) {
                    this.post('Refresh');
                }
            }, timeout * 1000);
        }
    }
    checkTrExp() {
        if (!this.model.options.cloudMode && !this.model.options.serverMode && !this.model.options.standaloneJsMode && !this.model.options.reportDesignerMode && !this.model.options.alternateValid) {
            let buildDate = new Date();
            try {
                buildDate = new Date(this.model.options.buildDate);
            }
            catch { }
            const trDays = Math.floor(((new Date()).getTime() - buildDate.getTime()) / 1000 / 60 / 60 / 24);
            if (trDays > 45) {
                setTimeout(() => {
                    const message = trDays > 60 ? this.model.loc('NoticesYourTrialHasExpired') : this.model.loc('NoticesYouUsingTrialVersion');
                    const image = 'Notifications.Warning.png';
                    const buttonCaption = this.model.loc('ButtonOk');
                    let cancelAction;
                    let action;
                    if (trDays > 60) {
                        action = cancelAction = () => { window.location.href = 'https://www.stimulsoft.com/en/online-store'; };
                    }
                    this.model.notificationFormOptions = { message, image, buttonCaption, cancelAction, action };
                    this.formService.showForm('notificationForm');
                }, 3000);
            }
        }
    }
}
ControllerService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ControllerService, deps: [{ token: i1.StiHttpClientService }, { token: i2.ModelService }, { token: i3.StylesService }, { token: i4.PageService }, { token: i5.HelperService }, { token: i6.FormService }, { token: i7.FullScreenService }, { token: i8.MenuService }, { token: i3.StylesService }, { token: i9.AnimationService }], target: i0.ɵɵFactoryTarget.Injectable });
ControllerService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ControllerService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ControllerService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiHttpClientService }, { type: i2.ModelService }, { type: i3.StylesService }, { type: i4.PageService }, { type: i5.HelperService }, { type: i6.FormService }, { type: i7.FullScreenService }, { type: i8.MenuService }, { type: i3.StylesService }, { type: i9.AnimationService }]; } });
//# sourceMappingURL=data:application/json;base64,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