import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./controller.service";
import * as i3 from "./export.service";
import * as i4 from "./helper.service";
import * as i5 from "./mail.service";
import * as i6 from "./find.service";
export class ApiService {
    constructor(model, controller, exportService, helper, mailService, findService) {
        this.model = model;
        this.controller = controller;
        this.exportService = exportService;
        this.helper = helper;
        this.mailService = mailService;
        this.findService = findService;
        this.EXPORT_FORMATS = ['Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
            'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
            'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'];
    }
    /**
     * The current page number
     */
    get currentPage() {
        return this.model.reportParams.pageNumber;
    }
    set currentPage(value) {
        if (value >= 0 && value < this.model.reportParams.pagesCount) {
            this.model.reportParams.pageNumber = value;
            this.controller.getPages();
        }
    }
    /**
     * The total pages count
     */
    get pageCount() {
        return this.model.reportParams.pageNumber;
    }
    /**
     * The view mode, can be 'SinglePage', 'Continuous' & 'MultiplePages'
     */
    get viewMode() {
        return this.model.reportParams.viewMode;
    }
    set viewMode(value) {
        if (value === 'SinglePage' || value === 'Continuous' || value === 'MultiplePages') {
            this.model.reportParams.viewMode = value;
            this.controller.getPages();
        }
    }
    /**
     * The page zoom in percent
     * From 1 to 1000
     */
    get zoom() {
        return this.model.reportParams.zoom;
    }
    set zoom(value) {
        if (value >= 1 && value <= 1000) {
            this.model.reportParams.zoom = value;
            this.controller.getPages();
        }
    }
    /**
     * Zoom page in height
     */
    zoomPageHeight() {
        this.controller.action({ name: 'ZoomOnePage' });
    }
    /**
     * Zoom page in width
     */
    zoomPageWidth() {
        this.controller.action({ name: 'ZoomPageWidth' });
    }
    /**
     * Print to PDF
     */
    printPdf() {
        this.controller.action({ name: 'PrintPdf' });
    }
    /**
     * Print with preview
     */
    printWithPreview() {
        this.controller.action({ name: 'PrintWithPreview' });
    }
    /**
     * Print without preview
     */
    printWithoutPreview() {
        this.controller.action({ name: 'PrintWithoutPreview' });
    }
    /**
     * Show export form
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportForm(format) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.controller.actionSubject.next({ action: 'Export', data: { format } });
        }
    }
    /**
     * Show export form & email
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     */
    showExportEmailForm(format) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.controller.actionSubject.next({ action: 'SendEmail', data: { format } });
        }
    }
    /**
     * Export report/dashboard to selected format
     * Use default settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     */
    export(format, settings) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            const exportSettings = this.getExportSettings(format, settings);
            this.controller.postExport(format, exportSettings);
        }
    }
    /**
     * Export report/dashboard to seleted format & email
     * Use default settings if not specified
     * Use default email settings if not specified
     *
     * @param format The format to export, can be 'Document', 'Pdf', 'Xps', 'Ppt2007', 'Html', 'Html5', 'Mht', 'Text', 'Rtf', 'Word2007', 'Odt', 'Excel',
     * 'ExcelBinary', 'ExcelXml', 'Excel2007', 'Ods', 'Csv', 'Dbf', 'Dif', 'Sylk', 'Json', 'Xml', 'ImageBmp',
     * 'ImageGif', 'ImageJpeg', 'ImagePcx', 'ImagePng', 'ImageTiff', 'ImageEmf', 'ImageSvg', 'ImageSvgz'
     *
     * @param settings The export settings
     *
     * @param email The email
     *
     * @param message The email message
     *
     * @param subject The email subject
     */
    exportEmail(format, settings, email, subject, message) {
        if (this.EXPORT_FORMATS.some(f => f === format)) {
            this.exportService.exportSettings = this.getExportSettings(format, settings);
            this.exportService.format = format;
            this.mailService.fillDefaults();
            if (email) {
                this.exportService.exportSettings.Email = email;
            }
            if (message) {
                this.exportService.exportSettings.Message = message;
            }
            if (subject) {
                this.exportService.exportSettings.Subject = subject;
            }
            this.mailService.sendMail();
        }
    }
    /**
     * Search text in report
     *
     * @param text text to search
     *
     * @param matchCase
     *
     * @param matchWholeWord
     */
    search(text, matchCase, matchWholeWord) {
        this.findService.text = text;
        this.findService.matchCase = matchCase;
        this.findService.matchWholeWord = matchWholeWord;
        this.findService.showFindLabels();
    }
    /**
     * Select next or previous search
     *
     * @param direction 'Next' or 'Previous'
     *
     */
    selectSearchLabel(direction) {
        this.findService.selectFindLabel(direction);
    }
    /**
     * Hide search
     */
    hideSearchLabels() {
        this.findService.hideFindLabels();
    }
    getExportSettings(format, settings) {
        this.exportService.sendMail = false;
        this.exportService.format = format;
        const exportSettings = this.helper.copyObject(this.exportService.getDefaultExportSettings(format));
        if (settings) {
            Object.keys(settings).forEach(key => exportSettings[key] = settings[key]);
        }
        return exportSettings;
    }
}
ApiService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ApiService, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.ExportService }, { token: i4.HelperService }, { token: i5.MailService }, { token: i6.FindService }], target: i0.ɵɵFactoryTarget.Injectable });
ApiService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ApiService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ApiService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.ExportService }, { type: i4.HelperService }, { type: i5.MailService }, { type: i6.FindService }]; } });
//# sourceMappingURL=data:application/json;base64,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