import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class AnimationService {
    constructor(model) {
        this.model = model;
    }
    showAnimationForScroll(reportPanel, finishScrollTop, endTime, completeFunction) {
        if (!reportPanel) {
            return;
        }
        let currentScrollTop = 0;
        if (this.model.options.appearance.scrollbarsMode) {
            currentScrollTop = reportPanel.scrollTop;
        }
        else {
            currentScrollTop = document.documentElement.scrollTop;
            if (currentScrollTop === 0) {
                currentScrollTop = document.getElementsByTagName('BODY')[0].scrollTop;
            }
        }
        clearTimeout(reportPanel.animationTimer);
        const d = new Date();
        const t = d.getTime();
        let step = Math.round((finishScrollTop - currentScrollTop) / ((Math.abs(endTime - t) + 1) / 30));
        // Last step
        if (Math.abs(step) > Math.abs(finishScrollTop - currentScrollTop)) {
            step = finishScrollTop - currentScrollTop;
        }
        currentScrollTop += step;
        let resultScrollTop;
        if (t < endTime) {
            resultScrollTop = currentScrollTop;
            reportPanel.animationTimer = setTimeout(() => {
                this.showAnimationForScroll(reportPanel, finishScrollTop, endTime, completeFunction);
            }, 30);
        }
        else {
            resultScrollTop = finishScrollTop;
            if (completeFunction) {
                completeFunction();
            }
        }
        if (this.model.options.appearance.scrollbarsMode) {
            reportPanel.scrollTop = resultScrollTop;
        }
        else {
            window.scrollTo(0, resultScrollTop);
        }
    }
}
AnimationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AnimationService, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Injectable });
AnimationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AnimationService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AnimationService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.ModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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