import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "./menu.service";
import * as i3 from "@angular/common";
export class VerticalMenuItemComponent {
    constructor(model, menuService) {
        this.model = model;
        this.menuService = menuService;
        this.styleName = 'stiJsViewerMenuStandartItem';
        this.action = new EventEmitter();
        this.over = false;
        this._enabled = true;
    }
    ngOnInit() { }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    get className() {
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + (this.over ? 'Over' : (this.item?.selected ? 'Selected' : 'Default'))) : this.styleName + 'Disabled') : '';
    }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
    }
    click() {
        if (this._enabled) {
            this.action.emit(this.item);
        }
    }
    get isSmallItem() {
        return this.styleName && this.styleName.indexOf('MenuStandartItem') >= 0;
    }
}
VerticalMenuItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: VerticalMenuItemComponent, deps: [{ token: i1.ModelService }, { token: i2.MenuService }], target: i0.ɵɵFactoryTarget.Component });
VerticalMenuItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: VerticalMenuItemComponent, selector: "sti-vertical-menu-item", inputs: { styleName: "styleName", item: "item", imageSizesWidth: "imageSizesWidth", imageSizesHeight: "imageSizesHeight", enabled: "enabled" }, outputs: { action: "action" }, ngImport: i0, template: `
    <div [style.height]="item?.type == 'DigitalSignature' ? 'auto' :(model.options.isMobileDevice ? '0.4in' : (model.options.isTouchDevice ? '30px' : '24px'))"
         [class]="className"
         [style.width]="item?.type == 'DigitalSignature' ? '100%' :  menuService.getVerticalMenu().width + 'px'"
         [style.lineHeight]="item?.type == 'DigitalSignature' ? 1.3 : null"
         (mouseover)="mouseover()"
         (mouseout)="mouseout()"
         (click)="click()">
         <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%; width: 100%">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                 <td *ngIf="item?.imageName != null && !model.options.appearance.rightToLeft"
                     style="width:22px; min-width = 22px; padding: 0; textAlign: center; lineHeight: 0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     style="padding: 0px 20px 0px 7px; text-align: left; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     style="padding: 8px 20px 8px 8px ; text-align: left; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <!-- right-to-left -->
                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     style="padding: 8px 20px 8px 8px; text-align: right; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     style="padding: 0 7px 0 20px; text-align: right; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.imageName != null && model.options.appearance.rightToLeft"
                     style="width:22px; min-width = 22px; padding: 0; textAlign: center; lineHeight: 0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>
              </tr>
            </tbody>
          </table>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: VerticalMenuItemComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-vertical-menu-item',
                    template: `
    <div [style.height]="item?.type == 'DigitalSignature' ? 'auto' :(model.options.isMobileDevice ? '0.4in' : (model.options.isTouchDevice ? '30px' : '24px'))"
         [class]="className"
         [style.width]="item?.type == 'DigitalSignature' ? '100%' :  menuService.getVerticalMenu().width + 'px'"
         [style.lineHeight]="item?.type == 'DigitalSignature' ? 1.3 : null"
         (mouseover)="mouseover()"
         (mouseout)="mouseout()"
         (click)="click()">
         <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%; width: 100%">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                 <td *ngIf="item?.imageName != null && !model.options.appearance.rightToLeft"
                     style="width:22px; min-width = 22px; padding: 0; textAlign: center; lineHeight: 0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     style="padding: 0px 20px 0px 7px; text-align: left; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.caption != null && !model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     style="padding: 8px 20px 8px 8px ; text-align: left; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <!-- right-to-left -->
                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type == 'DigitalSignature'"
                     style="padding: 8px 20px 8px 8px; text-align: right; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles" [innerHtml]="item?.caption">
                </td>

                <td *ngIf="item?.caption != null && model.options.appearance.rightToLeft && item?.type != 'DigitalSignature'"
                     style="padding: 0 7px 0 20px; text-align: right; white-space: nowrap;"
                     [style.fontSize]="model.options.isMobileDevice ? '0.16in' : ''"
                     class="stiJsViewerClearAllStyles">
                     {{item?.caption}}
                </td>

                <td *ngIf="item?.imageName != null && model.options.appearance.rightToLeft"
                     style="width:22px; min-width = 22px; padding: 0; textAlign: center; lineHeight: 0"
                     class="stiJsViewerClearAllStyles">
                     <img [style.width.px]="(imageSizesWidth ? imageSizesWidth : (isSmallItem ? 16 : 32))"
                          [style.height.px]="(imageSizesHeight ? imageSizesHeight : (isSmallItem ? 16 : 32))"
                          [src]="model.img(item?.imageName)"
                          [style.visible]="model.img(item?.imageName) === '' ? 'none' : ''" />
                </td>
              </tr>
            </tbody>
          </table>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.MenuService }]; }, propDecorators: { styleName: [{
                type: Input
            }], item: [{
                type: Input
            }], imageSizesWidth: [{
                type: Input
            }], imageSizesHeight: [{
                type: Input
            }], action: [{
                type: Output
            }], enabled: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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