import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "@angular/common";
import * as i4 from "../controls/checkbox.component";
import * as i5 from "../controls/parameters/parameter-checkbox.component";
import * as i6 from "./parameter-menu-item.component";
import * as i7 from "./parameter-menu-separator.component";
import * as i8 from "../controls/parameters/parameter-find.component";
export class ParameterMenuNotEditListComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    selectAll() {
        const isAllSelected = this.isAllSelected();
        if (this.menu.params.items) {
            this.menu.params.items.forEach(e => e.isChecked = !isAllSelected);
        }
    }
    isAllSelected() {
        return this.menu.params.items.every(e => e.isChecked);
    }
    check(item) {
        item.isChecked = !item.isChecked;
    }
    closeAction() {
        this.menu.state = 'initialDown';
    }
}
ParameterMenuNotEditListComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuNotEditListComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuNotEditListComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuNotEditListComponent, selector: "sti-parameter-menu-not-edit-list", inputs: { menu: "menu" }, ngImport: i0, template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px; overflow: hidden auto;">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-check-box [captionText]="model.loc('SelectAll')"
                    [margin]="'8px 7px 8px 7px'"
                    [isChecked]="isAllSelected()"
                    (action)="selectAll()" >
                  </sti-check-box>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-checkbox [params]="item"
                                      [captionText]="helper.val(item.value, helper.getStringKey(item.key, menu.params))"
                                      [margin]="'0 5px 0 0'"
                                      [width]="'100%'"
                                      [imageBlockParentWidth]="'1px'"
                                      [isMenuParameter]="true"
                                      (action)="check(item)">
                                  </sti-parameter-checkbox>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                    <sti-parameter-menu-item [padding]="'0px 5px 0px 13px'" (action)="closeAction()">
                      {{model.loc('Close')}}
                    </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }, { kind: "component", type: i5.ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }, { kind: "component", type: i6.ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: i7.ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }, { kind: "component", type: i8.ParameterFindComponent, selector: "sti-parameter-find", inputs: ["variable"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuNotEditListComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-not-edit-list',
                    template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px; overflow: hidden auto;">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-check-box [captionText]="model.loc('SelectAll')"
                    [margin]="'8px 7px 8px 7px'"
                    [isChecked]="isAllSelected()"
                    (action)="selectAll()" >
                  </sti-check-box>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-checkbox [params]="item"
                                      [captionText]="helper.val(item.value, helper.getStringKey(item.key, menu.params))"
                                      [margin]="'0 5px 0 0'"
                                      [width]="'100%'"
                                      [imageBlockParentWidth]="'1px'"
                                      [isMenuParameter]="true"
                                      (action)="check(item)">
                                  </sti-parameter-checkbox>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-separator></sti-parameter-menu-separator>
                </td>
              </tr>

              <tr class="stiJsViewerClearAllStyles">
                <td class="stiJsViewerClearAllStyles">
                    <sti-parameter-menu-item [padding]="'0px 5px 0px 13px'" (action)="closeAction()">
                      {{model.loc('Close')}}
                    </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }]; }, propDecorators: { menu: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFyYW1ldGVyLW1lbnUtbm90LWVkaXQtbGlzdC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LXZpZXdlci1hbmd1bGFyL3NyYy9saWIvbWVudS9wYXJhbWV0ZXItbWVudS1ub3QtZWRpdC1saXN0LmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFVLEtBQUssRUFBRSxNQUFNLGVBQWUsQ0FBQzs7Ozs7Ozs7OztBQThFekQsTUFBTSxPQUFPLGlDQUFpQztJQUk1QyxZQUFtQixLQUFtQixFQUFTLE1BQXFCO1FBQWpELFVBQUssR0FBTCxLQUFLLENBQWM7UUFBUyxXQUFNLEdBQU4sTUFBTSxDQUFlO0lBQUksQ0FBQztJQUV6RSxRQUFRLEtBQUssQ0FBQztJQUVkLFNBQVM7UUFDUCxNQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDM0MsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUU7WUFDMUIsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxTQUFTLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQztTQUNuRTtJQUNILENBQUM7SUFFRCxhQUFhO1FBQ1gsT0FBTyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ3hELENBQUM7SUFFRCxLQUFLLENBQUMsSUFBYztRQUNsQixJQUFJLENBQUMsU0FBUyxHQUFHLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUNuQyxDQUFDO0lBRUQsV0FBVztRQUNULElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxHQUFHLGFBQWEsQ0FBQztJQUNsQyxDQUFDOzs4SEF6QlUsaUNBQWlDO2tIQUFqQyxpQ0FBaUMsa0dBdEVsQzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQW1FVDsyRkFHVSxpQ0FBaUM7a0JBeEU3QyxTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSxrQ0FBa0M7b0JBQzVDLFFBQVEsRUFBRTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQW1FVDtpQkFDRjsrSEFJVSxJQUFJO3NCQUFaLEtBQUsiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCwgSW5wdXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgTWVudSB9IGZyb20gJy4vbWVudS5zZXJ2aWNlJztcclxuaW1wb3J0IHsgTW9kZWxTZXJ2aWNlIH0gZnJvbSAnLi4vc2VydmljZXMvbW9kZWwuc2VydmljZSc7XHJcbmltcG9ydCB7IEhlbHBlclNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9oZWxwZXIuc2VydmljZSc7XHJcbmltcG9ydCB7IFZhcmlhYmxlIH0gZnJvbSAnLi4vc2VydmljZXMvb2JqZWN0cyc7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3N0aS1wYXJhbWV0ZXItbWVudS1ub3QtZWRpdC1saXN0JyxcclxuICB0ZW1wbGF0ZTogYFxyXG4gICAgICA8c3RpLXBhcmFtZXRlci1maW5kICpuZ0lmPVwibWVudS5wYXJhbXMuaXRlbXMubGVuZ3RoID4gMTBcIiBbdmFyaWFibGVdPVwibWVudS5wYXJhbXNcIj48L3N0aS1wYXJhbWV0ZXItZmluZD5cclxuXHJcbiAgICAgIDxzdGktcGFyYW1ldGVyLW1lbnUtc2VwYXJhdG9yICpuZ0lmPVwibWVudS5wYXJhbXMuaXRlbXMubGVuZ3RoID4gMTBcIj48L3N0aS1wYXJhbWV0ZXItbWVudS1zZXBhcmF0b3I+XHJcblxyXG4gICAgICA8ZGl2IHN0eWxlPVwibWF4LWhlaWdodDogNDAwcHg7IG92ZXJmbG93OiBoaWRkZW4gYXV0bztcIj5cclxuICAgICAgICA8dGFibGUgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzIHN0aUpzVmlld2VyUGFyYW1ldGVyc01lbnVJbm5lclRhYmxlXCIgY2VsbHBhZGRpbmc9XCIwXCIgY2VsbHNwYWNpbmc9XCIwXCJcclxuICAgICAgICAgIFtzdHlsZS5mb250RmFtaWx5XT1cIm1vZGVsLm9wdGlvbnMudG9vbGJhci5mb250RmFtaWx5XCJcclxuICAgICAgICAgIFtzdHlsZS5jb2xvcl09XCJtb2RlbC5vcHRpb25zLnRvb2xiYXIuZm9udENvbG9yXCJcclxuICAgICAgICAgIFtzdHlsZS5mb250U2l6ZV09XCInMTJweCdcIlxyXG4gICAgICAgICAgW3N0eWxlLndpZHRoXT1cIihtZW51LnBhcmVudC5uYXRpdmVFbGVtZW50Lm9mZnNldFdpZHRoIC0gNSkgKyAncHgnXCI+XHJcbiAgICAgICAgICAgIDx0Ym9keT5cclxuICAgICAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICAgIDxzdGktY2hlY2stYm94IFtjYXB0aW9uVGV4dF09XCJtb2RlbC5sb2MoJ1NlbGVjdEFsbCcpXCJcclxuICAgICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cIic4cHggN3B4IDhweCA3cHgnXCJcclxuICAgICAgICAgICAgICAgICAgICBbaXNDaGVja2VkXT1cImlzQWxsU2VsZWN0ZWQoKVwiXHJcbiAgICAgICAgICAgICAgICAgICAgKGFjdGlvbik9XCJzZWxlY3RBbGwoKVwiID5cclxuICAgICAgICAgICAgICAgICAgPC9zdGktY2hlY2stYm94PlxyXG4gICAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgICA8L3RyPlxyXG5cclxuICAgICAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICAgIDxzdGktcGFyYW1ldGVyLW1lbnUtc2VwYXJhdG9yPjwvc3RpLXBhcmFtZXRlci1tZW51LXNlcGFyYXRvcj5cclxuICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgICAgPC90cj5cclxuXHJcbiAgICAgICAgICAgICAgPHRyICpuZ0Zvcj1cImxldCBpdGVtIG9mIG1lbnUucGFyYW1zLml0ZW1zXCIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgW3N0eWxlLmRpc3BsYXldPVwiaXRlbS52aXNpYmxlID8gJycgOiAnbm9uZSdcIj5cclxuICAgICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgICAgPHN0aS1wYXJhbWV0ZXItbWVudS1pdGVtPlxyXG4gICAgICAgICAgICAgICAgICAgICAgPHRhYmxlIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNlbGxwYWRkaW5nPVwiMFwiIGNlbGxzcGFjaW5nPVwiMFwiIHN0eWxlPVwid2lkdGg6IDEwMCVcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgICA8dGJvZHk+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzdGktcGFyYW1ldGVyLWNoZWNrYm94IFtwYXJhbXNdPVwiaXRlbVwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW2NhcHRpb25UZXh0XT1cImhlbHBlci52YWwoaXRlbS52YWx1ZSwgaGVscGVyLmdldFN0cmluZ0tleShpdGVtLmtleSwgbWVudS5wYXJhbXMpKVwiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW21hcmdpbl09XCInMCA1cHggMCAwJ1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW3dpZHRoXT1cIicxMDAlJ1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW2ltYWdlQmxvY2tQYXJlbnRXaWR0aF09XCInMXB4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgW2lzTWVudVBhcmFtZXRlcl09XCJ0cnVlXCJcclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAoYWN0aW9uKT1cImNoZWNrKGl0ZW0pXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3N0aS1wYXJhbWV0ZXItY2hlY2tib3g+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3RyPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgIDwvdGJvZHk+XHJcbiAgICAgICAgICAgICAgICAgICAgICA8L3RhYmxlPlxyXG4gICAgICAgICAgICAgICAgICA8L3N0aS1wYXJhbWV0ZXItbWVudS1pdGVtPlxyXG4gICAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgICA8L3RyPlxyXG5cclxuICAgICAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICAgIDxzdGktcGFyYW1ldGVyLW1lbnUtc2VwYXJhdG9yPjwvc3RpLXBhcmFtZXRlci1tZW51LXNlcGFyYXRvcj5cclxuICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgICAgPC90cj5cclxuXHJcbiAgICAgICAgICAgICAgPHRyIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgICAgPHRkIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgICAgICAgIDxzdGktcGFyYW1ldGVyLW1lbnUtaXRlbSBbcGFkZGluZ109XCInMHB4IDVweCAwcHggMTNweCdcIiAoYWN0aW9uKT1cImNsb3NlQWN0aW9uKClcIj5cclxuICAgICAgICAgICAgICAgICAgICAgIHt7bW9kZWwubG9jKCdDbG9zZScpfX1cclxuICAgICAgICAgICAgICAgICAgICA8L3N0aS1wYXJhbWV0ZXItbWVudS1pdGVtPlxyXG4gICAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgICA8L3RyPlxyXG4gICAgICAgICAgICA8L3Rib2R5PlxyXG4gICAgICAgICAgPC90YWJsZT5cclxuICAgICAgPC9kaXY+XHJcbiAgYFxyXG59KVxyXG5cclxuZXhwb3J0IGNsYXNzIFBhcmFtZXRlck1lbnVOb3RFZGl0TGlzdENvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcblxyXG4gIEBJbnB1dCgpIG1lbnU6IE1lbnU7XHJcblxyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtb2RlbDogTW9kZWxTZXJ2aWNlLCBwdWJsaWMgaGVscGVyOiBIZWxwZXJTZXJ2aWNlKSB7IH1cclxuXHJcbiAgbmdPbkluaXQoKSB7IH1cclxuXHJcbiAgc2VsZWN0QWxsKCkge1xyXG4gICAgY29uc3QgaXNBbGxTZWxlY3RlZCA9IHRoaXMuaXNBbGxTZWxlY3RlZCgpO1xyXG4gICAgaWYgKHRoaXMubWVudS5wYXJhbXMuaXRlbXMpIHtcclxuICAgICAgdGhpcy5tZW51LnBhcmFtcy5pdGVtcy5mb3JFYWNoKGUgPT4gZS5pc0NoZWNrZWQgPSAhaXNBbGxTZWxlY3RlZCk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBpc0FsbFNlbGVjdGVkKCkge1xyXG4gICAgcmV0dXJuIHRoaXMubWVudS5wYXJhbXMuaXRlbXMuZXZlcnkoZSA9PiBlLmlzQ2hlY2tlZCk7XHJcbiAgfVxyXG5cclxuICBjaGVjayhpdGVtOiBWYXJpYWJsZSkge1xyXG4gICAgaXRlbS5pc0NoZWNrZWQgPSAhaXRlbS5pc0NoZWNrZWQ7XHJcbiAgfVxyXG5cclxuICBjbG9zZUFjdGlvbigpIHtcclxuICAgIHRoaXMubWVudS5zdGF0ZSA9ICdpbml0aWFsRG93bic7XHJcbiAgfVxyXG59XHJcbiJdfQ==