import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "../services/interactions.service";
import * as i4 from "@angular/common";
import * as i5 from "./parameter-menu-item.component";
import * as i6 from "./parameter-menu-separator.component";
import * as i7 from "../controls/parameters/parameter-find.component";
export class ParameterMenuForValueComponent {
    constructor(model, helper, intearctionService) {
        this.model = model;
        this.helper = helper;
        this.intearctionService = intearctionService;
    }
    ngOnInit() { }
    action(item) {
        this.menu.params.value = this.menu.params.allowUserValues ? item.key : item.value;
        this.menu.params.key = item.key;
        this.menu.params.isChanged = true;
        this.menu.state = 'initialDown';
        if (this.menu.params.binding) {
            if (!this.model.options.paramsVariablesStartValues) {
                this.model.options.paramsVariablesStartValues = this.helper.copyObject(this.model.options.paramsVariables);
            }
            this.intearctionService.postInteraction({ action: 'InitVars', variables: this.intearctionService.getParametersValues() });
        }
    }
    getValue(item) {
        return (item.value !== '' && this.menu.params.type !== 'DateTime' && this.menu.params.type !== 'TimeSpan')
            ? item.value
            : this.helper.getStringKey(item.key, this.menu.params);
    }
}
ParameterMenuForValueComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuForValueComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.InteractionsService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuForValueComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuForValueComponent, selector: "sti-parameter-menu-for-value", inputs: { menu: "menu" }, ngImport: i0, template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px" [style.overflow]="menu.params.items.length > 10 ? 'hidden auto' : 'hidden'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-menu-item (action)="action(item)">
                                    {{getValue(item)}}
                                  </sti-parameter-menu-item>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: i6.ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }, { kind: "component", type: i7.ParameterFindComponent, selector: "sti-parameter-find", inputs: ["variable"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuForValueComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-for-value',
                    template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px" [style.overflow]="menu.params.items.length > 10 ? 'hidden auto' : 'hidden'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-menu-item (action)="action(item)">
                                    {{getValue(item)}}
                                  </sti-parameter-menu-item>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.InteractionsService }]; }, propDecorators: { menu: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFyYW1ldGVyLW1lbnUtZm9yLXZhbHVlLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtdmlld2VyLWFuZ3VsYXIvc3JjL2xpYi9tZW51L3BhcmFtZXRlci1tZW51LWZvci12YWx1ZS5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBVSxLQUFLLEVBQUUsTUFBTSxlQUFlLENBQUM7Ozs7Ozs7OztBQTRDekQsTUFBTSxPQUFPLDhCQUE4QjtJQUl6QyxZQUFtQixLQUFtQixFQUFTLE1BQXFCLEVBQVMsa0JBQXVDO1FBQWpHLFVBQUssR0FBTCxLQUFLLENBQWM7UUFBUyxXQUFNLEdBQU4sTUFBTSxDQUFlO1FBQVMsdUJBQWtCLEdBQWxCLGtCQUFrQixDQUFxQjtJQUFJLENBQUM7SUFFekgsUUFBUSxLQUFLLENBQUM7SUFFZCxNQUFNLENBQUMsSUFBYztRQUNuQixJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsZUFBZSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQ2xGLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEdBQUcsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDO1FBQ2hDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUM7UUFDbEMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLEdBQUcsYUFBYSxDQUFDO1FBRWhDLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxFQUFFO1lBQzVCLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQywwQkFBMEIsRUFBRTtnQkFDbEQsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsMEJBQTBCLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLENBQUM7YUFDNUc7WUFFRCxJQUFJLENBQUMsa0JBQWtCLENBQUMsZUFBZSxDQUFDLEVBQUUsTUFBTSxFQUFFLFVBQVUsRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLGtCQUFrQixDQUFDLG1CQUFtQixFQUFFLEVBQUUsQ0FBQyxDQUFDO1NBQzNIO0lBRUgsQ0FBQztJQUVELFFBQVEsQ0FBQyxJQUFjO1FBQ3JCLE9BQU8sQ0FBQyxJQUFJLENBQUMsS0FBSyxLQUFLLEVBQUUsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLEtBQUssVUFBVSxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksS0FBSyxVQUFVLENBQUM7WUFDeEcsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLO1lBQ1osQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUMzRCxDQUFDOzsySEE1QlUsOEJBQThCOytHQUE5Qiw4QkFBOEIsOEZBbkMvQjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0FnQ1Q7MkZBR1UsOEJBQThCO2tCQXJDMUMsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsOEJBQThCO29CQUN4QyxRQUFRLEVBQUU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBZ0NUO2lCQUNGO2lLQUlVLElBQUk7c0JBQVosS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgT25Jbml0LCBJbnB1dCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBNZW51IH0gZnJvbSAnLi9tZW51LnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBNb2RlbFNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9tb2RlbC5zZXJ2aWNlJztcclxuaW1wb3J0IHsgSGVscGVyU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL2hlbHBlci5zZXJ2aWNlJztcclxuaW1wb3J0IHsgVmFyaWFibGUgfSBmcm9tICcuLi9zZXJ2aWNlcy9vYmplY3RzJztcclxuaW1wb3J0IHsgSW50ZXJhY3Rpb25zU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL2ludGVyYWN0aW9ucy5zZXJ2aWNlJztcclxuXHJcbkBDb21wb25lbnQoe1xyXG4gIHNlbGVjdG9yOiAnc3RpLXBhcmFtZXRlci1tZW51LWZvci12YWx1ZScsXHJcbiAgdGVtcGxhdGU6IGBcclxuICAgICAgPHN0aS1wYXJhbWV0ZXItZmluZCAqbmdJZj1cIm1lbnUucGFyYW1zLml0ZW1zLmxlbmd0aCA+IDEwXCIgW3ZhcmlhYmxlXT1cIm1lbnUucGFyYW1zXCI+PC9zdGktcGFyYW1ldGVyLWZpbmQ+XHJcblxyXG4gICAgICA8c3RpLXBhcmFtZXRlci1tZW51LXNlcGFyYXRvciAqbmdJZj1cIm1lbnUucGFyYW1zLml0ZW1zLmxlbmd0aCA+IDEwXCI+PC9zdGktcGFyYW1ldGVyLW1lbnUtc2VwYXJhdG9yPlxyXG5cclxuICAgICAgPGRpdiBzdHlsZT1cIm1heC1oZWlnaHQ6IDQwMHB4XCIgW3N0eWxlLm92ZXJmbG93XT1cIm1lbnUucGFyYW1zLml0ZW1zLmxlbmd0aCA+IDEwID8gJ2hpZGRlbiBhdXRvJyA6ICdoaWRkZW4nXCI+XHJcbiAgICAgICAgPHRhYmxlIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlcyBzdGlKc1ZpZXdlclBhcmFtZXRlcnNNZW51SW5uZXJUYWJsZVwiIGNlbGxwYWRkaW5nPVwiMFwiIGNlbGxzcGFjaW5nPVwiMFwiXHJcbiAgICAgICAgICBbc3R5bGUuZm9udEZhbWlseV09XCJtb2RlbC5vcHRpb25zLnRvb2xiYXIuZm9udEZhbWlseVwiXHJcbiAgICAgICAgICBbc3R5bGUuY29sb3JdPVwibW9kZWwub3B0aW9ucy50b29sYmFyLmZvbnRDb2xvclwiXHJcbiAgICAgICAgICBbc3R5bGUuZm9udFNpemVdPVwiJzEycHgnXCJcclxuICAgICAgICAgIFtzdHlsZS53aWR0aF09XCIobWVudS5wYXJlbnQubmF0aXZlRWxlbWVudC5vZmZzZXRXaWR0aCAtIDUpICsgJ3B4J1wiPlxyXG4gICAgICAgICAgICA8dGJvZHk+XHJcbiAgICAgICAgICAgICAgPHRyICpuZ0Zvcj1cImxldCBpdGVtIG9mIG1lbnUucGFyYW1zLml0ZW1zXCIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgW3N0eWxlLmRpc3BsYXldPVwiaXRlbS52aXNpYmxlID8gJycgOiAnbm9uZSdcIj5cclxuICAgICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgICAgPHN0aS1wYXJhbWV0ZXItbWVudS1pdGVtPlxyXG4gICAgICAgICAgICAgICAgICAgICAgPHRhYmxlIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNlbGxwYWRkaW5nPVwiMFwiIGNlbGxzcGFjaW5nPVwiMFwiIHN0eWxlPVwid2lkdGg6IDEwMCVcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgICA8dGJvZHk+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8dHIgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxzdGktcGFyYW1ldGVyLW1lbnUtaXRlbSAoYWN0aW9uKT1cImFjdGlvbihpdGVtKVwiPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB7e2dldFZhbHVlKGl0ZW0pfX1cclxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvc3RpLXBhcmFtZXRlci1tZW51LWl0ZW0+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3RyPlxyXG4gICAgICAgICAgICAgICAgICAgICAgICAgIDwvdGJvZHk+XHJcbiAgICAgICAgICAgICAgICAgICAgICA8L3RhYmxlPlxyXG4gICAgICAgICAgICAgICAgICA8L3N0aS1wYXJhbWV0ZXItbWVudS1pdGVtPlxyXG4gICAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgICA8L3RyPlxyXG4gICAgICAgICAgICA8L3Rib2R5PlxyXG4gICAgICAgICAgPC90YWJsZT5cclxuICAgICAgPC9kaXY+XHJcbiAgYFxyXG59KVxyXG5cclxuZXhwb3J0IGNsYXNzIFBhcmFtZXRlck1lbnVGb3JWYWx1ZUNvbXBvbmVudCBpbXBsZW1lbnRzIE9uSW5pdCB7XHJcblxyXG4gIEBJbnB1dCgpIG1lbnU6IE1lbnU7XHJcblxyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtb2RlbDogTW9kZWxTZXJ2aWNlLCBwdWJsaWMgaGVscGVyOiBIZWxwZXJTZXJ2aWNlLCBwdWJsaWMgaW50ZWFyY3Rpb25TZXJ2aWNlOiBJbnRlcmFjdGlvbnNTZXJ2aWNlKSB7IH1cclxuXHJcbiAgbmdPbkluaXQoKSB7IH1cclxuXHJcbiAgYWN0aW9uKGl0ZW06IFZhcmlhYmxlKSB7XHJcbiAgICB0aGlzLm1lbnUucGFyYW1zLnZhbHVlID0gdGhpcy5tZW51LnBhcmFtcy5hbGxvd1VzZXJWYWx1ZXMgPyBpdGVtLmtleSA6IGl0ZW0udmFsdWU7XHJcbiAgICB0aGlzLm1lbnUucGFyYW1zLmtleSA9IGl0ZW0ua2V5O1xyXG4gICAgdGhpcy5tZW51LnBhcmFtcy5pc0NoYW5nZWQgPSB0cnVlO1xyXG4gICAgdGhpcy5tZW51LnN0YXRlID0gJ2luaXRpYWxEb3duJztcclxuXHJcbiAgICBpZiAodGhpcy5tZW51LnBhcmFtcy5iaW5kaW5nKSB7XHJcbiAgICAgIGlmICghdGhpcy5tb2RlbC5vcHRpb25zLnBhcmFtc1ZhcmlhYmxlc1N0YXJ0VmFsdWVzKSB7XHJcbiAgICAgICAgdGhpcy5tb2RlbC5vcHRpb25zLnBhcmFtc1ZhcmlhYmxlc1N0YXJ0VmFsdWVzID0gdGhpcy5oZWxwZXIuY29weU9iamVjdCh0aGlzLm1vZGVsLm9wdGlvbnMucGFyYW1zVmFyaWFibGVzKTtcclxuICAgICAgfVxyXG5cclxuICAgICAgdGhpcy5pbnRlYXJjdGlvblNlcnZpY2UucG9zdEludGVyYWN0aW9uKHsgYWN0aW9uOiAnSW5pdFZhcnMnLCB2YXJpYWJsZXM6IHRoaXMuaW50ZWFyY3Rpb25TZXJ2aWNlLmdldFBhcmFtZXRlcnNWYWx1ZXMoKSB9KTtcclxuICAgIH1cclxuXHJcbiAgfVxyXG5cclxuICBnZXRWYWx1ZShpdGVtOiBWYXJpYWJsZSkge1xyXG4gICAgcmV0dXJuIChpdGVtLnZhbHVlICE9PSAnJyAmJiB0aGlzLm1lbnUucGFyYW1zLnR5cGUgIT09ICdEYXRlVGltZScgJiYgdGhpcy5tZW51LnBhcmFtcy50eXBlICE9PSAnVGltZVNwYW4nKVxyXG4gICAgICA/IGl0ZW0udmFsdWVcclxuICAgICAgOiB0aGlzLmhlbHBlci5nZXRTdHJpbmdLZXkoaXRlbS5rZXksIHRoaXMubWVudS5wYXJhbXMpO1xyXG4gIH1cclxufVxyXG4iXX0=