import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "@angular/common";
import * as i4 from "./parameter-menu-item.component";
import * as i5 from "./parameter-menu-separator.component";
import * as i6 from "../controls/parameters/parameter-find.component";
export class ParameterMenuForRangeComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    action(item) {
        this.menu.params.key = item.key;
        this.menu.params.keyTo = item.keyTo;
        this.menu.state = 'initialDown';
    }
    getValue(item) {
        return `${item.value} [${this.helper.getStringKey(item.key, this.menu.params)} - ${this.helper.getStringKey(item.keyTo, this.menu.params)}]`;
    }
}
ParameterMenuForRangeComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuForRangeComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuForRangeComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuForRangeComponent, selector: "sti-parameter-menu-for-range", inputs: { menu: "menu" }, ngImport: i0, template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px" [style.overflow]="menu.params.items.length > 10 ? 'hidden auto' : 'hidden'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-menu-item (action)="action(item)">
                                    {{getValue(item)}}
                                  </sti-parameter-menu-item>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: i5.ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }, { kind: "component", type: i6.ParameterFindComponent, selector: "sti-parameter-find", inputs: ["variable"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuForRangeComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-for-range',
                    template: `
      <sti-parameter-find *ngIf="menu.params.items.length > 10" [variable]="menu.params"></sti-parameter-find>

      <sti-parameter-menu-separator *ngIf="menu.params.items.length > 10"></sti-parameter-menu-separator>

      <div style="max-height: 400px" [style.overflow]="menu.params.items.length > 10 ? 'hidden auto' : 'hidden'">
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
          [style.fontFamily]="model.options.toolbar.fontFamily"
          [style.color]="model.options.toolbar.fontColor"
          [style.fontSize]="'12px'"
          [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
            <tbody>
              <tr *ngFor="let item of menu.params.items" class="stiJsViewerClearAllStyles" [style.display]="item.visible ? '' : 'none'">
                <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item>
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%">
                          <tbody>
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                  <sti-parameter-menu-item (action)="action(item)">
                                    {{getValue(item)}}
                                  </sti-parameter-menu-item>
                              </td>
                            </tr>
                          </tbody>
                      </table>
                  </sti-parameter-menu-item>
                </td>
              </tr>
            </tbody>
          </table>
      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }]; }, propDecorators: { menu: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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