import { Component, Input, ViewChild } from '@angular/core';
import { Variable } from '../services/objects';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "./menu.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/parameters/parameter-text-box.component";
import * as i6 from "../controls/parameters/parameter-button.component";
import * as i7 from "./parameter-menu-item.component";
import * as i8 from "./parameter-menu-separator.component";
export class ParameterMenuEditListComponent {
    constructor(model, helper, menuService) {
        this.model = model;
        this.helper = helper;
        this.menuService = menuService;
    }
    ngOnInit() { }
    newItem(event) {
        const item = new Variable();
        if (this.menu.params.type === 'DateTime') {
            item.key = this.helper.getDateTimeObject();
            item.value = this.helper.dateTimeObjectToString(item.key);
        }
        else if (this.menu.params.type === 'TimeSpan') {
            item.key = '00:00:00';
            item.value = '00:00:00';
        }
        else if (this.menu.params.type === 'Bool') {
            item.key = 'False';
            item.value = 'False';
        }
        else {
            item.key = '';
            item.value = '';
        }
        item.focusOnCreate = true;
        if (!this.menu.params.items) {
            this.menu.params.items = [];
        }
        this.menu.params.items.push(item);
        setTimeout(() => {
            item.focusOnCreate = false;
        });
    }
    dateTimeButtonAction(item) {
        this.menuService.addMenu({
            type: 'datePickerMenu', name: 'datePickerMenu', items: [], parent: this.dateTimeButton,
            params: item,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('datePickerMenu');
        });
    }
    guidButtonAction(item) {
        item.key = this.helper.newGuid();
    }
    removeButtonAction(item) {
        this.menu.params.items.splice(this.menu.params.items.indexOf(item), 1);
    }
    removeAllAction() {
        this.menu.params.items.splice(0, this.menu.params.items.length);
    }
    closeAction() {
        this.menu.state = 'initialDown';
    }
}
ParameterMenuEditListComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuEditListComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.MenuService }], target: i0.ɵɵFactoryTarget.Component });
ParameterMenuEditListComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterMenuEditListComponent, selector: "sti-parameter-menu-edit-list", inputs: { menu: "menu" }, viewQueries: [{ propertyName: "dateTimeButton", first: true, predicate: ["dateTimeButton"], descendants: true }], ngImport: i0, template: `
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontSize]="'12px'"
        [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <!--New Item Button -->
                <sti-parameter-menu-item (action)="newItem($event)">
                  {{model.loc('NewItem')}}
                </sti-parameter-menu-item>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-parameter-menu-item *ngFor="let item of menu.params.items" [active]="false">
                  <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                    <tbody>
                      <tr class="stiJsViewerClearAllStyles">
                         <td class="stiJsViewerClearAllStyles" style="padding: 0px 1px 0px 0px;">
                            <sti-parameter-text-box [item]="item" [isMenu]="true"
                              [variable]="menu.params" [focusOnCreate]="item.focusOnCreate">
                            </sti-parameter-text-box>
                         </td>

                         <td *ngIf="menu.params.type == 'DateTime'" class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;" #dateTimeButton>
                           <sti-parameter-button [buttonType]="'DateTimeButton'" (action)="dateTimeButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td *ngIf="menu.params.type == 'Guid'" class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;">
                           <sti-parameter-button [buttonType]="'GuidButton'" (action)="guidButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;">
                           <sti-parameter-button [buttonType]="'RemoveItemButton'" (action)="removeButtonAction(item)" [params]="item">
                           </sti-parameter-button>
                         </td>
                       </tr>
                     </tbody>
                  </table>
                </sti-parameter-menu-item>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item (action)="removeAllAction()">
                      {{model.loc('RemoveAll')}}
                  </sti-parameter-menu-item>

                  <sti-parameter-menu-separator></sti-parameter-menu-separator>

                  <sti-parameter-menu-item (action)="closeAction()">
                      {{model.loc('Close')}}
                  </sti-parameter-menu-item>
              </td>
            </tr>
          </tbody>
        </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: ["item", "variable", "readOnly", "focusOnCreate", "isMenu", "value", "secondTextBox"] }, { kind: "component", type: i6.ParameterButtonComponent, selector: "sti-parameter-button", inputs: ["params", "buttonType"], outputs: ["action"] }, { kind: "component", type: i7.ParameterMenuItemComponent, selector: "sti-parameter-menu-item", inputs: ["active", "padding"], outputs: ["action"] }, { kind: "component", type: i8.ParameterMenuSeparatorComponent, selector: "sti-parameter-menu-separator" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterMenuEditListComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-menu-edit-list',
                    template: `
        <table class="stiJsViewerClearAllStyles stiJsViewerParametersMenuInnerTable" cellpadding="0" cellspacing="0"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontSize]="'12px'"
        [style.width]="(menu.parent.nativeElement.offsetWidth - 5) + 'px'">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <!--New Item Button -->
                <sti-parameter-menu-item (action)="newItem($event)">
                  {{model.loc('NewItem')}}
                </sti-parameter-menu-item>
              </td>
            </tr>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-parameter-menu-item *ngFor="let item of menu.params.items" [active]="false">
                  <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                    <tbody>
                      <tr class="stiJsViewerClearAllStyles">
                         <td class="stiJsViewerClearAllStyles" style="padding: 0px 1px 0px 0px;">
                            <sti-parameter-text-box [item]="item" [isMenu]="true"
                              [variable]="menu.params" [focusOnCreate]="item.focusOnCreate">
                            </sti-parameter-text-box>
                         </td>

                         <td *ngIf="menu.params.type == 'DateTime'" class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;" #dateTimeButton>
                           <sti-parameter-button [buttonType]="'DateTimeButton'" (action)="dateTimeButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td *ngIf="menu.params.type == 'Guid'" class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;">
                           <sti-parameter-button [buttonType]="'GuidButton'" (action)="guidButtonAction(item)">
                           </sti-parameter-button>
                         </td>

                         <td class="stiJsViewerClearAllStyles" style="padding: 0 1px 0 1px;">
                           <sti-parameter-button [buttonType]="'RemoveItemButton'" (action)="removeButtonAction(item)" [params]="item">
                           </sti-parameter-button>
                         </td>
                       </tr>
                     </tbody>
                  </table>
                </sti-parameter-menu-item>
              </td>
            </tr>

            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                  <sti-parameter-menu-item (action)="removeAllAction()">
                      {{model.loc('RemoveAll')}}
                  </sti-parameter-menu-item>

                  <sti-parameter-menu-separator></sti-parameter-menu-separator>

                  <sti-parameter-menu-item (action)="closeAction()">
                      {{model.loc('Close')}}
                  </sti-parameter-menu-item>
              </td>
            </tr>
          </tbody>
        </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.MenuService }]; }, propDecorators: { dateTimeButton: [{
                type: ViewChild,
                args: ['dateTimeButton']
            }], menu: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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