import { Injectable } from '@angular/core';
import { Subject } from 'rxjs';
import * as i0 from "@angular/core";
import * as i1 from "../services/helper.service";
import * as i2 from "../services/model.service";
import * as i3 from "../services/mouse.service";
export class Menu {
    constructor() { }
    get state() {
        return this._state;
    }
    set state(value) {
        let oldState = this._state;
        this._state = value;
        if (oldState != 'initialDown' && oldState != '' && value == 'initialDown' && this.onCloseEvent) {
            this.onCloseEvent();
        }
    }
}
export class MenuService {
    constructor(helper, model, mouseService) {
        this.helper = helper;
        this.model = model;
        this.mouseService = mouseService;
        this.VERTICAL_MENU_NAME = 'verticalMenu';
        this.menuMouseUp = '';
        this._menus = {};
        this.subject = new Subject();
        this.mouseService.getDocumentMouseUp().subscribe((event) => {
            if (this.menuMouseUp === '') {
                this.closeAllMenus();
            }
            else if (this.menuMouseUp !== 'datePickerMenu' && this.menuMouseUp !== this.VERTICAL_MENU_NAME) {
                const datePicker = Object.values(this._menus).find(m => m.type === 'datePickerMenu');
                if (datePicker != null) {
                    datePicker.state = 'initialDown';
                }
            }
            this.menuMouseUp = '';
        });
    }
    getVisibility() {
        return this.subject.asObservable();
    }
    addMenu(menu) {
        let inMenu = new Menu();
        for (let key in menu) {
            inMenu[key] = menu[key];
        }
        this._menus[menu.name] = inMenu;
    }
    closeAllMenus() {
        Object.values(this._menus).forEach((m) => m.state = m.type === 'buttonMenu' && this.model.options.isMobileDevice ? 'initialLeft' : 'initialDown');
    }
    isMenuVisible() {
        return Object.values(this._menus).find(m => m.state === 'expanded') != null;
    }
    showMenu(menuName) {
        const menu = this._menus[menuName];
        if (menu?.type !== 'datePickerMenu' && menu?.type !== this.VERTICAL_MENU_NAME) {
            this.closeAllMenus();
        }
        if (menu) {
            menu.sizeStyle = 'opacity: 0;';
            if (this.model.options.isMobileDevice && menu.type === 'buttonMenu') {
                setTimeout(() => {
                    const innerContent = menu.innerContent.nativeElement;
                    menu.left = 0;
                    menu.top = 0;
                    menu.width = innerContent.offsetWidth;
                    menu.height = innerContent.offsetHeight;
                    menu.state = 'initialLeft';
                    menu.sizeStyle = null;
                    setTimeout(() => {
                        menu.state = 'expanded';
                    });
                });
            }
            else {
                setTimeout(() => {
                    menu.sizeStyle = null;
                    this.showMenuInternal(menu);
                });
            }
            this.subject.next(menu);
        }
    }
    showMenuInternal(menu) {
        const isVertMenu = true;
        const parentButton = menu.parent.nativeElement;
        const innerContent = menu.innerContent.nativeElement;
        const offsetHeight = menu.menuEl.nativeElement.offsetHeight;
        const style = menu.menuEl.nativeElement.style;
        const coords = this.getMenuCoordinates(parentButton, innerContent, offsetHeight, style, isVertMenu);
        menu.left = coords.left;
        menu.top = coords.top;
        menu.width = menu.width || coords.width;
        menu.height = coords.height;
        menu.state = coords.state;
        setTimeout(() => {
            menu.state = 'expanded';
        });
    }
    getMenuCoordinates(parentButton, innerContent, offsetHeight, style, isVertMenu) {
        const menu = {};
        const browserWidth = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
        const browserHeight = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
        const rightAlign = false;
        const mainClassName = 'stiJsViewerMainPanel';
        let animDirect = 'Down';
        const leftOffset = 0;
        let left = (isVertMenu)
            ? (this.model.options.appearance.rightToLeft || rightAlign
                ? (this.helper.findPosX(parentButton, mainClassName) - innerContent.offsetWidth + parentButton.offsetWidth) - (leftOffset || 0)
                : this.helper.findPosX(parentButton, mainClassName) - (leftOffset || 0))
            : ((animDirect === 'Right')
                ? (this.helper.findPosX(parentButton, mainClassName) + parentButton.offsetWidth + 2)
                : (this.helper.findPosX(parentButton, mainClassName) - parentButton.offsetWidth - 2));
        if (left + innerContent.offsetWidth > browserWidth) {
            left = browserWidth - innerContent.offsetWidth - 15;
        }
        if (left < 0) {
            left = 10;
        }
        menu.left = left;
        if (animDirect === 'Down' &&
            this.helper.findPosY(parentButton) + parentButton.offsetHeight + innerContent.offsetHeight > browserHeight &&
            this.helper.findPosY(parentButton) - innerContent.offsetHeight > 0) {
            animDirect = 'Up';
        }
        menu.top = (isVertMenu)
            ? ((animDirect === 'Down')
                ? (this.helper.findPosY(parentButton, mainClassName) + parentButton.offsetHeight + 2)
                : (this.helper.findPosY(parentButton, mainClassName) - offsetHeight))
            : (this.helper.findPosY(parentButton, mainClassName) + parentButton.offsetHeight + innerContent.offsetHeight > browserHeight &&
                (browserHeight - innerContent.offsetHeight - 10) > 0)
                ? (browserHeight - innerContent.offsetHeight - 10)
                : this.helper.findPosY(parentButton, mainClassName);
        menu.width = innerContent.offsetWidth;
        menu.height = innerContent.offsetHeight;
        if (menu.top + innerContent.offsetHeight > browserHeight) {
            menu.top = (browserHeight - innerContent.offsetHeight - 10);
        }
        if (menu.top < 0) {
            menu.top = 10;
        }
        menu.state = animDirect === 'Down' ? 'initialDown' : 'initialUp';
        return menu;
    }
    get menus() {
        return Object.values(this._menus);
    }
    getVerticalMenu() {
        return this._menus[this.VERTICAL_MENU_NAME];
    }
    getMenu(name) {
        return this._menus[name];
    }
}
MenuService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuService, deps: [{ token: i1.HelperService }, { token: i2.ModelService }, { token: i3.MouseService }], target: i0.ɵɵFactoryTarget.Injectable });
MenuService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.HelperService }, { type: i2.ModelService }, { type: i3.MouseService }]; } });
//# sourceMappingURL=data:application/json;base64,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