import { Component, Input, ViewChild } from '@angular/core';
import { trigger, state, style, transition, animate } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
import * as i4 from "./menu.service";
import * as i5 from "@angular/common";
import * as i6 from "./meni-item.component";
import * as i7 from "./parameter-menu-edit-list.component";
import * as i8 from "./parameter-menu-not-edit-list.component";
import * as i9 from "./parameter-menu-for-value.component";
import * as i10 from "./parameter-menu-for-range.component";
import * as i11 from "./date-picker-menu.component";
import * as i12 from "./vertical-menu.component";
import * as i13 from "./double-date-picker-menu.component";
import * as i14 from "./document-security-menu.component";
import * as i15 from "./digital-signature-menu.component copy";
export class MenuComponent {
    constructor(model, controller, helper, menuService) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.menuService = menuService;
        this.style = 'display: none';
        this.overflow = 'hidden';
    }
    ngAfterViewInit() {
        this.menu.menuEl = this.menuEl;
        this.menu.innerContent = this.innerContent;
    }
    ngOnInit() {
    }
    startAnimation(event) {
        if (event.toState === 'expanded') {
            this.style = 'width: 350px; overflow: hidden';
            this.overflow = 'hidden';
        }
    }
    doneAnimation(event) {
        if (event.toState === 'expanded') {
            this.style = 'overflow: visible;';
            this.overflow = this.menu.type.indexOf('parameterMenu') === 0 || this.model.options.isMobileDevice ? 'auto' : 'hidden';
        }
        else if (event.toState === 'initialUp' || event.toState === 'initialDown') {
            this.style = 'display: none';
            this.overflow = 'hidden';
        }
    }
    menuClick(item) {
        this.menuService.closeAllMenus();
        this.controller.action({ name: item.name, value: item.value });
    }
    mouseup() {
        this.menuService.menuMouseUp = this.menu.type;
    }
    get zIndex() {
        return this.menu.type === 'datePickerMenu' ? 36 : (this.menu.type === 'verticalMenu' ? 37 : 35);
    }
}
MenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }, { token: i4.MenuService }], target: i0.ɵɵFactoryTarget.Component });
MenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: MenuComponent, selector: "sti-menu", inputs: { menu: "menu" }, viewQueries: [{ propertyName: "menuEl", first: true, predicate: ["menuEl"], descendants: true }, { propertyName: "innerContent", first: true, predicate: ["innerContent"], descendants: true }], ngImport: i0, template: `
      <div #menuEl class="stiJsViewerParentMenu"
      [style]="menu.sizeStyle || style"
      [style.top.px]="menu.top"
      [style.left.px]="menu.left"
      [style.zIndex]="zIndex"
      [style.height]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : menu.height + 'px'"
      [@.disabled]="!model.options.toolbar.menuAnimation"
      (mouseup)="mouseup()">
        <div #innerContent [style]="{overflowX: 'hidden', overflowY: overflow}"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.maxHeight]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : '450px'"
        [style.height]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : null"
        [@expand]="menu.state || 'initialDown'"
        (@expand.start)="startAnimation($event)"
        (@expand.done)="doneAnimation($event)"
        [class]="helper.val(menu.menuStyleName, 'stiJsViewerMenu')">
            <ng-container *ngIf="menu.type=='buttonMenu'">
              <sti-menu-item *ngFor="let item of menu.items" [item]="item" (click)="menuClick(item)"></sti-menu-item>
            </ng-container>

            <sti-parameter-menu-edit-list *ngIf="menu.type=='parameterMenuForEditList'" [menu]="menu">
            </sti-parameter-menu-edit-list>

            <sti-parameter-menu-not-edit-list *ngIf="menu.type=='parameterMenuForNotEditList'" [menu]="menu">
            </sti-parameter-menu-not-edit-list>

            <sti-parameter-menu-for-value *ngIf="menu.type=='parameterMenuForValue'" [menu]="menu">
            </sti-parameter-menu-for-value>

            <sti-parameter-menu-for-range *ngIf="menu.type=='parameterMenuForRange'" [menu]="menu">
            </sti-parameter-menu-for-range>

            <sti-date-picker-menu *ngIf="menu.type=='datePickerMenu'" [menu]="menu">
            </sti-date-picker-menu>

            <sti-double-date-picker-menu *ngIf="menu.type=='doubleDatePickerMenu'" [menu]="menu">
            </sti-double-date-picker-menu>

            <sti-document-security-menu *ngIf="menu.type=='documentSecurityMenu'">
            </sti-document-security-menu>

            <sti-digital-signature-menu *ngIf="menu.type=='useDigitalSignatureMenu'">
            </sti-digital-signature-menu>

            <sti-vertical-menu *ngIf="menu.type=='verticalMenu'" [menu]="menu">
            </sti-vertical-menu>
        </div>
      </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.MenuItemComponent, selector: "sti-menu-item", inputs: ["item", "styleName", "enabled"] }, { kind: "component", type: i7.ParameterMenuEditListComponent, selector: "sti-parameter-menu-edit-list", inputs: ["menu"] }, { kind: "component", type: i8.ParameterMenuNotEditListComponent, selector: "sti-parameter-menu-not-edit-list", inputs: ["menu"] }, { kind: "component", type: i9.ParameterMenuForValueComponent, selector: "sti-parameter-menu-for-value", inputs: ["menu"] }, { kind: "component", type: i10.ParameterMenuForRangeComponent, selector: "sti-parameter-menu-for-range", inputs: ["menu"] }, { kind: "component", type: i11.DatePickerMenuComponent, selector: "sti-date-picker-menu", inputs: ["menu", "keyTo", "closeOnAction"] }, { kind: "component", type: i12.VerticalMenuComponent, selector: "sti-vertical-menu", inputs: ["menu"] }, { kind: "component", type: i13.DoubleDatePickerMenuComponent, selector: "sti-double-date-picker-menu", inputs: ["menu"] }, { kind: "component", type: i14.DocumentSecurityMenuComponent, selector: "sti-document-security-menu" }, { kind: "component", type: i15.DigitalSignatureMenuComponent, selector: "sti-digital-signature-menu" }], animations: [
        trigger('expand', [
            state('initialDown', style({ transform: 'translateY(-100%)' })),
            state('initialUp', style({ transform: 'translateY(100%)' })),
            state('initialLeft', style({ transform: 'translateX(-100%)' })),
            state('expanded', style({ transform: 'translateY(0) translateX(0)' })),
            transition('initialUp => expanded', [
                animate('150ms ease-in-out')
            ]),
            transition('initialDown => expanded', [
                animate('150ms ease-in-out')
            ]),
            transition('initialLeft => expanded', [
                animate('150ms ease-in-out')
            ]),
            transition('expanded => initialLeft', [
                animate('150ms ease-in-out')
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-menu',
                    template: `
      <div #menuEl class="stiJsViewerParentMenu"
      [style]="menu.sizeStyle || style"
      [style.top.px]="menu.top"
      [style.left.px]="menu.left"
      [style.zIndex]="zIndex"
      [style.height]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : menu.height + 'px'"
      [@.disabled]="!model.options.toolbar.menuAnimation"
      (mouseup)="mouseup()">
        <div #innerContent [style]="{overflowX: 'hidden', overflowY: overflow}"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily"
        [style.maxHeight]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : '450px'"
        [style.height]="menu.type=='buttonMenu' && model.options.isMobileDevice ? '100%' : null"
        [@expand]="menu.state || 'initialDown'"
        (@expand.start)="startAnimation($event)"
        (@expand.done)="doneAnimation($event)"
        [class]="helper.val(menu.menuStyleName, 'stiJsViewerMenu')">
            <ng-container *ngIf="menu.type=='buttonMenu'">
              <sti-menu-item *ngFor="let item of menu.items" [item]="item" (click)="menuClick(item)"></sti-menu-item>
            </ng-container>

            <sti-parameter-menu-edit-list *ngIf="menu.type=='parameterMenuForEditList'" [menu]="menu">
            </sti-parameter-menu-edit-list>

            <sti-parameter-menu-not-edit-list *ngIf="menu.type=='parameterMenuForNotEditList'" [menu]="menu">
            </sti-parameter-menu-not-edit-list>

            <sti-parameter-menu-for-value *ngIf="menu.type=='parameterMenuForValue'" [menu]="menu">
            </sti-parameter-menu-for-value>

            <sti-parameter-menu-for-range *ngIf="menu.type=='parameterMenuForRange'" [menu]="menu">
            </sti-parameter-menu-for-range>

            <sti-date-picker-menu *ngIf="menu.type=='datePickerMenu'" [menu]="menu">
            </sti-date-picker-menu>

            <sti-double-date-picker-menu *ngIf="menu.type=='doubleDatePickerMenu'" [menu]="menu">
            </sti-double-date-picker-menu>

            <sti-document-security-menu *ngIf="menu.type=='documentSecurityMenu'">
            </sti-document-security-menu>

            <sti-digital-signature-menu *ngIf="menu.type=='useDigitalSignatureMenu'">
            </sti-digital-signature-menu>

            <sti-vertical-menu *ngIf="menu.type=='verticalMenu'" [menu]="menu">
            </sti-vertical-menu>
        </div>
      </div>
  `,
                    animations: [
                        trigger('expand', [
                            state('initialDown', style({ transform: 'translateY(-100%)' })),
                            state('initialUp', style({ transform: 'translateY(100%)' })),
                            state('initialLeft', style({ transform: 'translateX(-100%)' })),
                            state('expanded', style({ transform: 'translateY(0) translateX(0)' })),
                            transition('initialUp => expanded', [
                                animate('150ms ease-in-out')
                            ]),
                            transition('initialDown => expanded', [
                                animate('150ms ease-in-out')
                            ]),
                            transition('initialLeft => expanded', [
                                animate('150ms ease-in-out')
                            ]),
                            transition('expanded => initialLeft', [
                                animate('150ms ease-in-out')
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }, { type: i4.MenuService }]; }, propDecorators: { menu: [{
                type: Input
            }], menuEl: [{
                type: ViewChild,
                args: ['menuEl']
            }], innerContent: [{
                type: ViewChild,
                args: ['innerContent']
            }] } });
//# sourceMappingURL=data:application/json;base64,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