import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "@angular/common";
export class MenuItem {
    constructor(name, caption, img, type, selected, imageSize, value) {
        this.name = name;
        this.caption = caption;
        this.img = img;
        this.type = type;
        this.selected = selected;
        this.imageSize = imageSize;
        this.value = value;
    }
}
export class MenuItemComponent {
    constructor(model) {
        this.model = model;
        this.styleName = 'stiJsViewerMenuStandartItem';
        this.selected = false;
        this.over = false;
        this._enabled = true;
    }
    ngOnInit() { }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    mouseover() {
        if (!this.enabled || !this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled || !this.enabled) {
            return;
        }
        this.over = false;
    }
    get height() {
        if (this.item.imageSize === 'Big') {
            return '38px';
        }
        else {
            return this.model.options.isMobileDevice ? '0.4in' : (this.model.options.isTouchDevice ? '30px' : '24px');
        }
    }
    get className() {
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + ((this.selected || this.item.selected) ? 'Selected' : (this.over ? 'Over' : ''))) : this.styleName + 'Disabled') : '';
    }
}
MenuItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuItemComponent, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Component });
MenuItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: MenuItemComponent, selector: "sti-menu-item", inputs: { item: "item", styleName: "styleName", enabled: "enabled" }, ngImport: i0, template: `
    <div *ngIf="item.type!='separator'" [class]="className" (mouseover)="mouseover()"
         (mouseout)="mouseout()" [style.height]="height">
         <table style="height: 100%; width: 100%" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tr class="stiJsViewerClearAllStyles">
                <td *ngIf="item.img != null && !model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" style="width:22px; min-width:22px; padding: 0; text-align:center; line-height: 0;">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>

                <td *ngIf="item.caption != null" class="stiJsViewerClearAllStyles" style="white-space:nowrap"
                  [style.textAlign]="model.options.appearance.rightToLeft ? 'right' : 'left'"
                  [style.padding]="item.imageSize == 'None' ? '0 20px 0 30px' : '0 20px 0 7px'">
                  {{item.caption}}
                </td>

                <td *ngIf="item.img != null && model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" style="width:22px; min-width:22px; padding: 0; text-align:center; line-height: 0;">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>
            </tr>
         </table>
    </div>
    <div *ngIf="item.type=='separator'" class="stiJsViewerVerticalMenuSeparator" [style.margin]="item.imageSize == 'Big' ? '1px 2px 1px 2px' : ''">
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: MenuItemComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-menu-item',
                    template: `
    <div *ngIf="item.type!='separator'" [class]="className" (mouseover)="mouseover()"
         (mouseout)="mouseout()" [style.height]="height">
         <table style="height: 100%; width: 100%" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tr class="stiJsViewerClearAllStyles">
                <td *ngIf="item.img != null && !model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" style="width:22px; min-width:22px; padding: 0; text-align:center; line-height: 0;">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>

                <td *ngIf="item.caption != null" class="stiJsViewerClearAllStyles" style="white-space:nowrap"
                  [style.textAlign]="model.options.appearance.rightToLeft ? 'right' : 'left'"
                  [style.padding]="item.imageSize == 'None' ? '0 20px 0 30px' : '0 20px 0 7px'">
                  {{item.caption}}
                </td>

                <td *ngIf="item.img != null && model.options.appearance.rightToLeft" class="stiJsViewerClearAllStyles" style="width:22px; min-width:22px; padding: 0; text-align:center; line-height: 0;">
                  <img *ngIf="item.img != ''" [style.height.px]="item.imageSize === 'Big' ? 32 : 16" [style.width.px]="item.imageSize === 'Big' ? 32 : 16" src="{{model.img(item.img)}}" />
                </td>
            </tr>
         </table>
    </div>
    <div *ngIf="item.type=='separator'" class="stiJsViewerVerticalMenuSeparator" [style.margin]="item.imageSize == 'Big' ? '1px 2px 1px 2px' : ''">
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }]; }, propDecorators: { item: [{
                type: Input
            }], styleName: [{
                type: Input
            }], enabled: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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