import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "@angular/common";
import * as i4 from "../controls/button.component";
import * as i5 from "./date-picker-menu.component";
export class DoubleDatePickerMenuComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    get showTime() {
        return this.menu?.params?.dateTimeType !== 'Date';
    }
    setTimeInterval(firstDate, secondDate) {
        firstDate.setHours(0);
        firstDate.setMinutes(0);
        firstDate.setSeconds(0);
        secondDate.setHours(23);
        secondDate.setMinutes(59);
        secondDate.setSeconds(59);
    }
    getFirstDayOfWeek() {
        const date = new Date();
        const timeString = date.toLocaleTimeString();
        return (timeString.toLowerCase().indexOf('am') >= 0 || timeString.toLowerCase().indexOf('pm') >= 0 ? 0 : 1);
    }
    getWeekInterval(now) {
        const startDay = this.getFirstDayOfWeek();
        let dayWeek = startDay === 0 ? now.getDay() : now.getDay() - 1;
        if (dayWeek < 0) {
            dayWeek = 6;
        }
        const values = [new Date(now.valueOf() - dayWeek * 86400000)];
        values.push(new Date(values[0].valueOf() + 6 * 86400000));
        this.setTimeInterval(values[0], values[1]);
        return values;
    }
    getValuesByDateRangeName(item) {
        const now = new Date();
        let values = [new Date(), new Date()];
        switch (item) {
            case 'CurrentMonth': {
                values[0].setDate(1);
                values[1].setDate(this.helper.getCountDaysOfMonth(now.getFullYear(), now.getMonth()));
                break;
            }
            case 'CurrentQuarter': {
                const firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3;
                values[0] = new Date(now.getFullYear(), firstMonth, 1);
                values[1] = new Date(now.getFullYear(), firstMonth + 2, this.helper.getCountDaysOfMonth(now.getFullYear(), firstMonth + 2));
                break;
            }
            case 'CurrentWeek': {
                values = this.getWeekInterval(now);
                break;
            }
            case 'CurrentYear': {
                values[0] = new Date(now.getFullYear(), 0, 1);
                values[1] = new Date(now.getFullYear(), 11, 31);
                break;
            }
            case 'NextMonth': {
                let month = now.getMonth() + 1;
                let year = now.getFullYear();
                if (month > 11) {
                    month = 0;
                    year++;
                }
                values[0] = new Date(year, month, 1);
                values[1] = new Date(year, month, this.helper.getCountDaysOfMonth(year, month));
                break;
            }
            case 'NextQuarter': {
                let year = now.getFullYear();
                let firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3 + 3;
                if (firstMonth > 11) {
                    firstMonth = 0;
                    year++;
                }
                values[0] = new Date(year, firstMonth, 1);
                values[1] = new Date(year, firstMonth + 2, this.helper.getCountDaysOfMonth(year, firstMonth + 2));
                break;
            }
            case 'NextWeek': {
                values = this.getWeekInterval(now);
                values[0] = new Date(values[0].valueOf() + 7 * 86400000);
                values[1] = new Date(values[1].valueOf() + 7 * 86400000);
                break;
            }
            case 'NextYear': {
                values[0] = new Date(now.getFullYear() + 1, 0, 1);
                values[1] = new Date(now.getFullYear() + 1, 11, 31);
                break;
            }
            case 'PreviousMonth': {
                let month = now.getMonth() - 1;
                let year = now.getFullYear();
                if (month < 0) {
                    month = 11;
                    year--;
                }
                values[0] = new Date(year, month, 1);
                values[1] = new Date(year, month, this.helper.getCountDaysOfMonth(year, month));
                break;
            }
            case 'PreviousQuarter': {
                let year = now.getFullYear();
                let firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3 - 3;
                if (firstMonth < 0) {
                    firstMonth = 9;
                    year--;
                }
                values[0] = new Date(year, firstMonth, 1);
                values[1] = new Date(year, firstMonth + 2, this.helper.getCountDaysOfMonth(year, firstMonth + 2));
                break;
            }
            case 'PreviousWeek': {
                values = this.getWeekInterval(now);
                values[0] = new Date(values[0].valueOf() - 7 * 86400000);
                values[1] = new Date(values[1].valueOf() - 7 * 86400000);
                break;
            }
            case 'PreviousYear': {
                values[0] = new Date(now.getFullYear() - 1, 0, 1);
                values[1] = new Date(now.getFullYear() - 1, 11, 31);
                break;
            }
            case 'FirstQuarter': {
                values[0] = new Date(now.getFullYear(), 0, 1);
                values[1] = new Date(now.getFullYear(), 2, this.helper.getCountDaysOfMonth(now.getFullYear(), 2));
                break;
            }
            case 'SecondQuarter': {
                values[0] = new Date(now.getFullYear(), 3, 1);
                values[1] = new Date(now.getFullYear(), 5, this.helper.getCountDaysOfMonth(now.getFullYear(), 5));
                break;
            }
            case 'ThirdQuarter': {
                values[0] = new Date(now.getFullYear(), 6, 1);
                values[1] = new Date(now.getFullYear(), 8, this.helper.getCountDaysOfMonth(now.getFullYear(), 8));
                break;
            }
            case 'FourthQuarter': {
                values[0] = new Date(now.getFullYear(), 9, 1);
                values[1] = new Date(now.getFullYear(), 11, this.helper.getCountDaysOfMonth(now.getFullYear(), 11));
                break;
            }
            case 'MonthToDate': {
                values[0].setDate(1);
                break;
            }
            case 'QuarterToDate': {
                const firstMonth = parseInt((now.getMonth() / 3).toString(), 10) * 3;
                values[0].setDate(1);
                values[0].setMonth(firstMonth);
                break;
            }
            case 'WeekToDate': {
                const weekValues = this.getWeekInterval(now);
                values[0] = weekValues[0];
                break;
            }
            case 'YearToDate': {
                values[0].setDate(1);
                values[0].setMonth(0);
                break;
            }
            case 'Today': {
                break;
            }
            case 'Tomorrow': {
                values[0] = new Date(values[0].valueOf() + 86400000);
                values[1] = new Date(values[1].valueOf() + 86400000);
                break;
            }
            case 'Yesterday': {
                values[0] = new Date(values[0].valueOf() - 86400000);
                values[1] = new Date(values[1].valueOf() - 86400000);
                break;
            }
            case 'Last7Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 6 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 7 * 86400000);
                }
                break;
            }
            case 'Last14Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 13 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 14 * 86400000);
                }
                break;
            }
            case 'Last30Days': {
                if (this.model.options.appearance.datePickerIncludeCurrentDayForRanges) {
                    values[0] = new Date(values[0].valueOf() - 29 * 86400000);
                }
                else {
                    values[0] = new Date(values[0].valueOf() - 30 * 86400000);
                }
                break;
            }
        }
        this.setTimeInterval(values[0], values[1]);
        this.menu.params.key = this.helper.getDateTimeObject(values[0]);
        this.menu.params.keyTo = this.helper.getDateTimeObject(values[1]);
    }
}
DoubleDatePickerMenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DoubleDatePickerMenuComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }], target: i0.ɵɵFactoryTarget.Component });
DoubleDatePickerMenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DoubleDatePickerMenuComponent, selector: "sti-double-date-picker-menu", inputs: { menu: "menu" }, ngImport: i0, template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 4px; border: 1px dotted rgb(198, 198, 198);">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="vertical-align: top;">
                  <div style="margin:4px">
                    <sti-date-picker-menu [menu]="menu" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" style="border-left: 1px dotted rgb(198, 198, 198); vertical-align: top;">
                  <div style="margin:4px">
                    <sti-date-picker-menu [menu]="menu" [keyTo]="true" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" style="border-left: 1px dotted rgb(198, 198, 198); vertical-align: top;">
                <div style="width: 150px; overflow: auto; margin: 4px;" [style.height.px]="showTime ? 250 : 220">
                    <ng-container *ngFor="let item of model.dateRanges">
                        <sti-button [caption]="model.loc(item)" (action)="getValuesByDateRangeName(item)">
                        </sti-button>

                        <div *ngIf="item=='Yesterday' || item=='PreviousWeek' || item=='PreviousMonth' || item=='PreviousQuarter' || item=='PreviousYear' || item=='FourthQuarter' || item=='Last30Days'"
                            class="stiJsViewerVerticalMenuSeparator" style="margin:2px"></div>
                    </ng-container>
                </div>
              </td>
            </tr>
          </tbody>
      </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i5.DatePickerMenuComponent, selector: "sti-date-picker-menu", inputs: ["menu", "keyTo", "closeOnAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DoubleDatePickerMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-double-date-picker-menu',
                    template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 4px; border: 1px dotted rgb(198, 198, 198);">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="vertical-align: top;">
                  <div style="margin:4px">
                    <sti-date-picker-menu [menu]="menu" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" style="border-left: 1px dotted rgb(198, 198, 198); vertical-align: top;">
                  <div style="margin:4px">
                    <sti-date-picker-menu [menu]="menu" [keyTo]="true" [closeOnAction]="false">
                    </sti-date-picker-menu>
                  </div>
              </td>

              <td class="stiJsViewerClearAllStyles" style="border-left: 1px dotted rgb(198, 198, 198); vertical-align: top;">
                <div style="width: 150px; overflow: auto; margin: 4px;" [style.height.px]="showTime ? 250 : 220">
                    <ng-container *ngFor="let item of model.dateRanges">
                        <sti-button [caption]="model.loc(item)" (action)="getValuesByDateRangeName(item)">
                        </sti-button>

                        <div *ngIf="item=='Yesterday' || item=='PreviousWeek' || item=='PreviousMonth' || item=='PreviousQuarter' || item=='PreviousYear' || item=='FourthQuarter' || item=='Last30Days'"
                            class="stiJsViewerVerticalMenuSeparator" style="margin:2px"></div>
                    </ng-container>
                </div>
              </td>
            </tr>
          </tbody>
      </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }]; }, propDecorators: { menu: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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