import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../forms/form.service";
import * as i3 from "../services/export.service";
import * as i4 from "../services/collections.service";
import * as i5 from "../controls/text-box.componet";
import * as i6 from "../controls/checkbox.component";
import * as i7 from "../controls/drop-down-list-for-export-form.component";
export class DocumentSecurityMenuComponent {
    constructor(model, formService, exportService, collections) {
        this.model = model;
        this.formService = formService;
        this.exportService = exportService;
        this.collections = collections;
    }
    ngOnInit() { }
    getTextBoxType() {
        return this.formService.form?.name === 'exportForm' ? 'password' : '';
    }
    updateUserAccessPrivileges() {
        const privileges = [];
        if (this.allowPrintDocument.isChecked) {
            privileges.push('PrintDocument');
        }
        if (this.allowModifyContents.isChecked) {
            privileges.push('ModifyContents');
        }
        if (this.allowCopyTextAndGraphics.isChecked) {
            privileges.push('CopyTextAndGraphics');
        }
        if (this.allowAddOrModifyTextAnnotations.isChecked) {
            privileges.push('AddOrModifyTextAnnotations');
        }
        this.exportService.exportSettings.UserAccessPrivileges = privileges.join(',');
    }
    getUserAccessPrivileges(name) {
        return this.exportService.exportSettings?.UserAccessPrivileges === 'All' || this.exportService.exportSettings?.UserAccessPrivileges?.indexOf(name) >= 0;
    }
}
DocumentSecurityMenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DocumentSecurityMenuComponent, deps: [{ token: i1.ModelService }, { token: i2.FormService }, { token: i3.ExportService }, { token: i4.CollectionsService }], target: i0.ɵɵFactoryTarget.Component });
DocumentSecurityMenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DocumentSecurityMenuComponent, selector: "sti-document-security-menu", viewQueries: [{ propertyName: "allowPrintDocument", first: true, predicate: ["AllowPrintDocument"], descendants: true }, { propertyName: "allowModifyContents", first: true, predicate: ["AllowModifyContents"], descendants: true }, { propertyName: "allowCopyTextAndGraphics", first: true, predicate: ["AllowCopyTextAndGraphics"], descendants: true }, { propertyName: "allowAddOrModifyTextAnnotations", first: true, predicate: ["AllowAddOrModifyTextAnnotations"], descendants: true }], ngImport: i0, template: `
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('UserPasswordTooltip')">
                        {{model.loc('UserPassword')}}
                      </td>
                      <td class="stiJsViewerClearAllStyles">
                        <sti-text-box
                           [width]="160"
                           [tooltip]="model.loc('UserPasswordTooltip')"
                           [margin]="'8px 8px 2px 8px'"
                           [type]="getTextBoxType()"
                           [value]="exportService.exportSettings?.PasswordInputUser"
                           (onchange)="exportService.exportSettings.PasswordInputUser =  $event.value">
                        </sti-text-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles" [attr.title]="model.loc('OwnerPasswordTooltip')">
                      <td style="padding: 0px 8px; min-width: 150px;">
                        {{model.loc('OwnerPassword')}}
                      </td>
                      <td class="stiJsViewerClearAllStyles">
                        <sti-text-box
                           [width]="160"
                           [tooltip]="model.loc('OwnerPasswordTooltip')"
                           [margin]="'2px 8px 2px 8px'"
                           [type]="getTextBoxType()"
                           [value]="exportService.exportSettings?.PasswordInputOwner"
                           (onchange)="exportService.exportSettings.PasswordInputOwner =  $event.value">
                        </sti-text-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowPrintDocument
                           [captionText]="model.loc('AllowPrintDocument')"
                           [tooltip]="model.loc('AllowPrintDocumentTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('PrintDocument')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowModifyContents
                           [captionText]="model.loc('AllowModifyContents')"
                           [tooltip]="model.loc('AllowModifyContentsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('ModifyContents')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowCopyTextAndGraphics
                           [captionText]="model.loc('AllowCopyTextAndGraphics')"
                           [tooltip]="model.loc('AllowCopyTextAndGraphicsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('CopyTextAndGraphics')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowAddOrModifyTextAnnotations
                           [captionText]="model.loc('AllowAddOrModifyTextAnnotations')"
                           [tooltip]="model.loc('AllowAddOrModifyTextAnnotationsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('AddOrModifyTextAnnotations')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('EncryptionKeyLengthTooltip')">
                        {{model.loc('EncryptionKeyLength')}}
                      </td>
                      <td>
                        <sti-drop-down-list-for-export-form
                           [width]="160"
                           [items]="collections.getEncryptionKeyLengthItems()"
                           [key]="exportService.exportSettings?.KeyLength"
                           [margin]="'2px 8px 4px 8px'"
                           (action)="exportService.exportSettings.KeyLength = $event.key">
                        </sti-drop-down-list-for-export-form>
                      </td>
                    </tr>
                  </tbody>
                </table>
`, isInline: true, dependencies: [{ kind: "component", type: i5.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i6.CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }, { kind: "component", type: i7.DropDownListForExportFormComponent, selector: "sti-drop-down-list-for-export-form", inputs: ["items", "width", "key", "margin", "enabled", "styleDisplay", "verticalAlign"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DocumentSecurityMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-document-security-menu',
                    template: `
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('UserPasswordTooltip')">
                        {{model.loc('UserPassword')}}
                      </td>
                      <td class="stiJsViewerClearAllStyles">
                        <sti-text-box
                           [width]="160"
                           [tooltip]="model.loc('UserPasswordTooltip')"
                           [margin]="'8px 8px 2px 8px'"
                           [type]="getTextBoxType()"
                           [value]="exportService.exportSettings?.PasswordInputUser"
                           (onchange)="exportService.exportSettings.PasswordInputUser =  $event.value">
                        </sti-text-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles" [attr.title]="model.loc('OwnerPasswordTooltip')">
                      <td style="padding: 0px 8px; min-width: 150px;">
                        {{model.loc('OwnerPassword')}}
                      </td>
                      <td class="stiJsViewerClearAllStyles">
                        <sti-text-box
                           [width]="160"
                           [tooltip]="model.loc('OwnerPasswordTooltip')"
                           [margin]="'2px 8px 2px 8px'"
                           [type]="getTextBoxType()"
                           [value]="exportService.exportSettings?.PasswordInputOwner"
                           (onchange)="exportService.exportSettings.PasswordInputOwner =  $event.value">
                        </sti-text-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowPrintDocument
                           [captionText]="model.loc('AllowPrintDocument')"
                           [tooltip]="model.loc('AllowPrintDocumentTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('PrintDocument')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowModifyContents
                           [captionText]="model.loc('AllowModifyContents')"
                           [tooltip]="model.loc('AllowModifyContentsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('ModifyContents')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowCopyTextAndGraphics
                           [captionText]="model.loc('AllowCopyTextAndGraphics')"
                           [tooltip]="model.loc('AllowCopyTextAndGraphicsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('CopyTextAndGraphics')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>

                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-check-box #AllowAddOrModifyTextAnnotations
                           [captionText]="model.loc('AllowAddOrModifyTextAnnotations')"
                           [tooltip]="model.loc('AllowAddOrModifyTextAnnotationsTooltip')"
                           [margin]="'4px 8px 4px 8px'"
                           [isChecked]="getUserAccessPrivileges('AddOrModifyTextAnnotations')"
                           (action)="updateUserAccessPrivileges()">
                        </sti-check-box>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('EncryptionKeyLengthTooltip')">
                        {{model.loc('EncryptionKeyLength')}}
                      </td>
                      <td>
                        <sti-drop-down-list-for-export-form
                           [width]="160"
                           [items]="collections.getEncryptionKeyLengthItems()"
                           [key]="exportService.exportSettings?.KeyLength"
                           [margin]="'2px 8px 4px 8px'"
                           (action)="exportService.exportSettings.KeyLength = $event.key">
                        </sti-drop-down-list-for-export-form>
                      </td>
                    </tr>
                  </tbody>
                </table>
`
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.FormService }, { type: i3.ExportService }, { type: i4.CollectionsService }]; }, propDecorators: { allowPrintDocument: [{
                type: ViewChild,
                args: ['AllowPrintDocument']
            }], allowModifyContents: [{
                type: ViewChild,
                args: ['AllowModifyContents']
            }], allowCopyTextAndGraphics: [{
                type: ViewChild,
                args: ['AllowCopyTextAndGraphics']
            }], allowAddOrModifyTextAnnotations: [{
                type: ViewChild,
                args: ['AllowAddOrModifyTextAnnotations']
            }] } });
//# sourceMappingURL=data:application/json;base64,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