import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "@angular/common";
import * as i4 from "../controls/button.component";
import * as i5 from "../controls/text-box.componet";
import * as i6 from "../controls/drop-down-list.component";
import * as i7 from "../controls/date-picker-day-button.component";
export class DatePickerMenuComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
        this.keyTo = false;
        this.closeOnAction = true;
        this.monthesForDatePickerItems = [];
        this.cols = [0, 1, 2, 3, 4, 5, 6];
        this.rows = [0, 1, 2, 3, 4, 5];
        this.model.months.forEach((m, i) => this.monthesForDatePickerItems.push({ name: 'Month' + i, caption: this.model.loc('Month' + m), key: i }));
        const firstLetters = {};
        this.model.dayOfWeek.forEach((d) => {
            const dayName = this.model.loc('Day' + d);
            firstLetters[dayName.toString().substring(0, 1).toUpperCase()] = true;
        });
        this.countLetters = Object.keys(firstLetters).length < 5 ? 2 : 1;
    }
    ngOnInit() { }
    getButtonSelected(col, row) {
        const firstDay = this.getFirstDay();
        const curDay = row * 7 + col;
        const day = curDay - firstDay + 1;
        return day === this.key.day;
    }
    getButtonCaption(col, row) {
        const firstDay = this.getFirstDay();
        const daysInMonth = this.helper.getCountDaysOfMonth(this.key.year, this.key.month - 1);
        const curDay = row * 7 + col;
        const day = curDay - firstDay + 1;
        if (curDay >= firstDay && day <= daysInMonth) {
            return day.toString();
        }
        return '';
    }
    getTime() {
        return this.helper.formatDate(this.helper.getDate(this.key), 'H:mm:ss');
    }
    getFirstDay() {
        let firstDay = new Date(this.key.year, this.key.month - 1, 1).getDay();
        if (firstDay === 0) {
            firstDay = 7;
        }
        if (this.model.options.appearance.datePickerFirstDayOfWeek !== 'Sunday') {
            firstDay--;
        }
        return firstDay;
    }
    get showTime() {
        return this.menu?.params?.dateTimeType !== 'Date';
    }
    get key() {
        return this.keyTo ? this.menu.params.keyTo : this.menu.params.key;
    }
    yearAction(input) {
        try {
            this.key.year = parseInt(input.value, 10);
        }
        catch { }
    }
    timeAction(input) {
        const time = this.helper.stringToTime(input.value);
        this.key.seconds = time.seconds;
        this.key.minutes = time.minutes;
        this.key.hours = time.hours;
    }
    getShortDayName(index) {
        const dayName = this.model.loc('Day' + this.model.dayOfWeek[index]);
        if (dayName) {
            return dayName.toString().substring(0, this.countLetters <= dayName.length ? this.countLetters : 1).toUpperCase();
        }
        return '';
    }
    getShortDayColor(index) {
        if (index === (this.model.options.appearance.datePickerFirstDayOfWeek === 'Sunday' ? 6 : 5)) {
            return '#0000ff';
        }
        if (index === (this.model.options.appearance.datePickerFirstDayOfWeek === 'Sunday' ? 0 : 6)) {
            return '#ff0000';
        }
        return '';
    }
    prevMonthButtonAction() {
        let month = this.key.month;
        let year = this.key.year;
        month--;
        if (month === 0) {
            month = 12;
            year--;
        }
        const countDaysInMonth = this.helper.getCountDaysOfMonth(year, month - 1);
        if (countDaysInMonth < this.key.day) {
            this.key.day = countDaysInMonth;
        }
        this.key.month = month;
        this.key.year = year;
    }
    nextMonthButtonAction() {
        let month = this.key.month;
        let year = this.key.year;
        month++;
        if (month === 13) {
            month = 1;
            year++;
        }
        const countDaysInMonth = this.helper.getCountDaysOfMonth(year, month - 1);
        if (countDaysInMonth < this.key.day) {
            this.key.day = countDaysInMonth;
        }
        this.key.month = month;
        this.key.year = year;
    }
}
DatePickerMenuComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DatePickerMenuComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }], target: i0.ɵɵFactoryTarget.Component });
DatePickerMenuComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DatePickerMenuComponent, selector: "sti-date-picker-menu", inputs: { menu: "menu", keyTo: "keyTo", closeOnAction: "closeOnAction" }, ngImport: i0, template: `
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-button [imageName]="'Arrows.BigArrowLeft.png'" [margin]="'1px 2px 0 1px'" (action)="prevMonthButtonAction()">
                </sti-button>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-drop-down-list
                  [width]="model.options.isTouchDevice ? 79 : 81"
                  [readOnly]="true"
                  [margin]="'1px 2px 0 0'"
                  [items]="monthesForDatePickerItems"
                  [key]="key.month - 1"
                  (action)="key.month = $event.key + 1">
                </sti-drop-down-list>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [width]="40" [margin]="'1px 2px 0 0'" [value]="key.year" (onchange)="yearAction($event)">
                </sti-text-box>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-button [imageName]="'Arrows.BigArrowRight.png'" [margin]="'1px 1px 0 0'" (action)="nextMonthButtonAction()">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
        <div class="stiJsViewerDatePickerSeparator" style="margin: 2px 0px;"></div>

        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngFor="let item of model.dayOfWeek; let i = index" class="stiJsViewerDatePickerDayOfWeekCell"
                  [style.fontSize]="countLetters == 2 ? '11px' : ''"
                  [style.color]="getShortDayColor(i)">
                  {{getShortDayName(i)}}
              </td>
            </tr>
            <tr *ngFor="let row of rows" class="stiJsViewerClearAllStyles">
                <td *ngFor="let col of cols" class="stiJsViewerClearAllStyles">
                  <sti-date-picker-day-button
                      [col]="col"
                      [row]="row"
                      [date]="key"
                      [selected]="getButtonSelected(col, row)"
                      [caption]="getButtonCaption(col, row)"
                      [enabled]="getButtonCaption(col, row) != ''">
                      [closeOnAction]="closeOnAction"
                  </sti-date-picker-day-button>
                </td>
            </tr>
          </tbody>
        </table>

        <div *ngIf="showTime" class="stiJsViewerDatePickerSeparator" style="margin: 2px 0px;"></div>
        <table *ngIf="showTime" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width:100%">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding: 0 4px 0 4px; white-space: nowrap;">
                {{this.model.loc('Time') + ':'}}
              </td>

              <td class="stiJsViewerClearAllStyles" style="text-align: right;">
                <sti-text-box [width]="90"
                    [margin]="'1px 2px 2px 2px'"
                    [value]="getTime()"
                    (action)="timeAction($event)">
                </sti-text-box>
              </td>
            </tr>
          </tbody>
        </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i5.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i6.DropDownListComponent, selector: "sti-drop-down-list", inputs: ["toolTip", "showImage", "width", "margin", "items", "styleDisplay", "verticalAlign", "readOnly", "enabled", "key"], outputs: ["action"] }, { kind: "component", type: i7.DatePickerDayButtonComponent, selector: "sti-date-picker-day-button", inputs: ["col", "row", "caption", "enabled", "selected", "date", "closeOnAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DatePickerMenuComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-date-picker-menu',
                    template: `
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <sti-button [imageName]="'Arrows.BigArrowLeft.png'" [margin]="'1px 2px 0 1px'" (action)="prevMonthButtonAction()">
                </sti-button>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-drop-down-list
                  [width]="model.options.isTouchDevice ? 79 : 81"
                  [readOnly]="true"
                  [margin]="'1px 2px 0 0'"
                  [items]="monthesForDatePickerItems"
                  [key]="key.month - 1"
                  (action)="key.month = $event.key + 1">
                </sti-drop-down-list>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-text-box [width]="40" [margin]="'1px 2px 0 0'" [value]="key.year" (onchange)="yearAction($event)">
                </sti-text-box>
              </td>

              <td class="stiJsViewerClearAllStyles">
                <sti-button [imageName]="'Arrows.BigArrowRight.png'" [margin]="'1px 1px 0 0'" (action)="nextMonthButtonAction()">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
        <div class="stiJsViewerDatePickerSeparator" style="margin: 2px 0px;"></div>

        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngFor="let item of model.dayOfWeek; let i = index" class="stiJsViewerDatePickerDayOfWeekCell"
                  [style.fontSize]="countLetters == 2 ? '11px' : ''"
                  [style.color]="getShortDayColor(i)">
                  {{getShortDayName(i)}}
              </td>
            </tr>
            <tr *ngFor="let row of rows" class="stiJsViewerClearAllStyles">
                <td *ngFor="let col of cols" class="stiJsViewerClearAllStyles">
                  <sti-date-picker-day-button
                      [col]="col"
                      [row]="row"
                      [date]="key"
                      [selected]="getButtonSelected(col, row)"
                      [caption]="getButtonCaption(col, row)"
                      [enabled]="getButtonCaption(col, row) != ''">
                      [closeOnAction]="closeOnAction"
                  </sti-date-picker-day-button>
                </td>
            </tr>
          </tbody>
        </table>

        <div *ngIf="showTime" class="stiJsViewerDatePickerSeparator" style="margin: 2px 0px;"></div>
        <table *ngIf="showTime" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width:100%">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding: 0 4px 0 4px; white-space: nowrap;">
                {{this.model.loc('Time') + ':'}}
              </td>

              <td class="stiJsViewerClearAllStyles" style="text-align: right;">
                <sti-text-box [width]="90"
                    [margin]="'1px 2px 2px 2px'"
                    [value]="getTime()"
                    (action)="timeAction($event)">
                </sti-text-box>
              </td>
            </tr>
          </tbody>
        </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }]; }, propDecorators: { menu: [{
                type: Input
            }], keyTo: [{
                type: Input
            }], closeOnAction: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0ZS1waWNrZXItbWVudS5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LXZpZXdlci1hbmd1bGFyL3NyYy9saWIvbWVudS9kYXRlLXBpY2tlci1tZW51LmNvbXBvbmVudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFVLEtBQUssRUFBRSxNQUFNLGVBQWUsQ0FBQzs7Ozs7Ozs7O0FBd0Z6RCxNQUFNLE9BQU8sdUJBQXVCO0lBV2xDLFlBQW1CLEtBQW1CLEVBQVMsTUFBcUI7UUFBakQsVUFBSyxHQUFMLEtBQUssQ0FBYztRQUFTLFdBQU0sR0FBTixNQUFNLENBQWU7UUFSM0QsVUFBSyxHQUFHLEtBQUssQ0FBQztRQUNkLGtCQUFhLEdBQUcsSUFBSSxDQUFDO1FBRXZCLDhCQUF5QixHQUFXLEVBQUUsQ0FBQztRQUV2QyxTQUFJLEdBQUcsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztRQUM3QixTQUFJLEdBQUcsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBRy9CLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyx5QkFBeUIsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsT0FBTyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsT0FBTyxHQUFHLENBQUMsQ0FBQyxFQUFFLEdBQUcsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFFOUksTUFBTSxZQUFZLEdBQUcsRUFBRSxDQUFDO1FBQ3hCLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO1lBQ2pDLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUMsQ0FBQztZQUMxQyxZQUFZLENBQUMsT0FBTyxDQUFDLFFBQVEsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsV0FBVyxFQUFFLENBQUMsR0FBRyxJQUFJLENBQUM7UUFDeEUsQ0FBQyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsWUFBWSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbkUsQ0FBQztJQUVELFFBQVEsS0FBSyxDQUFDO0lBRWQsaUJBQWlCLENBQUMsR0FBVyxFQUFFLEdBQVc7UUFDeEMsTUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO1FBQ3BDLE1BQU0sTUFBTSxHQUFHLEdBQUcsR0FBRyxDQUFDLEdBQUcsR0FBRyxDQUFDO1FBQzdCLE1BQU0sR0FBRyxHQUFHLE1BQU0sR0FBRyxRQUFRLEdBQUcsQ0FBQyxDQUFDO1FBRWxDLE9BQU8sR0FBRyxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDO0lBQzlCLENBQUM7SUFFRCxnQkFBZ0IsQ0FBQyxHQUFXLEVBQUUsR0FBVztRQUN2QyxNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7UUFDcEMsTUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUMsQ0FBQztRQUN2RixNQUFNLE1BQU0sR0FBRyxHQUFHLEdBQUcsQ0FBQyxHQUFHLEdBQUcsQ0FBQztRQUM3QixNQUFNLEdBQUcsR0FBRyxNQUFNLEdBQUcsUUFBUSxHQUFHLENBQUMsQ0FBQztRQUNsQyxJQUFJLE1BQU0sSUFBSSxRQUFRLElBQUksR0FBRyxJQUFJLFdBQVcsRUFBRTtZQUM1QyxPQUFPLEdBQUcsQ0FBQyxRQUFRLEVBQUUsQ0FBQztTQUN2QjtRQUNELE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztJQUdELE9BQU87UUFDTCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxTQUFTLENBQUMsQ0FBQztJQUMxRSxDQUFDO0lBRUQsV0FBVztRQUNULElBQUksUUFBUSxHQUFHLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQztRQUN2RSxJQUFJLFFBQVEsS0FBSyxDQUFDLEVBQUU7WUFDbEIsUUFBUSxHQUFHLENBQUMsQ0FBQztTQUNkO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsd0JBQXdCLEtBQUssUUFBUSxFQUFFO1lBQ3ZFLFFBQVEsRUFBRSxDQUFDO1NBQ1o7UUFDRCxPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0lBRUQsSUFBSSxRQUFRO1FBQ1YsT0FBTyxJQUFJLENBQUMsSUFBSSxFQUFFLE1BQU0sRUFBRSxZQUFZLEtBQUssTUFBTSxDQUFDO0lBQ3BELENBQUM7SUFFRCxJQUFJLEdBQUc7UUFDTCxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsR0FBRyxDQUFDO0lBQ3BFLENBQUM7SUFFRCxVQUFVLENBQUMsS0FBVTtRQUNuQixJQUFJO1lBQ0YsSUFBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLEdBQUcsUUFBUSxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7U0FDM0M7UUFBQyxNQUFNLEdBQUc7SUFDYixDQUFDO0lBRUQsVUFBVSxDQUFDLEtBQVU7UUFDbkIsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ25ELElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7UUFDaEMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztRQUNoQyxJQUFJLENBQUMsR0FBRyxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO0lBQzlCLENBQUM7SUFFRCxlQUFlLENBQUMsS0FBYTtRQUMzQixNQUFNLE9BQU8sR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztRQUNwRSxJQUFJLE9BQU8sRUFBRTtZQUNYLE9BQU8sT0FBTyxDQUFDLFFBQVEsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUUsSUFBSSxDQUFDLFlBQVksSUFBSSxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztTQUNuSDtRQUNELE9BQU8sRUFBRSxDQUFDO0lBQ1osQ0FBQztJQUVELGdCQUFnQixDQUFDLEtBQWE7UUFDNUIsSUFBSSxLQUFLLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsd0JBQXdCLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQzNGLE9BQU8sU0FBUyxDQUFDO1NBQ2xCO1FBRUQsSUFBSSxLQUFLLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsd0JBQXdCLEtBQUssUUFBUSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO1lBQzNGLE9BQU8sU0FBUyxDQUFDO1NBQ2xCO1FBQ0QsT0FBTyxFQUFFLENBQUM7SUFDWixDQUFDO0lBRUQscUJBQXFCO1FBQ25CLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDO1FBQzNCLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDO1FBQ3pCLEtBQUssRUFBRSxDQUFDO1FBQ1IsSUFBSSxLQUFLLEtBQUssQ0FBQyxFQUFFO1lBQ2YsS0FBSyxHQUFHLEVBQUUsQ0FBQztZQUNYLElBQUksRUFBRSxDQUFDO1NBQ1I7UUFDRCxNQUFNLGdCQUFnQixHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsbUJBQW1CLENBQUMsSUFBSSxFQUFFLEtBQUssR0FBRyxDQUFDLENBQUMsQ0FBQztRQUMxRSxJQUFJLGdCQUFnQixHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxFQUFFO1lBQ25DLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxHQUFHLGdCQUFnQixDQUFDO1NBQ2pDO1FBQ0QsSUFBSSxDQUFDLEdBQUcsQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztJQUN2QixDQUFDO0lBRUQscUJBQXFCO1FBQ25CLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDO1FBQzNCLElBQUksSUFBSSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsSUFBSSxDQUFDO1FBQ3pCLEtBQUssRUFBRSxDQUFDO1FBQ1IsSUFBSSxLQUFLLEtBQUssRUFBRSxFQUFFO1lBQ2hCLEtBQUssR0FBRyxDQUFDLENBQUM7WUFDVixJQUFJLEVBQUUsQ0FBQztTQUNSO1FBQ0QsTUFBTSxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLG1CQUFtQixDQUFDLElBQUksRUFBRSxLQUFLLEdBQUcsQ0FBQyxDQUFDLENBQUM7UUFDMUUsSUFBSSxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsRUFBRTtZQUNuQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsR0FBRyxnQkFBZ0IsQ0FBQztTQUNqQztRQUNELElBQUksQ0FBQyxHQUFHLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUN2QixJQUFJLENBQUMsR0FBRyxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7SUFDdkIsQ0FBQzs7b0hBaklVLHVCQUF1Qjt3R0FBdkIsdUJBQXVCLHNJQWhGeEI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBNkVUOzJGQUdVLHVCQUF1QjtrQkFsRm5DLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLHNCQUFzQjtvQkFDaEMsUUFBUSxFQUFFOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztHQTZFVDtpQkFDRjsrSEFJVSxJQUFJO3NCQUFaLEtBQUs7Z0JBQ0csS0FBSztzQkFBYixLQUFLO2dCQUNHLGFBQWE7c0JBQXJCLEtBQUsiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCwgSW5wdXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgTW9kZWxTZXJ2aWNlIH0gZnJvbSAnLi4vc2VydmljZXMvbW9kZWwuc2VydmljZSc7XHJcbmltcG9ydCB7IE1lbnUgfSBmcm9tICcuL21lbnUuc2VydmljZSc7XHJcbmltcG9ydCB7IEhlbHBlclNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9oZWxwZXIuc2VydmljZSc7XHJcbmltcG9ydCB7IEl0ZW0sIERhdGVUaW1lT2JqZWN0IH0gZnJvbSAnLi4vc2VydmljZXMvb2JqZWN0cyc7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3N0aS1kYXRlLXBpY2tlci1tZW51JyxcclxuICB0ZW1wbGF0ZTogYFxyXG4gICAgICAgIDx0YWJsZSBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBjZWxscGFkZGluZz1cIjBcIiBjZWxsc3BhY2luZz1cIjBcIj5cclxuICAgICAgICAgIDx0Ym9keT5cclxuICAgICAgICAgICAgPHRyIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgIDxzdGktYnV0dG9uIFtpbWFnZU5hbWVdPVwiJ0Fycm93cy5CaWdBcnJvd0xlZnQucG5nJ1wiIFttYXJnaW5dPVwiJzFweCAycHggMCAxcHgnXCIgKGFjdGlvbik9XCJwcmV2TW9udGhCdXR0b25BY3Rpb24oKVwiPlxyXG4gICAgICAgICAgICAgICAgPC9zdGktYnV0dG9uPlxyXG4gICAgICAgICAgICAgIDwvdGQ+XHJcblxyXG4gICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICAgIDxzdGktZHJvcC1kb3duLWxpc3RcclxuICAgICAgICAgICAgICAgICAgW3dpZHRoXT1cIm1vZGVsLm9wdGlvbnMuaXNUb3VjaERldmljZSA/IDc5IDogODFcIlxyXG4gICAgICAgICAgICAgICAgICBbcmVhZE9ubHldPVwidHJ1ZVwiXHJcbiAgICAgICAgICAgICAgICAgIFttYXJnaW5dPVwiJzFweCAycHggMCAwJ1wiXHJcbiAgICAgICAgICAgICAgICAgIFtpdGVtc109XCJtb250aGVzRm9yRGF0ZVBpY2tlckl0ZW1zXCJcclxuICAgICAgICAgICAgICAgICAgW2tleV09XCJrZXkubW9udGggLSAxXCJcclxuICAgICAgICAgICAgICAgICAgKGFjdGlvbik9XCJrZXkubW9udGggPSAkZXZlbnQua2V5ICsgMVwiPlxyXG4gICAgICAgICAgICAgICAgPC9zdGktZHJvcC1kb3duLWxpc3Q+XHJcbiAgICAgICAgICAgICAgPC90ZD5cclxuXHJcbiAgICAgICAgICAgICAgPHRkIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgICAgPHN0aS10ZXh0LWJveCBbd2lkdGhdPVwiNDBcIiBbbWFyZ2luXT1cIicxcHggMnB4IDAgMCdcIiBbdmFsdWVdPVwia2V5LnllYXJcIiAob25jaGFuZ2UpPVwieWVhckFjdGlvbigkZXZlbnQpXCI+XHJcbiAgICAgICAgICAgICAgICA8L3N0aS10ZXh0LWJveD5cclxuICAgICAgICAgICAgICA8L3RkPlxyXG5cclxuICAgICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICA8c3RpLWJ1dHRvbiBbaW1hZ2VOYW1lXT1cIidBcnJvd3MuQmlnQXJyb3dSaWdodC5wbmcnXCIgW21hcmdpbl09XCInMXB4IDFweCAwIDAnXCIgKGFjdGlvbik9XCJuZXh0TW9udGhCdXR0b25BY3Rpb24oKVwiPlxyXG4gICAgICAgICAgICAgICAgPC9zdGktYnV0dG9uPlxyXG4gICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgIDwvdHI+XHJcbiAgICAgICAgICA8L3Rib2R5PlxyXG4gICAgICAgIDwvdGFibGU+XHJcbiAgICAgICAgPGRpdiBjbGFzcz1cInN0aUpzVmlld2VyRGF0ZVBpY2tlclNlcGFyYXRvclwiIHN0eWxlPVwibWFyZ2luOiAycHggMHB4O1wiPjwvZGl2PlxyXG5cclxuICAgICAgICA8dGFibGUgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgY2VsbHBhZGRpbmc9XCIwXCIgY2VsbHNwYWNpbmc9XCIwXCI+XHJcbiAgICAgICAgICA8dGJvZHk+XHJcbiAgICAgICAgICAgIDx0ciBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICA8dGQgKm5nRm9yPVwibGV0IGl0ZW0gb2YgbW9kZWwuZGF5T2ZXZWVrOyBsZXQgaSA9IGluZGV4XCIgY2xhc3M9XCJzdGlKc1ZpZXdlckRhdGVQaWNrZXJEYXlPZldlZWtDZWxsXCJcclxuICAgICAgICAgICAgICAgICAgW3N0eWxlLmZvbnRTaXplXT1cImNvdW50TGV0dGVycyA9PSAyID8gJzExcHgnIDogJydcIlxyXG4gICAgICAgICAgICAgICAgICBbc3R5bGUuY29sb3JdPVwiZ2V0U2hvcnREYXlDb2xvcihpKVwiPlxyXG4gICAgICAgICAgICAgICAgICB7e2dldFNob3J0RGF5TmFtZShpKX19XHJcbiAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgPC90cj5cclxuICAgICAgICAgICAgPHRyICpuZ0Zvcj1cImxldCByb3cgb2Ygcm93c1wiIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgICAgPHRkICpuZ0Zvcj1cImxldCBjb2wgb2YgY29sc1wiIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgICAgICA8c3RpLWRhdGUtcGlja2VyLWRheS1idXR0b25cclxuICAgICAgICAgICAgICAgICAgICAgIFtjb2xdPVwiY29sXCJcclxuICAgICAgICAgICAgICAgICAgICAgIFtyb3ddPVwicm93XCJcclxuICAgICAgICAgICAgICAgICAgICAgIFtkYXRlXT1cImtleVwiXHJcbiAgICAgICAgICAgICAgICAgICAgICBbc2VsZWN0ZWRdPVwiZ2V0QnV0dG9uU2VsZWN0ZWQoY29sLCByb3cpXCJcclxuICAgICAgICAgICAgICAgICAgICAgIFtjYXB0aW9uXT1cImdldEJ1dHRvbkNhcHRpb24oY29sLCByb3cpXCJcclxuICAgICAgICAgICAgICAgICAgICAgIFtlbmFibGVkXT1cImdldEJ1dHRvbkNhcHRpb24oY29sLCByb3cpICE9ICcnXCI+XHJcbiAgICAgICAgICAgICAgICAgICAgICBbY2xvc2VPbkFjdGlvbl09XCJjbG9zZU9uQWN0aW9uXCJcclxuICAgICAgICAgICAgICAgICAgPC9zdGktZGF0ZS1waWNrZXItZGF5LWJ1dHRvbj5cclxuICAgICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgIDwvdHI+XHJcbiAgICAgICAgICA8L3Rib2R5PlxyXG4gICAgICAgIDwvdGFibGU+XHJcblxyXG4gICAgICAgIDxkaXYgKm5nSWY9XCJzaG93VGltZVwiIGNsYXNzPVwic3RpSnNWaWV3ZXJEYXRlUGlja2VyU2VwYXJhdG9yXCIgc3R5bGU9XCJtYXJnaW46IDJweCAwcHg7XCI+PC9kaXY+XHJcbiAgICAgICAgPHRhYmxlICpuZ0lmPVwic2hvd1RpbWVcIiBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBjZWxscGFkZGluZz1cIjBcIiBjZWxsc3BhY2luZz1cIjBcIiBzdHlsZT1cIndpZHRoOjEwMCVcIj5cclxuICAgICAgICAgIDx0Ym9keT5cclxuICAgICAgICAgICAgPHRyIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgIDx0ZCBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIiBzdHlsZT1cInBhZGRpbmc6IDAgNHB4IDAgNHB4OyB3aGl0ZS1zcGFjZTogbm93cmFwO1wiPlxyXG4gICAgICAgICAgICAgICAge3t0aGlzLm1vZGVsLmxvYygnVGltZScpICsgJzonfX1cclxuICAgICAgICAgICAgICA8L3RkPlxyXG5cclxuICAgICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCIgc3R5bGU9XCJ0ZXh0LWFsaWduOiByaWdodDtcIj5cclxuICAgICAgICAgICAgICAgIDxzdGktdGV4dC1ib3ggW3dpZHRoXT1cIjkwXCJcclxuICAgICAgICAgICAgICAgICAgICBbbWFyZ2luXT1cIicxcHggMnB4IDJweCAycHgnXCJcclxuICAgICAgICAgICAgICAgICAgICBbdmFsdWVdPVwiZ2V0VGltZSgpXCJcclxuICAgICAgICAgICAgICAgICAgICAoYWN0aW9uKT1cInRpbWVBY3Rpb24oJGV2ZW50KVwiPlxyXG4gICAgICAgICAgICAgICAgPC9zdGktdGV4dC1ib3g+XHJcbiAgICAgICAgICAgICAgPC90ZD5cclxuICAgICAgICAgICAgPC90cj5cclxuICAgICAgICAgIDwvdGJvZHk+XHJcbiAgICAgICAgPC90YWJsZT5cclxuICBgXHJcbn0pXHJcblxyXG5leHBvcnQgY2xhc3MgRGF0ZVBpY2tlck1lbnVDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xyXG5cclxuICBASW5wdXQoKSBtZW51OiBNZW51O1xyXG4gIEBJbnB1dCgpIGtleVRvID0gZmFsc2U7XHJcbiAgQElucHV0KCkgY2xvc2VPbkFjdGlvbiA9IHRydWU7XHJcblxyXG4gIHB1YmxpYyBtb250aGVzRm9yRGF0ZVBpY2tlckl0ZW1zOiBJdGVtW10gPSBbXTtcclxuICBwdWJsaWMgY291bnRMZXR0ZXJzOiBudW1iZXI7XHJcbiAgcHVibGljIGNvbHMgPSBbMCwgMSwgMiwgMywgNCwgNSwgNl07XHJcbiAgcHVibGljIHJvd3MgPSBbMCwgMSwgMiwgMywgNCwgNV07XHJcblxyXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtb2RlbDogTW9kZWxTZXJ2aWNlLCBwdWJsaWMgaGVscGVyOiBIZWxwZXJTZXJ2aWNlKSB7XHJcbiAgICB0aGlzLm1vZGVsLm1vbnRocy5mb3JFYWNoKChtLCBpKSA9PiB0aGlzLm1vbnRoZXNGb3JEYXRlUGlja2VySXRlbXMucHVzaCh7IG5hbWU6ICdNb250aCcgKyBpLCBjYXB0aW9uOiB0aGlzLm1vZGVsLmxvYygnTW9udGgnICsgbSksIGtleTogaSB9KSk7XHJcblxyXG4gICAgY29uc3QgZmlyc3RMZXR0ZXJzID0ge307XHJcbiAgICB0aGlzLm1vZGVsLmRheU9mV2Vlay5mb3JFYWNoKChkKSA9PiB7XHJcbiAgICAgIGNvbnN0IGRheU5hbWUgPSB0aGlzLm1vZGVsLmxvYygnRGF5JyArIGQpO1xyXG4gICAgICBmaXJzdExldHRlcnNbZGF5TmFtZS50b1N0cmluZygpLnN1YnN0cmluZygwLCAxKS50b1VwcGVyQ2FzZSgpXSA9IHRydWU7XHJcbiAgICB9KTtcclxuICAgIHRoaXMuY291bnRMZXR0ZXJzID0gT2JqZWN0LmtleXMoZmlyc3RMZXR0ZXJzKS5sZW5ndGggPCA1ID8gMiA6IDE7XHJcbiAgfVxyXG5cclxuICBuZ09uSW5pdCgpIHsgfVxyXG5cclxuICBnZXRCdXR0b25TZWxlY3RlZChjb2w6IG51bWJlciwgcm93OiBudW1iZXIpOiBib29sZWFuIHtcclxuICAgIGNvbnN0IGZpcnN0RGF5ID0gdGhpcy5nZXRGaXJzdERheSgpO1xyXG4gICAgY29uc3QgY3VyRGF5ID0gcm93ICogNyArIGNvbDtcclxuICAgIGNvbnN0IGRheSA9IGN1ckRheSAtIGZpcnN0RGF5ICsgMTtcclxuXHJcbiAgICByZXR1cm4gZGF5ID09PSB0aGlzLmtleS5kYXk7XHJcbiAgfVxyXG5cclxuICBnZXRCdXR0b25DYXB0aW9uKGNvbDogbnVtYmVyLCByb3c6IG51bWJlcik6IHN0cmluZyB7XHJcbiAgICBjb25zdCBmaXJzdERheSA9IHRoaXMuZ2V0Rmlyc3REYXkoKTtcclxuICAgIGNvbnN0IGRheXNJbk1vbnRoID0gdGhpcy5oZWxwZXIuZ2V0Q291bnREYXlzT2ZNb250aCh0aGlzLmtleS55ZWFyLCB0aGlzLmtleS5tb250aCAtIDEpO1xyXG4gICAgY29uc3QgY3VyRGF5ID0gcm93ICogNyArIGNvbDtcclxuICAgIGNvbnN0IGRheSA9IGN1ckRheSAtIGZpcnN0RGF5ICsgMTtcclxuICAgIGlmIChjdXJEYXkgPj0gZmlyc3REYXkgJiYgZGF5IDw9IGRheXNJbk1vbnRoKSB7XHJcbiAgICAgIHJldHVybiBkYXkudG9TdHJpbmcoKTtcclxuICAgIH1cclxuICAgIHJldHVybiAnJztcclxuICB9XHJcblxyXG5cclxuICBnZXRUaW1lKCk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gdGhpcy5oZWxwZXIuZm9ybWF0RGF0ZSh0aGlzLmhlbHBlci5nZXREYXRlKHRoaXMua2V5KSwgJ0g6bW06c3MnKTtcclxuICB9XHJcblxyXG4gIGdldEZpcnN0RGF5KCk6IG51bWJlciB7XHJcbiAgICBsZXQgZmlyc3REYXkgPSBuZXcgRGF0ZSh0aGlzLmtleS55ZWFyLCB0aGlzLmtleS5tb250aCAtIDEsIDEpLmdldERheSgpO1xyXG4gICAgaWYgKGZpcnN0RGF5ID09PSAwKSB7XHJcbiAgICAgIGZpcnN0RGF5ID0gNztcclxuICAgIH1cclxuICAgIGlmICh0aGlzLm1vZGVsLm9wdGlvbnMuYXBwZWFyYW5jZS5kYXRlUGlja2VyRmlyc3REYXlPZldlZWsgIT09ICdTdW5kYXknKSB7XHJcbiAgICAgIGZpcnN0RGF5LS07XHJcbiAgICB9XHJcbiAgICByZXR1cm4gZmlyc3REYXk7XHJcbiAgfVxyXG5cclxuICBnZXQgc2hvd1RpbWUoKTogYm9vbGVhbiB7XHJcbiAgICByZXR1cm4gdGhpcy5tZW51Py5wYXJhbXM/LmRhdGVUaW1lVHlwZSAhPT0gJ0RhdGUnO1xyXG4gIH1cclxuXHJcbiAgZ2V0IGtleSgpOiBEYXRlVGltZU9iamVjdCB7XHJcbiAgICByZXR1cm4gdGhpcy5rZXlUbyA/IHRoaXMubWVudS5wYXJhbXMua2V5VG8gOiB0aGlzLm1lbnUucGFyYW1zLmtleTtcclxuICB9XHJcblxyXG4gIHllYXJBY3Rpb24oaW5wdXQ6IGFueSkge1xyXG4gICAgdHJ5IHtcclxuICAgICAgdGhpcy5rZXkueWVhciA9IHBhcnNlSW50KGlucHV0LnZhbHVlLCAxMCk7XHJcbiAgICB9IGNhdGNoIHsgfVxyXG4gIH1cclxuXHJcbiAgdGltZUFjdGlvbihpbnB1dDogYW55KSB7XHJcbiAgICBjb25zdCB0aW1lID0gdGhpcy5oZWxwZXIuc3RyaW5nVG9UaW1lKGlucHV0LnZhbHVlKTtcclxuICAgIHRoaXMua2V5LnNlY29uZHMgPSB0aW1lLnNlY29uZHM7XHJcbiAgICB0aGlzLmtleS5taW51dGVzID0gdGltZS5taW51dGVzO1xyXG4gICAgdGhpcy5rZXkuaG91cnMgPSB0aW1lLmhvdXJzO1xyXG4gIH1cclxuXHJcbiAgZ2V0U2hvcnREYXlOYW1lKGluZGV4OiBudW1iZXIpOiBzdHJpbmcge1xyXG4gICAgY29uc3QgZGF5TmFtZSA9IHRoaXMubW9kZWwubG9jKCdEYXknICsgdGhpcy5tb2RlbC5kYXlPZldlZWtbaW5kZXhdKTtcclxuICAgIGlmIChkYXlOYW1lKSB7XHJcbiAgICAgIHJldHVybiBkYXlOYW1lLnRvU3RyaW5nKCkuc3Vic3RyaW5nKDAsIHRoaXMuY291bnRMZXR0ZXJzIDw9IGRheU5hbWUubGVuZ3RoID8gdGhpcy5jb3VudExldHRlcnMgOiAxKS50b1VwcGVyQ2FzZSgpO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuICcnO1xyXG4gIH1cclxuXHJcbiAgZ2V0U2hvcnREYXlDb2xvcihpbmRleDogbnVtYmVyKTogc3RyaW5nIHtcclxuICAgIGlmIChpbmRleCA9PT0gKHRoaXMubW9kZWwub3B0aW9ucy5hcHBlYXJhbmNlLmRhdGVQaWNrZXJGaXJzdERheU9mV2VlayA9PT0gJ1N1bmRheScgPyA2IDogNSkpIHtcclxuICAgICAgcmV0dXJuICcjMDAwMGZmJztcclxuICAgIH1cclxuXHJcbiAgICBpZiAoaW5kZXggPT09ICh0aGlzLm1vZGVsLm9wdGlvbnMuYXBwZWFyYW5jZS5kYXRlUGlja2VyRmlyc3REYXlPZldlZWsgPT09ICdTdW5kYXknID8gMCA6IDYpKSB7XHJcbiAgICAgIHJldHVybiAnI2ZmMDAwMCc7XHJcbiAgICB9XHJcbiAgICByZXR1cm4gJyc7XHJcbiAgfVxyXG5cclxuICBwcmV2TW9udGhCdXR0b25BY3Rpb24oKSB7XHJcbiAgICBsZXQgbW9udGggPSB0aGlzLmtleS5tb250aDtcclxuICAgIGxldCB5ZWFyID0gdGhpcy5rZXkueWVhcjtcclxuICAgIG1vbnRoLS07XHJcbiAgICBpZiAobW9udGggPT09IDApIHtcclxuICAgICAgbW9udGggPSAxMjtcclxuICAgICAgeWVhci0tO1xyXG4gICAgfVxyXG4gICAgY29uc3QgY291bnREYXlzSW5Nb250aCA9IHRoaXMuaGVscGVyLmdldENvdW50RGF5c09mTW9udGgoeWVhciwgbW9udGggLSAxKTtcclxuICAgIGlmIChjb3VudERheXNJbk1vbnRoIDwgdGhpcy5rZXkuZGF5KSB7XHJcbiAgICAgIHRoaXMua2V5LmRheSA9IGNvdW50RGF5c0luTW9udGg7XHJcbiAgICB9XHJcbiAgICB0aGlzLmtleS5tb250aCA9IG1vbnRoO1xyXG4gICAgdGhpcy5rZXkueWVhciA9IHllYXI7XHJcbiAgfVxyXG5cclxuICBuZXh0TW9udGhCdXR0b25BY3Rpb24oKSB7XHJcbiAgICBsZXQgbW9udGggPSB0aGlzLmtleS5tb250aDtcclxuICAgIGxldCB5ZWFyID0gdGhpcy5rZXkueWVhcjtcclxuICAgIG1vbnRoKys7XHJcbiAgICBpZiAobW9udGggPT09IDEzKSB7XHJcbiAgICAgIG1vbnRoID0gMTtcclxuICAgICAgeWVhcisrO1xyXG4gICAgfVxyXG4gICAgY29uc3QgY291bnREYXlzSW5Nb250aCA9IHRoaXMuaGVscGVyLmdldENvdW50RGF5c09mTW9udGgoeWVhciwgbW9udGggLSAxKTtcclxuICAgIGlmIChjb3VudERheXNJbk1vbnRoIDwgdGhpcy5rZXkuZGF5KSB7XHJcbiAgICAgIHRoaXMua2V5LmRheSA9IGNvdW50RGF5c0luTW9udGg7XHJcbiAgICB9XHJcbiAgICB0aGlzLmtleS5tb250aCA9IG1vbnRoO1xyXG4gICAgdGhpcy5rZXkueWVhciA9IHllYXI7XHJcbiAgfVxyXG5cclxuXHJcbn1cclxuIl19