import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "./form.service";
import * as i4 from "../controls/text-box.componet";
import * as i5 from "./base-form.component";
export class PasswordFormComponent {
    constructor(model, controller, formService) {
        this.model = model;
        this.controller = controller;
        this.formService = formService;
    }
    ngOnInit() { }
    changeVisibility(state) {
        if (state === 'visible') {
            this.password = '';
            this.textBox.element.nativeElement.focus();
        }
    }
    action() {
        const data = this.formService.form.formData;
        data.openingFilePassword = this.password;
        this.formService.closeForm('passwordForm');
        this.controller.postOpen(data);
    }
}
PasswordFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PasswordFormComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.FormService }], target: i0.ɵɵFactoryTarget.Component });
PasswordFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: PasswordFormComponent, selector: "sti-password-form", viewQueries: [{ propertyName: "textBox", first: true, predicate: ["textBox"], descendants: true }], ngImport: i0, template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'passwordForm'"
      [caption]="model.loc('PasswordSaveReport').replace(':', '')"
      [level]="2"
      [defaultTop]="150"
      (changeVisibility)="changeVisibility($event)"
      (action)="action()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 5px;">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerCaptionControls">
              {{model.loc('PasswordEnter')}}
            </td>
            <td class="stiJsViewerCaptionControls">
              <sti-text-box #textBox [type]="'password'" [width]="200" [focusOnCreate]="true" [value]="password" (onchange)="password = $event.value">
              </sti-text-box>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "component", type: i4.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i5.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PasswordFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-password-form',
                    template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'passwordForm'"
      [caption]="model.loc('PasswordSaveReport').replace(':', '')"
      [level]="2"
      [defaultTop]="150"
      (changeVisibility)="changeVisibility($event)"
      (action)="action()">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 5px;">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerCaptionControls">
              {{model.loc('PasswordEnter')}}
            </td>
            <td class="stiJsViewerCaptionControls">
              <sti-text-box #textBox [type]="'password'" [width]="200" [focusOnCreate]="true" [value]="password" (onchange)="password = $event.value">
              </sti-text-box>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.FormService }]; }, propDecorators: { textBox: [{
                type: ViewChild,
                args: ['textBox']
            }] } });
//# sourceMappingURL=data:application/json;base64,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