import { Component } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "./form.service";
import * as i3 from "@angular/common";
import * as i4 from "../controls/button.component";
import * as i5 from "./base-form.component";
export class NotificationFormComponent {
    constructor(model, formService) {
        this.model = model;
        this.formService = formService;
    }
    ngOnInit() { }
    changeVisibility(state) {
        if (state === 'hidden' && this.model.notificationFormOptions?.cancelAction) {
            this.model.notificationFormOptions.cancelAction();
        }
    }
    action() {
        this.model.notificationFormOptions?.action ? this.model.notificationFormOptions.action() : this.formService.closeForm('notificationForm');
    }
}
NotificationFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NotificationFormComponent, deps: [{ token: i1.ModelService }, { token: i2.FormService }], target: i0.ɵɵFactoryTarget.Component });
NotificationFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: NotificationFormComponent, selector: "sti-notification-form", ngImport: i0, template: `
  <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'notificationForm'"
      [defaultTop]="150"
      [caption]="model.loc('Viewer')"
      [level]="4"
      [showButtons]="false"
      [showSeparator]="false"
      (changeVisibility)="changeVisibility($event)">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr *ngIf="model.notificationFormOptions?.image" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="text-align: center;">
              <img src="{{model.img(model.notificationFormOptions?.image)}}" style="margin-top: 20px; width: 112px; height: 112px;">
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.message" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormMessage">
                {{model.notificationFormOptions?.message}}
              </div>
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.description" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormDescription">
                {{model.notificationFormOptions?.description}}
              </div>
            </td>
          </tr>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="text-align: center;">
              <sti-button
                [caption]="model.notificationFormOptions?.buttonCaption"
                [styleName]="'stiJsViewerLoginButton'"
                [innerTableWidth]="'100%'"
                [height]="'40px'"
                [minWidth]="'80px'"
                [captionAlign]="'center'"
                [cursor]="'pointer'"
                [display]="'inline-block'"
                [minWidth]="'200px'"
                [width]="'auto'"
                [margin]="'20px 30px 30px 30px'"
                [fontSize]="'14px'"
                (action)="action()">
              </sti-button>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
    `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i5.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NotificationFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-notification-form',
                    template: `
  <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'notificationForm'"
      [defaultTop]="150"
      [caption]="model.loc('Viewer')"
      [level]="4"
      [showButtons]="false"
      [showSeparator]="false"
      (changeVisibility)="changeVisibility($event)">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr *ngIf="model.notificationFormOptions?.image" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="text-align: center;">
              <img src="{{model.img(model.notificationFormOptions?.image)}}" style="margin-top: 20px; width: 112px; height: 112px;">
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.message" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormMessage">
                {{model.notificationFormOptions?.message}}
              </div>
            </td>
          </tr>
          <tr *ngIf="model.notificationFormOptions?.description" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <div class="stiJsViewerNotificationFormDescription">
                {{model.notificationFormOptions?.description}}
              </div>
            </td>
          </tr>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" style="text-align: center;">
              <sti-button
                [caption]="model.notificationFormOptions?.buttonCaption"
                [styleName]="'stiJsViewerLoginButton'"
                [innerTableWidth]="'100%'"
                [height]="'40px'"
                [minWidth]="'80px'"
                [captionAlign]="'center'"
                [cursor]="'pointer'"
                [display]="'inline-block'"
                [minWidth]="'200px'"
                [width]="'auto'"
                [margin]="'20px 30px 30px 30px'"
                [fontSize]="'14px'"
                (action)="action()">
              </sti-button>
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
    `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.FormService }]; } });
//# sourceMappingURL=data:application/json;base64,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