import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/mouse.service";
import * as i2 from "../menu/menu.service";
import * as i3 from "../services/helper.service";
import * as i4 from "../services/model.service";
export class FormService {
    constructor(mouseService, menuService, helper, model) {
        this.mouseService = mouseService;
        this.menuService = menuService;
        this.helper = helper;
        this.model = model;
        this.mouseX = 0;
        this.mouseY = 0;
        this.formX = 0;
        this.formY = 0;
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.move(event);
        });
        mouseService.getDocumentMouseUp().subscribe((event) => {
            this.stopMove();
        });
    }
    get form() {
        return this.model.form;
    }
    set form(form) {
        this.model.form = form;
    }
    showForm(name, formData) {
        this.form = { name, left: 0, top: 0, isMooving: false, formData };
    }
    closeForm(name) {
        if (this.form?.name === 'notificationForm' && this.model.notificationFormOptions?.action) {
            this.model.notificationFormOptions.action();
        }
        this.form = null;
    }
    centerForm(baseForm, defaultTop) {
        if (this.form != null) {
            setTimeout(() => {
                const position = this.helper.setObjectToCenter(baseForm.element.nativeElement, defaultTop);
                this.form.left = position.left;
                this.form.top = position.top;
                this.form.level = baseForm.level;
            });
        }
    }
    startMove(name, event, touchEvent) {
        if (event || touchEvent && touchEvent.changedTouches.length > 0) {
            this.formX = this.form.left;
            this.formY = this.form.top;
            this.mouseX = event?.screenX || touchEvent.changedTouches[0].screenX;
            this.mouseY = event?.screenY || touchEvent.changedTouches[0].screenY;
            this.form.isMooving = true;
        }
    }
    move(event) {
        if (this.form?.isMooving) {
            const screenX = event.screenX || (event.changedTouches.length > 0 ? event.changedTouches[0].screenX : -1);
            const screenY = event.screenY || (event.changedTouches.length > 0 ? event.changedTouches[0].screenY : -1);
            this.form.left = this.formX + (screenX - this.mouseX);
            this.form.top = this.formY + (screenY - this.mouseY);
            this.menuService.closeAllMenus();
        }
    }
    stopMove() {
        if (this.form?.isMooving) {
            this.form.isMooving = false;
        }
    }
}
FormService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormService, deps: [{ token: i1.MouseService }, { token: i2.MenuService }, { token: i3.HelperService }, { token: i4.ModelService }], target: i0.ɵɵFactoryTarget.Injectable });
FormService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.MouseService }, { type: i2.MenuService }, { type: i3.HelperService }, { type: i4.ModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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