import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/export.service";
import * as i3 from "../services/helper.service";
import * as i4 from "./form.service";
import * as i5 from "../menu/menu.service";
import * as i6 from "../services/collections.service";
import * as i7 from "../services/controller.service";
import * as i8 from "@angular/common";
import * as i9 from "../controls/button.component";
import * as i10 from "../controls/text-box.componet";
import * as i11 from "../controls/checkbox.component";
import * as i12 from "./base-form.component";
import * as i13 from "./group-panel.component";
import * as i14 from "../controls/radio-button.components";
import * as i15 from "../controls/drop-down-list-for-export-form.component";
export class ExportFormComponent {
    constructor(model, exportService, helper, formService, menuService, collections, controller) {
        this.model = model;
        this.exportService = exportService;
        this.helper = helper;
        this.formService = formService;
        this.menuService = menuService;
        this.collections = collections;
        this.controller = controller;
        this.PROPERTY_ALIAS = {
            ImageFormatForHtml: 'ImageFormat',
            EncodingTextOrCsvFile: 'Encoding',
            ExportModeRtf: 'ExportMode',
            EncodingDifFile: 'Encoding',
            EncodingDbfFile: 'CodePage'
        };
        this.formVisible = false;
        this.disabledComponents = {};
    }
    ngOnChanges(changes) {
        if (this.baseForm && this.formService?.form?.name === this.baseForm.name) {
            setTimeout(() => this.updateDisabledComponents());
        }
    }
    ngOnInit() { }
    action() {
        this.formService.closeForm(this.baseForm.name);
        if (this.model.options.exports.storeExportSettings) {
            this.helper.setCookie('StimulsoftWebViewerExportSettings' + this.exportService.getCommonExportFormat(), JSON.stringify(this.exportService.exportSettings));
        }
        this.exportService.postExport();
    }
    updateDisabledComponents() {
        ['StandardPdfFonts', 'EmbeddedFonts', 'UseUnicode'].forEach(n => this.disabledComponents[n] = (this.exportService.exportSettings.PdfACompliance === true));
        this.disabledComponents.ImageQuality = this.exportService.exportSettings.ImageCompressionMethod && this.exportService.exportSettings.ImageCompressionMethod !== 'Jpeg';
        this.disabledComponents.ExportObjectFormatting = this.exportService.exportSettings.DataExportMode === 'AllBands';
        this.disabledComponents.UseOnePageHeaderAndFooter = this.exportService.exportSettings.DataExportMode != 'AllBands';
        this.disabledComponents.EncodingDifFile = this.exportService.exportSettings.UseDefaultSystemEncoding;
        this.disabledComponents.TiffCompressionScheme = this.exportService.exportSettings.ImageType !== 'Tiff';
        this.disabledComponents.UseDigitalSignature = !this.exportService.exportSettings.UseDigitalSignature || !(this.model.pdfSecurityCertificates?.length > 0);
        this.disabledComponents.RemoveEmptySpaceAtBottom = this.exportService.exportSettings.UsePageHeadersAndFooters;
        if (this.exportService.exportSettings.ImageType != null) {
            const ifComponent = this.exportService.exportFormSettings.components.find(c => c.name === 'ImageFormat');
            if (ifComponent != null) {
                ifComponent.items = this.collections.getImageFormatItems(this.exportService.exportSettings.ImageType === 'Emf');
            }
        }
        this.disabledComponents.DitheringType = this.exportService.exportSettings.ImageFormat !== 'Monochrome';
        if (this.saveReportMdc) {
            this.saveReportMdc.click();
        }
        if (this.pagesRangeAll && !this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled) {
            this.pagesRangeAll.click();
        }
        if (this.pageRangeCurrentPage && this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled) {
            this.pageRangeCurrentPage.click();
        }
        if (this.exportService.exportSettings.CompressToArchive === true) {
            this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled = false;
        }
        if (this.exportService.exportSettings.CompressToArchive === false) {
            this.exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled = true;
        }
    }
    componentAction(comp, value) {
        let property = this.PROPERTY_ALIAS[comp.name] || comp.name;
        switch (property) {
            case 'EmbeddedFonts':
            case 'UseUnicode':
                if (value) {
                    this.exportService.exportSettings.StandardPdfFonts = false;
                }
                break;
            case 'StandardPdfFonts':
                if (value) {
                    this.exportService.exportSettings.EmbeddedFonts = false;
                    this.exportService.exportSettings.UseUnicode = false;
                }
                break;
            case 'ImageType':
                this.exportService.export('Image' + value, true);
                break;
            case 'DataType':
            case 'HtmlType':
                this.exportService.export(value, true);
                break;
            case 'ExcelType':
                const exportFormat = value === 'ExcelBinary' ? 'Excel' : value;
                this.exportService.export(exportFormat, true);
                break;
            case 'UseDigitalSignature':
                if (!(value === true || value === false)) {
                    property = 'CertificateThumbprint';
                }
                if (value === true && this.collections.getPdfSecurityCertificatesItems().length == 0) {
                    value = false;
                    this.controller.showError('Warning', 'Certificate Not Found!');
                }
                break;
            case 'UsePageHeadersAndFooters':
                if (value === true) {
                    this.exportService.exportSettings.RemoveEmptySpaceAtBottom = true;
                }
                break;
        }
        this.exportService.exportSettings[property] = value;
        this.updateDisabledComponents();
    }
    getValue(comp, component) {
        const property = this.PROPERTY_ALIAS[comp.name] || comp.name;
        switch (property) {
            case 'Zoom2':
                return this.exportService.exportSettings[property].toString();
            case 'UseDigitalSignature':
                if (component == 'dropDownList') {
                    return this.exportService.exportSettings['CertificateThumbprint'];
                }
            default:
                return this.exportService.exportSettings[property];
        }
    }
    changeVisibility(state) {
        this.formVisible = state === 'visible';
        if (state === 'hidden' && this.exportFormSettings?.groups?.savingReportGroup) {
            this.helper.setCookie('StimulsoftWebViewerExportSettingsOpeningGroups', JSON.stringify({
                SavingReportGroup: this.exportFormSettings.groups.savingReportGroup.opened,
                PageRangeGroup: this.exportFormSettings.groups.pageRangeGroup.opened,
                SettingsGroup: this.exportFormSettings.groups.settingsGroup.opened
            }));
        }
        if (state === 'visible') {
            this.updateDisabledComponents();
        }
    }
    showMenu(comp, button) {
        let menuName = 'documentSecurityMenu';
        if (comp.name === 'DocumentSecurityButton') {
            this.menuService.addMenu({
                type: menuName, name: menuName, items: [], parent: button.button,
                itemStyleName: 'stiJsViewerMenuStandartItem', menuStyleName: 'stiJsViewerDropdownMenu',
                state: ''
            });
        }
        else {
            menuName = this.menuService.VERTICAL_MENU_NAME;
            this.menuService.addMenu({
                type: 'buttonMenu', name: menuName, items: this.collections.getPdfSecurityCertificatesItems(), parent: button.button,
                itemStyleName: 'stiJsViewerMenuStandartItem', menuStyleName: 'stiJsViewerDropdownMenu',
                state: ''
            });
        }
        setTimeout(() => {
            this.menuService.showMenu(menuName);
        });
    }
    getTextBoxType(name) {
        if (name === 'SaveReportPassword' || name === 'PasswordInputUser' || name === 'PasswordInputOwner') {
            return this.formVisible ? 'password' : '';
        }
        return null;
    }
}
ExportFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ExportFormComponent, deps: [{ token: i1.ModelService }, { token: i2.ExportService }, { token: i3.HelperService }, { token: i4.FormService }, { token: i5.MenuService }, { token: i6.CollectionsService }, { token: i7.ControllerService }], target: i0.ɵɵFactoryTarget.Component });
ExportFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ExportFormComponent, selector: "sti-export-form", inputs: { exportFormSettings: "exportFormSettings" }, viewQueries: [{ propertyName: "baseForm", first: true, predicate: ["baseForm"], descendants: true }, { propertyName: "saveReportMdc", first: true, predicate: ["saveReportMdc"], descendants: true }, { propertyName: "pagesRangeAll", first: true, predicate: ["pagesRangeAll"], descendants: true }, { propertyName: "pageRangeCurrentPage", first: true, predicate: ["pageRangeCurrentPage"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
    [color]="model.options.toolbar.fontColor"
    [fontSize]="'12px'"
    [containerPadding]="'3px'"
    [name]="'exportForm'"
    [caption]="model.loc('ExportFormTitle')"
    [defaultTop]="150"
    (changeVisibility)="changeVisibility($event)"
    (action)="action()">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
      <tbody>
          <tr *ngIf="exportFormSettings?.groups.savingReportGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SavingReport')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.savingReportGroup.opened"
               (action)="exportFormSettings.groups.savingReportGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #saveReportMdc
                           [name]="baseForm.name + 'SaveReportMdc'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdc')"
                           [margin]="'6px 8px 3px 8px'"
                           [checked]="true"
                           (action)="exportService.exportSettings.Format = 'Mdc'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdz'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdz')"
                           [margin]="'3px 8px 3px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdz'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdx'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdx')"
                           [margin]="'3px 8px 0px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdx'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('PasswordSaveReportTooltip')">
                      {{model.loc('PasswordSaveReport')}}
                      </td>
                      <td>
                        <sti-text-box
                           [width]="140"
                           [tooltip]="model.loc('PasswordSaveReportTooltip')"
                           [margin]="'4px 8px 0px 8px'"
                           [type]="getTextBoxType('SaveReportPassword')"
                           [enabled]="exportService.exportSettings.Format == 'Mdx'"
                           (onchange)="exportService.exportSettings.Password = $event.value">
                        </sti-text-box>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

          <tr *ngIf="exportFormSettings?.groups.pageRangeGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('PagesRange')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.pageRangeGroup.opened"
               (action)="exportFormSettings.groups.pageRangeGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pagesRangeAll
                           [name]="baseForm.name + 'PagesRangeAll'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeAll')"
                           [tooltip]="model.loc('PagesRangeAllTooltip')"
                           [margin]="'6px 8px 6px 8px'"
                           [checked]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           [enabled]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = 'All'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pageRangeCurrentPage
                           [name]="baseForm.name + 'PageRangeCurrentPage'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeCurrentPage')"
                           [tooltip]="model.loc('PagesRangeCurrentPageTooltip')"
                           [margin]="'0px 8px 4px 8px'"
                           [checked]="exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = (model.reportParams.pageNumber + 1).toString()">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'PageRangePages'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangePages')"
                           [tooltip]="model.loc('PagesRangePagesTooltip')"
                           [margin]="'0px 8px 0px 8px'"
                           [paddingLeftLastCell]="'60px'"
                           (action)="exportService.exportSettings.PageRange = pagesRange.element.nativeElement.value">
                              <sti-text-box #pagesRange
                                [width]="130"
                                [tooltip]="model.loc('PagesRangePagesTooltip')"
                                [margin]="'0px 0px 0px 30px'"
                                (onchange)="exportService.exportSettings.PageRange = $event.value"
                                (onblur)="exportService.exportSettings.PageRange = $event.value">
                              </sti-text-box>
                        </sti-radio-button>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

        <tr *ngIf="exportFormSettings?.groups.settingsGroup.visible"class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SettingsGroup')"
                [opened]="exportFormSettings.groups.settingsGroup.opened"
                [width]="390"
                [margin]="'4px'"
                [innerPadding]="'4px 0 4px 0'"
                (action)="exportFormSettings.groups.settingsGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr *ngFor="let comp of exportFormSettings.components">
                      <td *ngIf="comp.label != null" style="padding: 0px 8px; min-width: 150px;" [attr.title]="comp.tooltip">
                        {{comp.label}}
                      </td>

                      <td *ngIf="comp.name == 'UseDigitalSignature'">
                        <sti-check-box
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>
                      </td>

                      <td [attr.colSpan]="comp.label != null || comp.name == 'DocumentSecurityButton' || comp.name == 'UseDigitalSignature' ? 1 : 2">
                        <sti-drop-down-list-for-export-form *ngIf="comp.type == 'DropDownListForExportForm'"
                           [width]="comp.width"
                           [items]="comp.items"
                           [key]="getValue(comp, 'dropDownList')"
                           [margin]="comp.margin"
                           [verticalAlign]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'middle' : null"
                           [styleDisplay]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'inline-block' : null"
                           [enabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event.key)">
                        </sti-drop-down-list-for-export-form>

                        <div *ngIf="comp.name == 'ImageQuality' || comp.name == 'ImageResolution'"
                           [style.display]="'inline-block'">
                          {{comp.name == 'ImageQuality' ? '%' : 'dpi'}}
                        </div>

                        <sti-text-box *ngIf="comp.type == 'TextBox'"
                           [width]="comp.width"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [type]="getTextBoxType(comp.name)"
                           [enabled]="!comp.disabled"
                           [value]="getValue(comp)"
                           [enabled]="!disabledComponents[comp.name]"
                           (onchange)="componentAction(comp, $event.value)">
                        </sti-text-box>

                        <sti-check-box *ngIf="comp.type == 'CheckBox' || comp.type == 'DigitalSignature'"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           [isEnabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>

                      </td>

                      <td *ngIf="comp.name == 'DocumentSecurityButton'">
                        <sti-button #button
                           [width]="comp.width"
                           [arrow]="'Down'"
                           [minWidth]="'163px'"
                           [captionAlign]="'center'"
                           [display]="'inline-block'"
                           [styleName]="'stiJsViewerFormButton'"
                           [margin]="'2px 8px'"
                           [innerTableWidth]="'100%'"
                           [captionWidth]="'100%'"
                           [caption]="comp.name == 'DocumentSecurityButton' ? comp.caption : ''"
                           [enabled]="!disabledComponents[comp.name + 'Button']"
                           (action)="showMenu(comp, button)">
                        </sti-button>
                      </td>
                    </tr>
                  </tbody>
                </table>

              </sti-group-panel>
            </td>
        </tr>

        <tr *ngIf="model.options.exports.showOpenAfterExport && exportFormSettings?.openAfterExport && !exportService.sendMail" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
                <sti-check-box [captionText]="model.loc('OpenAfterExport')"
                  [tooltip]="model.loc('OpenAfterExportTooltip')"
                  [margin]="'4px 8px 4px 8px'"
                  [isChecked]="exportService.exportSettings.OpenAfterExport"
                  (action)="exportService.exportSettings.OpenAfterExport = $event">
                </sti-check-box>
            </td>
        </tr>
      </tbody>
    </table>

    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "directive", type: i8.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i10.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i11.CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }, { kind: "component", type: i12.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }, { kind: "component", type: i13.GroupPanelComponent, selector: "sti-group-panel", inputs: ["width", "caption", "innerPadding", "opened", "margin"], outputs: ["action"] }, { kind: "component", type: i14.RadioButtonComponent, selector: "sti-radio-button", inputs: ["groupName", "name", "enabled", "checked", "tooltip", "caption", "margin", "paddingLeftLastCell"], outputs: ["action"] }, { kind: "component", type: i15.DropDownListForExportFormComponent, selector: "sti-drop-down-list-for-export-form", inputs: ["items", "width", "key", "margin", "enabled", "styleDisplay", "verticalAlign"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ExportFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-export-form',
                    template: `
    <sti-base-form #baseForm [fontFamily]="model.options.toolbar.fontFamily"
    [color]="model.options.toolbar.fontColor"
    [fontSize]="'12px'"
    [containerPadding]="'3px'"
    [name]="'exportForm'"
    [caption]="model.loc('ExportFormTitle')"
    [defaultTop]="150"
    (changeVisibility)="changeVisibility($event)"
    (action)="action()">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
      <tbody>
          <tr *ngIf="exportFormSettings?.groups.savingReportGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SavingReport')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.savingReportGroup.opened"
               (action)="exportFormSettings.groups.savingReportGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #saveReportMdc
                           [name]="baseForm.name + 'SaveReportMdc'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdc')"
                           [margin]="'6px 8px 3px 8px'"
                           [checked]="true"
                           (action)="exportService.exportSettings.Format = 'Mdc'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdz'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdz')"
                           [margin]="'3px 8px 3px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdz'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'SaveReportMdx'"
                           [groupName]="baseForm.name + 'SavingReportGroup'"
                           [caption]="model.loc('SaveReportMdx')"
                           [margin]="'3px 8px 0px 8px'"
                           (action)="exportService.exportSettings.Format = 'Mdx'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" style="padding: 0px 8px; min-width: 150px;" [attr.title]="model.loc('PasswordSaveReportTooltip')">
                      {{model.loc('PasswordSaveReport')}}
                      </td>
                      <td>
                        <sti-text-box
                           [width]="140"
                           [tooltip]="model.loc('PasswordSaveReportTooltip')"
                           [margin]="'4px 8px 0px 8px'"
                           [type]="getTextBoxType('SaveReportPassword')"
                           [enabled]="exportService.exportSettings.Format == 'Mdx'"
                           (onchange)="exportService.exportSettings.Password = $event.value">
                        </sti-text-box>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

          <tr *ngIf="exportFormSettings?.groups.pageRangeGroup.visible" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('PagesRange')"
               [width]="390"
               [margin]="'4px'"
               [innerPadding]="'4px 0 4px 0'"
               [opened]="exportFormSettings.groups.pageRangeGroup.opened"
               (action)="exportFormSettings.groups.pageRangeGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pagesRangeAll
                           [name]="baseForm.name + 'PagesRangeAll'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeAll')"
                           [tooltip]="model.loc('PagesRangeAllTooltip')"
                           [margin]="'6px 8px 6px 8px'"
                           [checked]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           [enabled]="!exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = 'All'">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button #pageRangeCurrentPage
                           [name]="baseForm.name + 'PageRangeCurrentPage'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangeCurrentPage')"
                           [tooltip]="model.loc('PagesRangeCurrentPageTooltip')"
                           [margin]="'0px 8px 4px 8px'"
                           [checked]="exportFormSettings.groups.pageRangeGroup.pageRangeAllIsDisabled"
                           (action)="exportService.exportSettings.PageRange = (model.reportParams.pageNumber + 1).toString()">
                        </sti-radio-button>
                      </td>
                    </tr>
                    <tr class="stiJsViewerClearAllStyles">
                      <td class="stiJsViewerClearAllStyles" colspan="2">
                        <sti-radio-button
                           [name]="baseForm.name + 'PageRangePages'"
                           [groupName]="baseForm.name + 'PageRangeGroup'"
                           [caption]="model.loc('PagesRangePages')"
                           [tooltip]="model.loc('PagesRangePagesTooltip')"
                           [margin]="'0px 8px 0px 8px'"
                           [paddingLeftLastCell]="'60px'"
                           (action)="exportService.exportSettings.PageRange = pagesRange.element.nativeElement.value">
                              <sti-text-box #pagesRange
                                [width]="130"
                                [tooltip]="model.loc('PagesRangePagesTooltip')"
                                [margin]="'0px 0px 0px 30px'"
                                (onchange)="exportService.exportSettings.PageRange = $event.value"
                                (onblur)="exportService.exportSettings.PageRange = $event.value">
                              </sti-text-box>
                        </sti-radio-button>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </sti-group-panel>
            </td>
          </tr>

        <tr *ngIf="exportFormSettings?.groups.settingsGroup.visible"class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
              <sti-group-panel [caption]="model.loc('SettingsGroup')"
                [opened]="exportFormSettings.groups.settingsGroup.opened"
                [width]="390"
                [margin]="'4px'"
                [innerPadding]="'4px 0 4px 0'"
                (action)="exportFormSettings.groups.settingsGroup.opened=$event">
                <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
                  <tbody>
                    <tr *ngFor="let comp of exportFormSettings.components">
                      <td *ngIf="comp.label != null" style="padding: 0px 8px; min-width: 150px;" [attr.title]="comp.tooltip">
                        {{comp.label}}
                      </td>

                      <td *ngIf="comp.name == 'UseDigitalSignature'">
                        <sti-check-box
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>
                      </td>

                      <td [attr.colSpan]="comp.label != null || comp.name == 'DocumentSecurityButton' || comp.name == 'UseDigitalSignature' ? 1 : 2">
                        <sti-drop-down-list-for-export-form *ngIf="comp.type == 'DropDownListForExportForm'"
                           [width]="comp.width"
                           [items]="comp.items"
                           [key]="getValue(comp, 'dropDownList')"
                           [margin]="comp.margin"
                           [verticalAlign]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'middle' : null"
                           [styleDisplay]="comp.name == 'ImageQuality' || comp.name == 'ImageResolution' ? 'inline-block' : null"
                           [enabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event.key)">
                        </sti-drop-down-list-for-export-form>

                        <div *ngIf="comp.name == 'ImageQuality' || comp.name == 'ImageResolution'"
                           [style.display]="'inline-block'">
                          {{comp.name == 'ImageQuality' ? '%' : 'dpi'}}
                        </div>

                        <sti-text-box *ngIf="comp.type == 'TextBox'"
                           [width]="comp.width"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [type]="getTextBoxType(comp.name)"
                           [enabled]="!comp.disabled"
                           [value]="getValue(comp)"
                           [enabled]="!disabledComponents[comp.name]"
                           (onchange)="componentAction(comp, $event.value)">
                        </sti-text-box>

                        <sti-check-box *ngIf="comp.type == 'CheckBox' || comp.type == 'DigitalSignature'"
                           [tooltip]="comp.tooltip"
                           [margin]="comp.margin"
                           [captionText]="comp.caption"
                           [isChecked]="getValue(comp)"
                           [isEnabled]="!disabledComponents[comp.name]"
                           (action)="componentAction(comp, $event)">
                        </sti-check-box>

                      </td>

                      <td *ngIf="comp.name == 'DocumentSecurityButton'">
                        <sti-button #button
                           [width]="comp.width"
                           [arrow]="'Down'"
                           [minWidth]="'163px'"
                           [captionAlign]="'center'"
                           [display]="'inline-block'"
                           [styleName]="'stiJsViewerFormButton'"
                           [margin]="'2px 8px'"
                           [innerTableWidth]="'100%'"
                           [captionWidth]="'100%'"
                           [caption]="comp.name == 'DocumentSecurityButton' ? comp.caption : ''"
                           [enabled]="!disabledComponents[comp.name + 'Button']"
                           (action)="showMenu(comp, button)">
                        </sti-button>
                      </td>
                    </tr>
                  </tbody>
                </table>

              </sti-group-panel>
            </td>
        </tr>

        <tr *ngIf="model.options.exports.showOpenAfterExport && exportFormSettings?.openAfterExport && !exportService.sendMail" class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles" colspan="2">
                <sti-check-box [captionText]="model.loc('OpenAfterExport')"
                  [tooltip]="model.loc('OpenAfterExportTooltip')"
                  [margin]="'4px 8px 4px 8px'"
                  [isChecked]="exportService.exportSettings.OpenAfterExport"
                  (action)="exportService.exportSettings.OpenAfterExport = $event">
                </sti-check-box>
            </td>
        </tr>
      </tbody>
    </table>

    </sti-base-form>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ExportService }, { type: i3.HelperService }, { type: i4.FormService }, { type: i5.MenuService }, { type: i6.CollectionsService }, { type: i7.ControllerService }]; }, propDecorators: { baseForm: [{
                type: ViewChild,
                args: ['baseForm']
            }], saveReportMdc: [{
                type: ViewChild,
                args: ['saveReportMdc']
            }], pagesRangeAll: [{
                type: ViewChild,
                args: ['pagesRangeAll']
            }], pageRangeCurrentPage: [{
                type: ViewChild,
                args: ['pageRangeCurrentPage']
            }], exportFormSettings: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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