import { Component } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "./form.service";
import * as i3 from "./base-form.component";
export class ErrorMessageFormComponent {
    constructor(model, formService) {
        this.model = model;
        this.formService = formService;
    }
    ngOnInit() { }
    getImage() {
        const messageType = this.model.errorMessage?.type;
        if (messageType === 'Warning') {
            return this.model.img('MsgFormWarning.png');
        }
        else if (messageType === true || messageType === 'Info') {
            return this.model.img('MsgFormInfo.png');
        }
        else {
            return this.model.img('MsgFormError.png');
        }
    }
}
ErrorMessageFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ErrorMessageFormComponent, deps: [{ token: i1.ModelService }, { token: i2.FormService }], target: i0.ɵɵFactoryTarget.Component });
ErrorMessageFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ErrorMessageFormComponent, selector: "sti-error-message-form", ngImport: i0, template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'errorMessageForm'"
      [caption]="model.loc(model.errorMessage?.type == 'Error' ? 'Error' : 'FormViewerTitle')"
      [level]="4"
      [defaultTop]="150"
      [showCancel]="false"
      (action)="formService.closeForm('errorMessageForm')">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <img [attr.src]="getImage()" style="padding: 15px; height: 32px; width: 32px;">
            </td>
            <td class="stiJsViewerMessagesFormDescription" style="max-width: 600px;"
              [style.color]="model.options.toolbar.fontColor" [innerHTML]="model.errorMessage?.error">
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `, isInline: true, dependencies: [{ kind: "component", type: i3.BaseFormComponent, selector: "sti-base-form", inputs: ["level", "caption", "helpUrl", "fontFamily", "color", "fontSize", "containerPadding", "name", "defaultTop", "showCancel", "showButtons", "showSeparator"], outputs: ["changeVisibility", "action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ErrorMessageFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-error-message-form',
                    template: `
    <sti-base-form [fontFamily]="model.options.toolbar.fontFamily"
      [color]="model.options.toolbar.fontColor"
      [name]="'errorMessageForm'"
      [caption]="model.loc(model.errorMessage?.type == 'Error' ? 'Error' : 'FormViewerTitle')"
      [level]="4"
      [defaultTop]="150"
      [showCancel]="false"
      (action)="formService.closeForm('errorMessageForm')">
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <img [attr.src]="getImage()" style="padding: 15px; height: 32px; width: 32px;">
            </td>
            <td class="stiJsViewerMessagesFormDescription" style="max-width: 600px;"
              [style.color]="model.options.toolbar.fontColor" [innerHTML]="model.errorMessage?.error">
            </td>
          </tr>
        </tbody>
      </table>
    </sti-base-form>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.FormService }]; } });
//# sourceMappingURL=data:application/json;base64,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