import { Component, Input, EventEmitter, Output, ViewChild } from '@angular/core';
import { trigger, state, transition, style, animate } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "./form.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
import * as i6 from "../controls/form-button.component";
export class BaseFormComponent {
    constructor(model, helper, formService) {
        this.model = model;
        this.helper = helper;
        this.formService = formService;
        this.changeVisibility = new EventEmitter();
        this.action = new EventEmitter();
        this.level = 1;
        this.showCancel = true;
        this.showButtons = true;
        this.showSeparator = true;
        this.display = 'none';
    }
    ngOnInit() { }
    startAnimation(event) {
        if (event.toState === 'visible') {
            this.display = '';
            if (this.defaultTop != null) {
                this.formService.centerForm(this, this.defaultTop);
            }
        }
    }
    doneAnimation(event) {
        if (event.toState === 'hidden') {
            this.display = 'none';
        }
        this.changeVisibility.emit(event.toState);
    }
}
BaseFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: BaseFormComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.FormService }], target: i0.ɵɵFactoryTarget.Component });
BaseFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: BaseFormComponent, selector: "sti-base-form", inputs: { level: "level", caption: "caption", helpUrl: "helpUrl", fontFamily: "fontFamily", color: "color", fontSize: "fontSize", containerPadding: "containerPadding", name: "name", defaultTop: "defaultTop", showCancel: "showCancel", showButtons: "showButtons", showSeparator: "showSeparator" }, outputs: { changeVisibility: "changeVisibility", action: "action" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element class="stiJsViewerForm"
      [style.zIndex]="level * 10 + 1"
      [@.disabled]="!model.options.toolbar.menuAnimation"
      [style.fontFamily]="fontFamily"
      [style.color]="color"
      [style.fontSize]="fontSize"
      [style.left.px]="formService.form?.left"
      [style.top.px]="formService.form?.top"
      [style.display]="display"
      [@showForm]="formService.form?.name == name ? 'visible' : 'hidden'"
      (@showForm.start)="startAnimation($event)"
      (@showForm.done)="doneAnimation($event)">
      <div class="stiJsViewerFormHeader"
        (mousedown)="formService.startMove(name, $event)"
        (touchstart)="formService.startMove(name, null, $event)"
        (touchmove)="formService.move($event)"
        (touchend)="formService.stopMove()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="text-align: left; padding: 5px 10px 8px 15px;">
                {{caption}}
              </td>
              <td *ngIf="helpUrl != null && model.options.appearance.showDialogsHelp" class="stiJsViewerClearAllStyles" style="width: 20px; text-align: right; padding: 2px 0px 1px 0px; vertical-align: top;">
                <sti-button [imageMargin]="'0 2px 0 2px'" [display]="'inline-block'" (action)="helper.showHelpWindow(helpUrl)">
                </sti-button>
              </td>
              <td class="stiJsViewerClearAllStyles" style="vertical-align: top; width: 30px; text-align: right; padding: 2px 1px 1px;">
                <sti-button [imageMargin]="'0 2px 0 2px'" [display]="'inline-block'" [imageName]="'CloseForm.png'" (action)="formService.closeForm(name)">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>

      <div class="stiJsViewerFormContainer" [style.padding]="containerPadding">
        <ng-content>
        </ng-content>
      </div>

      <div *ngIf="showSeparator" class="stiJsViewerFormSeparator"></div>

      <div *ngIf="showButtons" class="stiJsViewerFormButtonsPanel">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding: 8px;">
                <sti-form-button [caption]="model.loc('ButtonOk')" (action)="action.emit()">
                </sti-form-button>
              </td>
              <td *ngIf="showCancel" class="stiJsViewerClearAllStyles" style="padding: 8px 8px 8px 0px;">
                <sti-form-button [caption]="model.loc('ButtonCancel')" (action)="formService.closeForm(name)">
                </sti-form-button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>

    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i6.FormButtonComponent, selector: "sti-form-button", inputs: ["caption", "actionName", "imageName", "imageCellWidth", "captionPadding", "margin", "captionAlign"], outputs: ["action"] }], animations: [
        trigger('showForm', [
            state('hidden', style({ opacity: '0' })),
            state('visible', style({ opacity: '1' })),
            transition('hidden => visible', [
                animate('200ms ease-in-out')
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: BaseFormComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-base-form',
                    template: `
    <div #element class="stiJsViewerForm"
      [style.zIndex]="level * 10 + 1"
      [@.disabled]="!model.options.toolbar.menuAnimation"
      [style.fontFamily]="fontFamily"
      [style.color]="color"
      [style.fontSize]="fontSize"
      [style.left.px]="formService.form?.left"
      [style.top.px]="formService.form?.top"
      [style.display]="display"
      [@showForm]="formService.form?.name == name ? 'visible' : 'hidden'"
      (@showForm.start)="startAnimation($event)"
      (@showForm.done)="doneAnimation($event)">
      <div class="stiJsViewerFormHeader"
        (mousedown)="formService.startMove(name, $event)"
        (touchstart)="formService.startMove(name, null, $event)"
        (touchmove)="formService.move($event)"
        (touchend)="formService.stopMove()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%;">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="text-align: left; padding: 5px 10px 8px 15px;">
                {{caption}}
              </td>
              <td *ngIf="helpUrl != null && model.options.appearance.showDialogsHelp" class="stiJsViewerClearAllStyles" style="width: 20px; text-align: right; padding: 2px 0px 1px 0px; vertical-align: top;">
                <sti-button [imageMargin]="'0 2px 0 2px'" [display]="'inline-block'" (action)="helper.showHelpWindow(helpUrl)">
                </sti-button>
              </td>
              <td class="stiJsViewerClearAllStyles" style="vertical-align: top; width: 30px; text-align: right; padding: 2px 1px 1px;">
                <sti-button [imageMargin]="'0 2px 0 2px'" [display]="'inline-block'" [imageName]="'CloseForm.png'" (action)="formService.closeForm(name)">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>

      <div class="stiJsViewerFormContainer" [style.padding]="containerPadding">
        <ng-content>
        </ng-content>
      </div>

      <div *ngIf="showSeparator" class="stiJsViewerFormSeparator"></div>

      <div *ngIf="showButtons" class="stiJsViewerFormButtonsPanel">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding: 8px;">
                <sti-form-button [caption]="model.loc('ButtonOk')" (action)="action.emit()">
                </sti-form-button>
              </td>
              <td *ngIf="showCancel" class="stiJsViewerClearAllStyles" style="padding: 8px 8px 8px 0px;">
                <sti-form-button [caption]="model.loc('ButtonCancel')" (action)="formService.closeForm(name)">
                </sti-form-button>
              </td>
            </tr>
          </tbody>
        </table>
      </div>

    </div>
  `,
                    animations: [
                        trigger('showForm', [
                            state('hidden', style({ opacity: '0' })),
                            state('visible', style({ opacity: '1' })),
                            transition('hidden => visible', [
                                animate('200ms ease-in-out')
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.FormService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], changeVisibility: [{
                type: Output
            }], action: [{
                type: Output
            }], level: [{
                type: Input
            }], caption: [{
                type: Input
            }], helpUrl: [{
                type: Input
            }], fontFamily: [{
                type: Input
            }], color: [{
                type: Input
            }], fontSize: [{
                type: Input
            }], containerPadding: [{
                type: Input
            }], name: [{
                type: Input
            }], defaultTop: [{
                type: Input
            }], showCancel: [{
                type: Input
            }], showButtons: [{
                type: Input
            }], showSeparator: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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