import { Component, ViewChild } from '@angular/core';
import { trigger, state, transition, animate, style, keyframes } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/tooltip.service";
import * as i3 from "../services/helper.service";
import * as i4 from "@angular/common";
import * as i5 from "./button.component";
export class TooltipComponent {
    constructor(model, tooltipService, helper) {
        this.model = model;
        this.tooltipService = tooltipService;
        this.helper = helper;
    }
    ngAfterViewInit() {
        this.model.controls.tooltip.el = this.element;
    }
    ngOnInit() { }
    action() {
        this.helper.showHelpWindow(this.tooltipService.helpLink);
    }
}
TooltipComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipComponent, deps: [{ token: i1.ModelService }, { token: i2.TooltipService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Component });
TooltipComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: TooltipComponent, selector: "sti-tooltip", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
      <div #element class='stiJsViewerToolTip' [@expandDown]="tooltipService.state"
        [style.left.px]='tooltipService.left' [style.top.px]='tooltipService.top'
        (mouseover)="tooltipService.showFromTooltip()" (mouseout)="tooltipService.hide()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%;"
          [style.border]="model.options.appearance.showTooltipsHelp ? '' : 0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerToolTipTextCell">
                {{tooltipService.caption}}
              </td>
            </tr>
            <tr *ngIf="model.options.appearance.showTooltipsHelp" class="stiJsViewerClearAllStyles">
              <td  class="stiJsViewerClearAllStyles">
                <sti-button [caption]="model.loc('TellMeMore')"
                    [imageName]="'HelpIcon.png'"
                    [margin]="'4px 8px 4px 8px'"
                    (action)='action()'
                    [styleName]="'stiJsViewerHyperlinkButton'">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }], animations: [
        trigger('expandDown', [
            state('initial', style({ opacity: 0, display: 'none' })),
            state('preInitial', style({ opacity: 0, display: 'block' })),
            state('preInitial2', style({ opacity: 0, display: 'block' })),
            state('expanded', style({ opacity: 1, display: 'block' })),
            transition('preInitial => expanded', [
                animate('300ms 300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 0, offset: 0 }),
                    style({ display: 'block', opacity: 1, offset: 1 }),
                ]))
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TooltipComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-tooltip',
                    template: `
      <div #element class='stiJsViewerToolTip' [@expandDown]="tooltipService.state"
        [style.left.px]='tooltipService.left' [style.top.px]='tooltipService.top'
        (mouseover)="tooltipService.showFromTooltip()" (mouseout)="tooltipService.hide()">
        <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%;"
          [style.border]="model.options.appearance.showTooltipsHelp ? '' : 0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerToolTipTextCell">
                {{tooltipService.caption}}
              </td>
            </tr>
            <tr *ngIf="model.options.appearance.showTooltipsHelp" class="stiJsViewerClearAllStyles">
              <td  class="stiJsViewerClearAllStyles">
                <sti-button [caption]="model.loc('TellMeMore')"
                    [imageName]="'HelpIcon.png'"
                    [margin]="'4px 8px 4px 8px'"
                    (action)='action()'
                    [styleName]="'stiJsViewerHyperlinkButton'">
                </sti-button>
              </td>
            </tr>
          </tbody>
        </table>
    </div>
  `,
                    animations: [
                        trigger('expandDown', [
                            state('initial', style({ opacity: 0, display: 'none' })),
                            state('preInitial', style({ opacity: 0, display: 'block' })),
                            state('preInitial2', style({ opacity: 0, display: 'block' })),
                            state('expanded', style({ opacity: 1, display: 'block' })),
                            transition('preInitial => expanded', [
                                animate('300ms 300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.TooltipService }, { type: i3.HelperService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9vbHRpcC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9zdGltdWxzb2Z0LXZpZXdlci1hbmd1bGFyL3NyYy9saWIvY29udHJvbHMvdG9vbHRpcC5jb21wb25lbnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLFNBQVMsRUFBeUIsU0FBUyxFQUFjLE1BQU0sZUFBZSxDQUFDO0FBRXhGLE9BQU8sRUFBRSxPQUFPLEVBQUUsS0FBSyxFQUFFLFVBQVUsRUFBRSxPQUFPLEVBQUUsS0FBSyxFQUFFLFNBQVMsRUFBRSxNQUFNLHFCQUFxQixDQUFDOzs7Ozs7O0FBZ0Q1RixNQUFNLE9BQU8sZ0JBQWdCO0lBSTNCLFlBQW1CLEtBQW1CLEVBQVMsY0FBOEIsRUFBUyxNQUFxQjtRQUF4RixVQUFLLEdBQUwsS0FBSyxDQUFjO1FBQVMsbUJBQWMsR0FBZCxjQUFjLENBQWdCO1FBQVMsV0FBTSxHQUFOLE1BQU0sQ0FBZTtJQUFJLENBQUM7SUFFaEgsZUFBZTtRQUNiLElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUNoRCxDQUFDO0lBRUQsUUFBUSxLQUFLLENBQUM7SUFFZCxNQUFNO1FBQ0osSUFBSSxDQUFDLE1BQU0sQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUMzRCxDQUFDOzs2R0FkVSxnQkFBZ0I7aUdBQWhCLGdCQUFnQix1SkExQ2pCOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0dBeUJULHc0QkFDVztRQUNWLE9BQU8sQ0FBQyxZQUFZLEVBQUU7WUFDcEIsS0FBSyxDQUFDLFNBQVMsRUFBRSxLQUFLLENBQUMsRUFBRSxPQUFPLEVBQUUsQ0FBQyxFQUFFLE9BQU8sRUFBRSxNQUFNLEVBQUUsQ0FBQyxDQUFDO1lBQ3hELEtBQUssQ0FBQyxZQUFZLEVBQUUsS0FBSyxDQUFDLEVBQUUsT0FBTyxFQUFFLENBQUMsRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLENBQUMsQ0FBQztZQUM1RCxLQUFLLENBQUMsYUFBYSxFQUFFLEtBQUssQ0FBQyxFQUFFLE9BQU8sRUFBRSxDQUFDLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUM7WUFDN0QsS0FBSyxDQUFDLFVBQVUsRUFBRSxLQUFLLENBQUMsRUFBRSxPQUFPLEVBQUUsQ0FBQyxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsQ0FBQyxDQUFDO1lBQzFELFVBQVUsQ0FBQyx3QkFBd0IsRUFBRTtnQkFDbkMsT0FBTyxDQUFDLHlCQUF5QixFQUFFLFNBQVMsQ0FBQztvQkFDM0MsS0FBSyxDQUFDLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsQ0FBQyxFQUFFLE1BQU0sRUFBRSxDQUFDLEVBQUUsQ0FBQztvQkFDbEQsS0FBSyxDQUFDLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsQ0FBQyxFQUFFLE1BQU0sRUFBRSxDQUFDLEVBQUUsQ0FBQztpQkFDbkQsQ0FBQyxDQUFDO2FBQ0osQ0FBQztTQUNILENBQUM7S0FDSDsyRkFHVSxnQkFBZ0I7a0JBNUM1QixTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSxhQUFhO29CQUN2QixRQUFRLEVBQUU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7R0F5QlQ7b0JBQ0QsVUFBVSxFQUFFO3dCQUNWLE9BQU8sQ0FBQyxZQUFZLEVBQUU7NEJBQ3BCLEtBQUssQ0FBQyxTQUFTLEVBQUUsS0FBSyxDQUFDLEVBQUUsT0FBTyxFQUFFLENBQUMsRUFBRSxPQUFPLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQzs0QkFDeEQsS0FBSyxDQUFDLFlBQVksRUFBRSxLQUFLLENBQUMsRUFBRSxPQUFPLEVBQUUsQ0FBQyxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsQ0FBQyxDQUFDOzRCQUM1RCxLQUFLLENBQUMsYUFBYSxFQUFFLEtBQUssQ0FBQyxFQUFFLE9BQU8sRUFBRSxDQUFDLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUM7NEJBQzdELEtBQUssQ0FBQyxVQUFVLEVBQUUsS0FBSyxDQUFDLEVBQUUsT0FBTyxFQUFFLENBQUMsRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLENBQUMsQ0FBQzs0QkFDMUQsVUFBVSxDQUFDLHdCQUF3QixFQUFFO2dDQUNuQyxPQUFPLENBQUMseUJBQXlCLEVBQUUsU0FBUyxDQUFDO29DQUMzQyxLQUFLLENBQUMsRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxDQUFDLEVBQUUsTUFBTSxFQUFFLENBQUMsRUFBRSxDQUFDO29DQUNsRCxLQUFLLENBQUMsRUFBRSxPQUFPLEVBQUUsT0FBTyxFQUFFLE9BQU8sRUFBRSxDQUFDLEVBQUUsTUFBTSxFQUFFLENBQUMsRUFBRSxDQUFDO2lDQUNuRCxDQUFDLENBQUM7NkJBQ0osQ0FBQzt5QkFDSCxDQUFDO3FCQUNIO2lCQUNGOzRKQUl1QixPQUFPO3NCQUE1QixTQUFTO3VCQUFDLFNBQVMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIE9uSW5pdCwgQWZ0ZXJWaWV3SW5pdCwgVmlld0NoaWxkLCBFbGVtZW50UmVmIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IE1vZGVsU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL21vZGVsLnNlcnZpY2UnO1xyXG5pbXBvcnQgeyB0cmlnZ2VyLCBzdGF0ZSwgdHJhbnNpdGlvbiwgYW5pbWF0ZSwgc3R5bGUsIGtleWZyYW1lcyB9IGZyb20gJ0Bhbmd1bGFyL2FuaW1hdGlvbnMnO1xyXG5pbXBvcnQgeyBUb29sdGlwU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL3Rvb2x0aXAuc2VydmljZSc7XHJcbmltcG9ydCB7IEhlbHBlclNlcnZpY2UgfSBmcm9tICcuLi9zZXJ2aWNlcy9oZWxwZXIuc2VydmljZSc7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3N0aS10b29sdGlwJyxcclxuICB0ZW1wbGF0ZTogYFxyXG4gICAgICA8ZGl2ICNlbGVtZW50IGNsYXNzPSdzdGlKc1ZpZXdlclRvb2xUaXAnIFtAZXhwYW5kRG93bl09XCJ0b29sdGlwU2VydmljZS5zdGF0ZVwiXHJcbiAgICAgICAgW3N0eWxlLmxlZnQucHhdPSd0b29sdGlwU2VydmljZS5sZWZ0JyBbc3R5bGUudG9wLnB4XT0ndG9vbHRpcFNlcnZpY2UudG9wJ1xyXG4gICAgICAgIChtb3VzZW92ZXIpPVwidG9vbHRpcFNlcnZpY2Uuc2hvd0Zyb21Ub29sdGlwKClcIiAobW91c2VvdXQpPVwidG9vbHRpcFNlcnZpY2UuaGlkZSgpXCI+XHJcbiAgICAgICAgPHRhYmxlIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiIGNlbGxwYWRkaW5nPVwiMFwiIGNlbGxzcGFjaW5nPVwiMFwiIHN0eWxlPVwiaGVpZ2h0OiAxMDAlO1wiXHJcbiAgICAgICAgICBbc3R5bGUuYm9yZGVyXT1cIm1vZGVsLm9wdGlvbnMuYXBwZWFyYW5jZS5zaG93VG9vbHRpcHNIZWxwID8gJycgOiAwXCI+XHJcbiAgICAgICAgICA8dGJvZHk+XHJcbiAgICAgICAgICAgIDx0ciBjbGFzcz1cInN0aUpzVmlld2VyQ2xlYXJBbGxTdHlsZXNcIj5cclxuICAgICAgICAgICAgICA8dGQgY2xhc3M9XCJzdGlKc1ZpZXdlclRvb2xUaXBUZXh0Q2VsbFwiPlxyXG4gICAgICAgICAgICAgICAge3t0b29sdGlwU2VydmljZS5jYXB0aW9ufX1cclxuICAgICAgICAgICAgICA8L3RkPlxyXG4gICAgICAgICAgICA8L3RyPlxyXG4gICAgICAgICAgICA8dHIgKm5nSWY9XCJtb2RlbC5vcHRpb25zLmFwcGVhcmFuY2Uuc2hvd1Rvb2x0aXBzSGVscFwiIGNsYXNzPVwic3RpSnNWaWV3ZXJDbGVhckFsbFN0eWxlc1wiPlxyXG4gICAgICAgICAgICAgIDx0ZCAgY2xhc3M9XCJzdGlKc1ZpZXdlckNsZWFyQWxsU3R5bGVzXCI+XHJcbiAgICAgICAgICAgICAgICA8c3RpLWJ1dHRvbiBbY2FwdGlvbl09XCJtb2RlbC5sb2MoJ1RlbGxNZU1vcmUnKVwiXHJcbiAgICAgICAgICAgICAgICAgICAgW2ltYWdlTmFtZV09XCInSGVscEljb24ucG5nJ1wiXHJcbiAgICAgICAgICAgICAgICAgICAgW21hcmdpbl09XCInNHB4IDhweCA0cHggOHB4J1wiXHJcbiAgICAgICAgICAgICAgICAgICAgKGFjdGlvbik9J2FjdGlvbigpJ1xyXG4gICAgICAgICAgICAgICAgICAgIFtzdHlsZU5hbWVdPVwiJ3N0aUpzVmlld2VySHlwZXJsaW5rQnV0dG9uJ1wiPlxyXG4gICAgICAgICAgICAgICAgPC9zdGktYnV0dG9uPlxyXG4gICAgICAgICAgICAgIDwvdGQ+XHJcbiAgICAgICAgICAgIDwvdHI+XHJcbiAgICAgICAgICA8L3Rib2R5PlxyXG4gICAgICAgIDwvdGFibGU+XHJcbiAgICA8L2Rpdj5cclxuICBgLFxyXG4gIGFuaW1hdGlvbnM6IFtcclxuICAgIHRyaWdnZXIoJ2V4cGFuZERvd24nLCBbXHJcbiAgICAgIHN0YXRlKCdpbml0aWFsJywgc3R5bGUoeyBvcGFjaXR5OiAwLCBkaXNwbGF5OiAnbm9uZScgfSkpLFxyXG4gICAgICBzdGF0ZSgncHJlSW5pdGlhbCcsIHN0eWxlKHsgb3BhY2l0eTogMCwgZGlzcGxheTogJ2Jsb2NrJyB9KSksXHJcbiAgICAgIHN0YXRlKCdwcmVJbml0aWFsMicsIHN0eWxlKHsgb3BhY2l0eTogMCwgZGlzcGxheTogJ2Jsb2NrJyB9KSksXHJcbiAgICAgIHN0YXRlKCdleHBhbmRlZCcsIHN0eWxlKHsgb3BhY2l0eTogMSwgZGlzcGxheTogJ2Jsb2NrJyB9KSksXHJcbiAgICAgIHRyYW5zaXRpb24oJ3ByZUluaXRpYWwgPT4gZXhwYW5kZWQnLCBbXHJcbiAgICAgICAgYW5pbWF0ZSgnMzAwbXMgMzAwbXMgZWFzZS1pbi1vdXQnLCBrZXlmcmFtZXMoW1xyXG4gICAgICAgICAgc3R5bGUoeyBkaXNwbGF5OiAnYmxvY2snLCBvcGFjaXR5OiAwLCBvZmZzZXQ6IDAgfSksXHJcbiAgICAgICAgICBzdHlsZSh7IGRpc3BsYXk6ICdibG9jaycsIG9wYWNpdHk6IDEsIG9mZnNldDogMSB9KSxcclxuICAgICAgICBdKSlcclxuICAgICAgXSlcclxuICAgIF0pXHJcbiAgXVxyXG59KVxyXG5cclxuZXhwb3J0IGNsYXNzIFRvb2x0aXBDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIEFmdGVyVmlld0luaXQge1xyXG5cclxuICBAVmlld0NoaWxkKCdlbGVtZW50JykgZWxlbWVudDogRWxlbWVudFJlZjtcclxuXHJcbiAgY29uc3RydWN0b3IocHVibGljIG1vZGVsOiBNb2RlbFNlcnZpY2UsIHB1YmxpYyB0b29sdGlwU2VydmljZTogVG9vbHRpcFNlcnZpY2UsIHB1YmxpYyBoZWxwZXI6IEhlbHBlclNlcnZpY2UpIHsgfVxyXG5cclxuICBuZ0FmdGVyVmlld0luaXQoKTogdm9pZCB7XHJcbiAgICB0aGlzLm1vZGVsLmNvbnRyb2xzLnRvb2x0aXAuZWwgPSB0aGlzLmVsZW1lbnQ7XHJcbiAgfVxyXG5cclxuICBuZ09uSW5pdCgpIHsgfVxyXG5cclxuICBhY3Rpb24oKSB7XHJcbiAgICB0aGlzLmhlbHBlci5zaG93SGVscFdpbmRvdyh0aGlzLnRvb2x0aXBTZXJ2aWNlLmhlbHBMaW5rKTtcclxuICB9XHJcblxyXG59XHJcbiJdfQ==