import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "@angular/common";
import * as i3 from "./parameters/parameter-checkbox.component";
export class TextBoxComponent {
    constructor(model) {
        this.model = model;
        this.enabled = true;
        this.focusOnCreate = false;
        this.action = new EventEmitter();
        this.onchange = new EventEmitter();
        this.onblur = new EventEmitter();
        this.selected = false;
        this.focused = false;
        this.over = false;
        this._readOnly = false;
        this.styleName = 'stiJsViewerTextBox';
    }
    ngAfterViewInit() {
        if (this.focusOnCreate) {
            setTimeout(() => {
                this.element.nativeElement.focus();
            });
        }
    }
    keypress(event) {
        if (!this.enabled) {
            return false;
        }
        if (event.keyCode === 13) {
            this.action.emit(event.target);
        }
    }
    onchanged(event) {
        this.onchange.emit(event.target);
    }
    get paddingInt() {
        return this.isNullableParam ? "0 0 0 22px" : this.padding;
    }
    focus() {
        this.oldValue = this.element.nativeElement.value;
    }
    get isNullableParam() {
        return this.variable?.basicType == 'NullableValue' || this.variable?.allowNullableString;
    }
    nullableAction(checked) {
        this.variable.isNull = !this.variable.isNull;
    }
    get height() {
        return this.model.options.isTouchDevice ? '26px' : '21px';
    }
    get className() {
        if (this._readOnly) {
            return this.styleName + ' ' + this.styleName + 'Default';
        }
        return this.styleName + ' ' + this.styleName + (this.selected ? 'Over' : (this.enabled ? (this.over ? 'Over' : 'Default') : 'Disabled'));
    }
    set readOnly(value) {
        this._readOnly = value;
        setTimeout(() => {
            try {
                this.element.nativeElement.setAttribute('unselectable', value ? 'on' : 'off');
                this.element.nativeElement.setAttribute('onselectstart', value ? 'return false' : '');
                this.element.nativeElement.readOnly = value;
            }
            catch (e) { }
        });
    }
    get readOnly() {
        return this._readOnly;
    }
    ngOnInit() { }
}
TextBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextBoxComponent, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Component });
TextBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: TextBoxComponent, selector: "sti-text-box", inputs: { width: "width", actionLostFocus: "actionLostFocus", tooltip: "tooltip", enabled: "enabled", value: "value", margin: "margin", focusOnCreate: "focusOnCreate", maxLength: "maxLength", color: "color", type: "type", padding: "padding", border: "border", variable: "variable", readOnly: "readOnly" }, outputs: { action: "action", onchange: "onchange", onblur: "onblur" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <input #element
    [style]="{fontFamily:model.options.toolbar.fontFamily, height: height, lineHeight: height, boxSizing:'content-box'}"
    [style.color]="color ? color : (model.options.toolbar.fontColor != '' ? model.options.toolbar.fontColor : '')"
    [style.width]="width != null ? width + 'px' : ''"
    [style.margin]="margin"
    [style.cursor]="readOnly ? 'default' : ''"
    [style.padding]="paddingInt"
    [style.border]="border"
    [title]="tooltip || ''"
    [class]="className"
    [value]="value || ''"
    [attr.maxLength]="maxLength"
    [attr.type]="type"
    (mouseover)="over=true"
    (mouseleave)="over=false"
    (focused)="focused=true; selected=true"
    (blur)="focused=false; selected=false; onblur.emit($event.target)"
    (keypress)="keypress($event)"
    (keyup)="onchanged($event)"
    (focus)="focus()"/>
    <sti-parameter-checkbox *ngIf="isNullableParam"
      [style]="{left: '6px', top: 'calc(50% - 7px)', position: 'absolute'}"
      [params]="variable"
      [isEnabled]="variable.allowUserValues"
      (action)="nullableAction($event)"
      [paramNull]="true" >
    </sti-parameter-checkbox>
  `, isInline: true, dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextBoxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-text-box',
                    template: `
    <input #element
    [style]="{fontFamily:model.options.toolbar.fontFamily, height: height, lineHeight: height, boxSizing:'content-box'}"
    [style.color]="color ? color : (model.options.toolbar.fontColor != '' ? model.options.toolbar.fontColor : '')"
    [style.width]="width != null ? width + 'px' : ''"
    [style.margin]="margin"
    [style.cursor]="readOnly ? 'default' : ''"
    [style.padding]="paddingInt"
    [style.border]="border"
    [title]="tooltip || ''"
    [class]="className"
    [value]="value || ''"
    [attr.maxLength]="maxLength"
    [attr.type]="type"
    (mouseover)="over=true"
    (mouseleave)="over=false"
    (focused)="focused=true; selected=true"
    (blur)="focused=false; selected=false; onblur.emit($event.target)"
    (keypress)="keypress($event)"
    (keyup)="onchanged($event)"
    (focus)="focus()"/>
    <sti-parameter-checkbox *ngIf="isNullableParam"
      [style]="{left: '6px', top: 'calc(50% - 7px)', position: 'absolute'}"
      [params]="variable"
      [isEnabled]="variable.allowUserValues"
      (action)="nullableAction($event)"
      [paramNull]="true" >
    </sti-parameter-checkbox>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], width: [{
                type: Input
            }], actionLostFocus: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], enabled: [{
                type: Input
            }], value: [{
                type: Input
            }], margin: [{
                type: Input
            }], focusOnCreate: [{
                type: Input
            }], maxLength: [{
                type: Input
            }], color: [{
                type: Input
            }], type: [{
                type: Input
            }], padding: [{
                type: Input
            }], border: [{
                type: Input
            }], variable: [{
                type: Input
            }], action: [{
                type: Output
            }], onchange: [{
                type: Output
            }], onblur: [{
                type: Output
            }], readOnly: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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