import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
export class TextAreaComponent {
    constructor() {
        this.enabled = true;
        this.action = new EventEmitter();
        this.onchange = new EventEmitter();
        this.onblur = new EventEmitter();
        this.selected = false;
        this.focused = false;
        this.over = false;
        this._readOnly = false;
        this.styleName = 'stiJsViewerTextBox';
    }
    ngOnInit() { }
    keypress(event) {
        if (!this.enabled) {
            return false;
        }
        if (event.keyCode === 13) {
            this.action.emit(event.target);
        }
    }
    onchanged(event) {
        this.onchange.emit(event.target);
    }
    get className() {
        if (this._readOnly) {
            return this.styleName + ' ' + this.styleName + 'Default';
        }
        return this.styleName + ' ' + this.styleName + (this.selected ? 'Over' : (this.enabled ? (this.over ? 'Over' : 'Default') : 'Disabled'));
    }
    get readOnly() {
        return this._readOnly;
    }
}
TextAreaComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextAreaComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
TextAreaComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: TextAreaComponent, selector: "sti-text-area", inputs: { width: "width", height: "height", enabled: "enabled", value: "value", padding: "padding", margin: "margin" }, outputs: { action: "action", onchange: "onchange", onblur: "onblur" }, ngImport: i0, template: `
    <textarea
      [style.width.px]="width"
      [style.minWidth.px]="width"
      [style.height.px]="height"
      [style.minHeight.px]="height"
      [class]="className"
      [value]="value || ''"
      [style.margin]="margin"
      [style.cursor]="readOnly ? 'default' : ''"
      [style.padding]="padding"
      style="padding-top: 3px, font-family: Arial"
      (mouseover)="over=true"
      (mouseleave)="over=false"
      (focused)="focused=true; selected=true"
      (blur)="focused=false; selected=false; onblur.emit($event.target)"
      (keypress)="keypress($event)"
      (keyup)="onchanged($event)">
    </textarea>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: TextAreaComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-text-area',
                    template: `
    <textarea
      [style.width.px]="width"
      [style.minWidth.px]="width"
      [style.height.px]="height"
      [style.minHeight.px]="height"
      [class]="className"
      [value]="value || ''"
      [style.margin]="margin"
      [style.cursor]="readOnly ? 'default' : ''"
      [style.padding]="padding"
      style="padding-top: 3px, font-family: Arial"
      (mouseover)="over=true"
      (mouseleave)="over=false"
      (focused)="focused=true; selected=true"
      (blur)="focused=false; selected=false; onblur.emit($event.target)"
      (keypress)="keypress($event)"
      (keyup)="onchanged($event)">
    </textarea>
  `
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { width: [{
                type: Input
            }], height: [{
                type: Input
            }], enabled: [{
                type: Input
            }], value: [{
                type: Input
            }], padding: [{
                type: Input
            }], margin: [{
                type: Input
            }], action: [{
                type: Output
            }], onchange: [{
                type: Output
            }], onblur: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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