import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/radio-button.service";
import * as i3 from "@angular/common";
export class RadioButtonComponent {
    constructor(model, radioService) {
        this.model = model;
        this.radioService = radioService;
        this.action = new EventEmitter();
        this.enabled = true;
        this.checked = false;
        this.over = false;
    }
    ngAfterViewInit() {
        this.radioService.addButton(this);
    }
    ngOnDestroy() {
        this.radioService.removeButton(this);
    }
    ngOnInit() { }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
    }
    click() {
        if (this.enabled) {
            this.checked = true;
            this.radioService.check(this);
            this.action.emit(true);
        }
    }
    uncheck() {
        this.checked = false;
        this.action.emit(false);
    }
    get outClass() {
        return !this.enabled ? 'stiJsViewerRadioButtonOutCircleDisabled' : (this.over ? 'stiJsViewerRadioButtonOutCircleOver' : 'stiJsViewerRadioButtonOutCircle');
    }
}
RadioButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: RadioButtonComponent, deps: [{ token: i1.ModelService }, { token: i2.RadioButtonService }], target: i0.ɵɵFactoryTarget.Component });
RadioButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: RadioButtonComponent, selector: "sti-radio-button", inputs: { groupName: "groupName", name: "name", enabled: "enabled", checked: "checked", tooltip: "tooltip", caption: "caption", margin: "margin", paddingLeftLastCell: "paddingLeftLastCell" }, outputs: { action: "action" }, ngImport: i0, template: `
    <table [class]="enabled ? 'stiJsViewerRadioButton' : 'stiJsViewerRadioButtonDisabled'" cellpadding="0" cellspacing="0"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.margin]="margin"
      [attr.title]="tooltip"
      (mouseover)="mouseover()" (mouseout)="mouseout()" (click)="click()">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td class="stiJsViewerClearAllStyles">
            <div class="stiJsViewerRadioButtonOutCircle" [class]="outClass">
              <div class="stiJsViewerRadioButtonInnerCircle"
                  [style.margin]="model.options.isTouchDevice ? '4px' : '3px'"
                  [style.width]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.height]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.visibility]="checked ? 'visible' : 'hidden'"
                  [style.opacity]="enabled ? 1 : 0.5">
              </div>
            </div>
          </td>
          <td *ngIf="caption != null" class="stiJsViewerClearAllStyles" style="padding-left: 4px; white-space: nowrap;">
            {{caption}}
          </td>
          <td class="stiJsViewerClearAllStyles" [style.paddingLeft]="paddingLeftLastCell">
            <ng-content></ng-content>
          </td>
        </tr>
      </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: RadioButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-radio-button',
                    template: `
    <table [class]="enabled ? 'stiJsViewerRadioButton' : 'stiJsViewerRadioButtonDisabled'" cellpadding="0" cellspacing="0"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.margin]="margin"
      [attr.title]="tooltip"
      (mouseover)="mouseover()" (mouseout)="mouseout()" (click)="click()">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td class="stiJsViewerClearAllStyles">
            <div class="stiJsViewerRadioButtonOutCircle" [class]="outClass">
              <div class="stiJsViewerRadioButtonInnerCircle"
                  [style.margin]="model.options.isTouchDevice ? '4px' : '3px'"
                  [style.width]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.height]="model.options.isTouchDevice ? '9px' : '7px'"
                  [style.visibility]="checked ? 'visible' : 'hidden'"
                  [style.opacity]="enabled ? 1 : 0.5">
              </div>
            </div>
          </td>
          <td *ngIf="caption != null" class="stiJsViewerClearAllStyles" style="padding-left: 4px; white-space: nowrap;">
            {{caption}}
          </td>
          <td class="stiJsViewerClearAllStyles" [style.paddingLeft]="paddingLeftLastCell">
            <ng-content></ng-content>
          </td>
        </tr>
      </tbody>
    </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.RadioButtonService }]; }, propDecorators: { action: [{
                type: Output
            }], groupName: [{
                type: Input
            }], name: [{
                type: Input
            }], enabled: [{
                type: Input
            }], checked: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], caption: [{
                type: Input
            }], margin: [{
                type: Input
            }], paddingLeftLastCell: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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