import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/helper.service";
import * as i3 from "../../menu/menu.service";
import * as i4 from "../../services/interactions.service";
import * as i5 from "@angular/common";
import * as i6 from "./parameter-text-box.component";
import * as i7 from "./parameter-checkbox.component";
import * as i8 from "./parameter-button.component";
export class ParameterComponent {
    constructor(model, helper, menuService, intearctionService) {
        this.model = model;
        this.helper = helper;
        this.menuService = menuService;
        this.intearctionService = intearctionService;
    }
    ngOnInit() { }
    get params() {
        return this._params;
    }
    set params(params) {
        this._params = params;
        if (params.basicType === 'Range') {
            if (params.type === 'DateTime' && params.keyTo && params.keyTo.isNull) {
                params.keyTo = this.helper.getDateTimeObject(new Date());
            }
        }
    }
    get showParameterInTwoRows() {
        return this.params.basicType === 'Range' && this.model.options.appearance.parametersPanelPosition === 'Left';
    }
    getReadOnlyCheckbox() {
        return this.params.basicType === 'List' || !this.params.allowUserValues;
    }
    getFirstTextBoxValue() {
        let value = '';
        if (this.params.basicType === 'Value' || this.params.basicType === 'NullableValue') {
            if (this.params.type === 'DateTime' && this.params.value === null) {
                this.params.value = new Date();
                this.params.key = this.helper.getDateTimeObject(this.params.value);
            }
            value = (this.params.type === 'DateTime') ? this.helper.getStringKey(this.params.key, this.params) : (this.params.allowUserValues ? this.params.key :
                (this.params.value != "" || !this.params.isChanged ? this.params.value : this.params.key));
        }
        // Range
        if (this.params.basicType === 'Range') {
            if (this.params.type === 'DateTime' && this.params.key && this.params.key.isNull) {
                this.params.key = this.helper.getDateTimeObject(new Date());
            }
            value = this.helper.getStringKey(this.params.key, this.params);
        }
        // List
        if (this.params.basicType === 'List' && this.params.items) {
            this.params.items.forEach((item) => {
                if (item.isChecked) {
                    if (value !== '') {
                        value += (this.model.options.listSeparator ? this.model.options.listSeparator + " " : "; ");
                    }
                    if (this.params.allowUserValues) {
                        value += this.helper.getStringKey(item.key, this.params);
                    }
                    else {
                        value += item.value !== '' ? item.value : this.helper.getStringKey(item.key, this.params);
                    }
                }
            });
        }
        return value != null ? value.toString() : value;
    }
    firstGuidAction() {
        if (this.params.basicType === 'Range') {
            this.params.key = this.helper.newGuid();
        }
        else {
            this.params.key = this.params.value = this.helper.newGuid();
        }
    }
    doubleDateTimeAction(event) {
        this.menuService.addMenu({
            type: 'doubleDatePickerMenu', name: 'doubleDatePickerMenu', items: [], parent: this.rangeFrom,
            params: this.params,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('doubleDatePickerMenu');
        });
    }
    firstDateTimeAction(event) {
        this.menuService.addMenu({
            type: 'datePickerMenu', name: 'datePickerMenu', items: [], parent: this.firstDateTimeButton,
            params: this.params,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu('datePickerMenu');
        });
    }
    dropDownButtonAction(event) {
        let menuType = 'parameterMenuForValue';
        switch (this.params.basicType) {
            case 'Range':
                menuType = 'parameterMenuForRange';
                break;
            case 'List':
                menuType = this.params.allowUserValues ? 'parameterMenuForEditList' : 'parameterMenuForNotEditList';
                break;
        }
        if (this.params.items) {
            this.params.items.forEach(i => i.visible = true);
        }
        let this_ = this;
        this.menuService.addMenu({
            type: menuType, name: 'parameterMenu', items: [], parent: this.element,
            params: this.params,
            state: '',
            onCloseEvent: () => {
                this_.onCloseMenuEvent();
            }
        });
        setTimeout(() => {
            this.menuService.showMenu('parameterMenu');
        });
    }
    onCloseMenuEvent() {
        if (this.params.binding) {
            if (!this.model.options.paramsVariablesStartValues) {
                this.model.options.paramsVariablesStartValues = this.helper.copyObject(this.model.options.paramsVariables);
            }
            this.intearctionService.postInteraction({ action: 'InitVars', variables: this.intearctionService.getParametersValues(), isBindingVariable: true });
        }
    }
}
ParameterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.MenuService }, { token: i4.InteractionsService }], target: i0.ɵɵFactoryTarget.Component });
ParameterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterComponent, selector: "sti-parameter", inputs: { params: "params" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "firstDateTimeButton", first: true, predicate: ["firstDateTimeButton"], descendants: true }, { propertyName: "doubleDateTimeButton", first: true, predicate: ["doubleDateTimeButton"], descendants: true }, { propertyName: "rangeFrom", first: true, predicate: ["rangeFrom"], descendants: true }], ngImport: i0, template: `
    <table #element class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" #rangeFrom>
       <tbody>
          <tr class="stiJsViewerClearAllStyles" >
            <td *ngIf="params.type == 'Bool' && (params.basicType == 'Value' || params.basicType == 'NullableValue')"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-checkbox [params]="params" [isEnabled]="params.allowUserValues" (action)="params.value = $event" [nullable]="params.basicType == 'NullableValue'">
                </sti-parameter-checkbox>
            </td>

            <td *ngIf="params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'"  style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                {{model.loc('RangeFrom')}}
            </td>

            <td *ngIf="params.type != 'Bool' || params.basicType == 'List'"
                [style.position]="(params.basicType == 'NullableValue' || params.allowNullableString) && params.allowUserValues ? 'relative' : ''"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-text-box [variable]="params"
                    [readOnly]="getReadOnlyCheckbox()"
                    [value]="getFirstTextBoxValue()">
                </sti-parameter-text-box>
            </td>

            <td *ngIf="params.type == 'DateTime' && params.allowUserValues && params.basicType != 'List' && params.basicType != 'Range'"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight" #firstDateTimeButton>
                <sti-parameter-button [buttonType]="'DateTimeButton'" [params]="params"  (action)="firstDateTimeAction($event)">
                </sti-parameter-button>
            </td>

            <td *ngIf="params.type == 'Guid' && params.allowUserValues && params.basicType != 'List'"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="firstGuidAction()">
                </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>

          <!-- NEW LINE -->
          <tr *ngIf="showParameterInTwoRows">
            <td *ngIf="params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="params.basicType == 'Range'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>
       </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: ["item", "variable", "readOnly", "focusOnCreate", "isMenu", "value", "secondTextBox"] }, { kind: "component", type: i7.ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: ["params", "captionText", "margin", "width", "imageBlockParentWidth", "isEnabled", "isMenuParameter", "paramNull", "nullable"], outputs: ["action"] }, { kind: "component", type: i8.ParameterButtonComponent, selector: "sti-parameter-button", inputs: ["params", "buttonType"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter',
                    template: `
    <table #element class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" #rangeFrom>
       <tbody>
          <tr class="stiJsViewerClearAllStyles" >
            <td *ngIf="params.type == 'Bool' && (params.basicType == 'Value' || params.basicType == 'NullableValue')"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-checkbox [params]="params" [isEnabled]="params.allowUserValues" (action)="params.value = $event" [nullable]="params.basicType == 'NullableValue'">
                </sti-parameter-checkbox>
            </td>

            <td *ngIf="params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'"  style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                {{model.loc('RangeFrom')}}
            </td>

            <td *ngIf="params.type != 'Bool' || params.basicType == 'List'"
                [style.position]="(params.basicType == 'NullableValue' || params.allowNullableString) && params.allowUserValues ? 'relative' : ''"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-text-box [variable]="params"
                    [readOnly]="getReadOnlyCheckbox()"
                    [value]="getFirstTextBoxValue()">
                </sti-parameter-text-box>
            </td>

            <td *ngIf="params.type == 'DateTime' && params.allowUserValues && params.basicType != 'List' && params.basicType != 'Range'"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight" #firstDateTimeButton>
                <sti-parameter-button [buttonType]="'DateTimeButton'" [params]="params"  (action)="firstDateTimeAction($event)">
                </sti-parameter-button>
            </td>

            <td *ngIf="params.type == 'Guid' && params.allowUserValues && params.basicType != 'List'"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
                <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="firstGuidAction()">
                </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="!showParameterInTwoRows && params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>

          <!-- NEW LINE -->
          <tr *ngIf="showParameterInTwoRows">
            <td *ngIf="params.basicType == 'Range' && model.options.appearance.parametersPanelPosition === 'Top'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              {{model.loc('RangeTo')}}
            </td>

            <!-- second -->
            <td *ngIf="params.basicType == 'Range'" style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-text-box [variable]="params"
                    [readOnly]="!params.allowUserValues"
                    [value]="helper.getStringKey(params.keyTo, params)"
                    [secondTextBox]="true">
              </sti-parameter-text-box>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'DateTime' && params.allowUserValues" #doubleDateTimeButton
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'DateTimeButton'" [params]="params" (action)="doubleDateTimeAction($event)">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.basicType == 'Range' && params.type == 'Guid' && params.allowUserValues"
              style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button  [buttonType]="'GuidButton'" [params]="params" (action)="params.keyTo=helper.newGuid()">
              </sti-parameter-button>
            </td>

            <td *ngIf="params.items != null || (params.basicType == 'List' && params.allowUserValues)"
                style="padding: 0px 2px;" [style.height.px]="model.options.parameterRowHeight">
              <sti-parameter-button [buttonType]="'DropDownButton'" [params]="params" (action)="dropDownButtonAction($event)">
              </sti-parameter-button>
            </td>
          </tr>
       </tbody>
    </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.MenuService }, { type: i4.InteractionsService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], firstDateTimeButton: [{
                type: ViewChild,
                args: ['firstDateTimeButton']
            }], doubleDateTimeButton: [{
                type: ViewChild,
                args: ['doubleDateTimeButton']
            }], rangeFrom: [{
                type: ViewChild,
                args: ['rangeFrom']
            }], params: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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