import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../services/helper.service";
import * as i2 from "../../services/model.service";
import * as i3 from "../text-box.componet";
export class ParameterTextBoxComponent {
    constructor(helper, model) {
        this.helper = helper;
        this.model = model;
        this.focusOnCreate = false;
        this.isMenu = false;
        this.value = '';
        this.secondTextBox = false;
    }
    ngOnInit() { }
    onchange(target) {
        if (this.element.oldValue === target.value) {
            return;
        }
        const value = this.getValue(target);
        if (this.isMenu) {
            if (!this.secondTextBox) {
                this.item.key = value;
            }
            else {
                this.item.keyTo = value;
            }
        }
        else {
            if (!this.secondTextBox) {
                if (this.variable.basicType === 'Range' || this.variable.type === 'DateTime') {
                    this.variable.key = value;
                }
                else {
                    this.variable.value = value;
                    if (this.variable.basicType === 'Value') {
                        this.variable.key = value;
                    }
                }
            }
            else {
                this.variable.keyTo = value;
            }
        }
    }
    getValue(target) {
        if (this.variable.type === 'DateTime') {
            if (this.element.oldValue === target.value) {
                return;
            }
            try {
                const timeString = new Date().toLocaleTimeString();
                const isAmericanFormat = timeString.toLowerCase().indexOf('am') >= 0 || timeString.toLowerCase().indexOf('pm') >= 0;
                const formatDate = isAmericanFormat ? 'MM/dd/yyyy' : 'dd.MM.yyyy';
                let format = formatDate + (isAmericanFormat ? ' h:mm:ss tt' : ' hh:mm:ss');
                if (this.variable.dateTimeType === 'Date') {
                    format = formatDate;
                }
                if (this.variable.dateTimeType === 'Time') {
                    format = 'hh:mm:ss';
                }
                const date = this.helper.getDateTimeFromString(target.value, this.model.options.appearance.parametersPanelDateFormat || format);
                return this.helper.getDateTimeObject(date);
            }
            catch (e) {
                alert(e);
            }
        }
        else {
            return target.value;
        }
    }
    get width() {
        let width = 210;
        if (this.variable.basicType === 'Range') {
            width = 140;
            if (this.variable.type === 'Guid' || this.variable.type === 'String') {
                width = 190;
            }
            if (this.variable.type === 'DateTime') {
                width = 235;
            }
            if (this.variable.type === 'Char') {
                width = 60;
            }
        }
        else {
            if (this.variable.type === 'Guid') {
                width = 265;
            }
            else {
                width = 210;
            }
        }
        return width;
    }
    get color() {
        return !this.variable.isNull
            ? (this.model.options.toolbar.fontColor && this.model.options.toolbar.fontColor !== 'Empty' ? this.model.options.toolbar.fontColor : '#444444')
            : this.variable.type === 'DateTime' ? 'transparent' : '#c6c6c6';
    }
}
ParameterTextBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterTextBoxComponent, deps: [{ token: i1.HelperService }, { token: i2.ModelService }], target: i0.ɵɵFactoryTarget.Component });
ParameterTextBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterTextBoxComponent, selector: "sti-parameter-text-box", inputs: { item: "item", variable: "variable", readOnly: "readOnly", focusOnCreate: "focusOnCreate", isMenu: "isMenu", value: "value", secondTextBox: "secondTextBox" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <sti-text-box #element
      [maxLength]="variable.type === 'Char' ? 1 : ''"
      [value]="isMenu ? helper.getStringKey(item.key, variable): value"
      [width]="width"
      [readOnly]="readOnly"
      [focusOnCreate]="focusOnCreate"
      [enabled]="!variable?.isNull"
      [color]="color"
      [variable]="variable"
      (onblur)="onchange($event)">
    </sti-text-box>
  `, isInline: true, dependencies: [{ kind: "component", type: i3.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterTextBoxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-text-box',
                    template: `
    <sti-text-box #element
      [maxLength]="variable.type === 'Char' ? 1 : ''"
      [value]="isMenu ? helper.getStringKey(item.key, variable): value"
      [width]="width"
      [readOnly]="readOnly"
      [focusOnCreate]="focusOnCreate"
      [enabled]="!variable?.isNull"
      [color]="color"
      [variable]="variable"
      (onblur)="onchange($event)">
    </sti-text-box>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.HelperService }, { type: i2.ModelService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], item: [{
                type: Input
            }], variable: [{
                type: Input
            }], readOnly: [{
                type: Input
            }], focusOnCreate: [{
                type: Input
            }], isMenu: [{
                type: Input
            }], value: [{
                type: Input
            }], secondTextBox: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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