import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../services/model.service";
import * as i2 from "../../services/helper.service";
import * as i3 from "../text-box.componet";
import * as i4 from "../text-block.component";
export class ParameterFindComponent {
    constructor(model, helper) {
        this.model = model;
        this.helper = helper;
    }
    ngOnInit() { }
    onchange(event) {
        const text = event.value.toLowerCase();
        this.variable.items.forEach((item) => {
            const itemText = this.helper.val(item.value, this.helper.getStringKey(item.key, this.variable)).toLowerCase();
            item.visible = itemText.indexOf(text) >= 0;
        });
    }
}
ParameterFindComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterFindComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }], target: i0.ɵɵFactoryTarget.Component });
ParameterFindComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterFindComponent, selector: "sti-parameter-find", inputs: { variable: "variable" }, ngImport: i0, template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding-left: 8px;">
                <sti-text-block [text]="model.loc('FindWhat')"></sti-text-block>
              </td>

              <td class="stiJsViewerClearAllStyles" style="padding-left: 8px;">
                <sti-text-box [width]="80"
                  [margin]="'4px'"
                  [focusOnCreate]="true"
                  (onchange)="onchange($event)">
                </sti-text-box>
              </td>
            </tr>
          </tbody>
      </table>

  `, isInline: true, dependencies: [{ kind: "component", type: i3.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i4.TextBlockComponent, selector: "sti-text-block", inputs: ["text", "margin"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterFindComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-find',
                    template: `
      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="padding-left: 8px;">
                <sti-text-block [text]="model.loc('FindWhat')"></sti-text-block>
              </td>

              <td class="stiJsViewerClearAllStyles" style="padding-left: 8px;">
                <sti-text-box [width]="80"
                  [margin]="'4px'"
                  [focusOnCreate]="true"
                  (onchange)="onchange($event)">
                </sti-text-box>
              </td>
            </tr>
          </tbody>
      </table>

  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }]; }, propDecorators: { variable: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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