import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../checkbox.component";
export class ParameterCheckboxComponent {
    constructor() {
        this.isEnabled = true;
        this.isMenuParameter = false;
        this.paramNull = false;
        this.nullable = false;
        this.action = new EventEmitter();
    }
    ngOnInit() { }
    onAction(checked) {
        this.action.emit(checked);
    }
    get checked() {
        if (this.paramNull) {
            return this.params.isNull;
        }
        else {
            return this.isMenuParameter ? this.params.isChecked : (typeof (this.params.value) === 'boolean' && this.params.value) || this.params.value === 'true' || this.params.value === 'True';
        }
    }
}
ParameterCheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterCheckboxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
ParameterCheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ParameterCheckboxComponent, selector: "sti-parameter-checkbox", inputs: { params: "params", captionText: "captionText", margin: "margin", width: "width", imageBlockParentWidth: "imageBlockParentWidth", isEnabled: "isEnabled", isMenuParameter: "isMenuParameter", paramNull: "paramNull", nullable: "nullable" }, outputs: { action: "action" }, ngImport: i0, template: `
    <sti-check-box [isEnabled]="isEnabled"
                   [isChecked]="checked"
                   [nullable]="nullable"
                   [captionText]="captionText"
                   [margin]="margin"
                   [width]="width"
                   [imageBlockParentWidth]="imageBlockParentWidth"
                   (action)="onAction($event)">
    </sti-check-box>
    `, isInline: true, dependencies: [{ kind: "component", type: i1.CheckboxComponent, selector: "sti-check-box", inputs: ["isEnabled", "isChecked", "indeterminate", "captionText", "tooltip", "margin", "width", "styleColors", "imageBlockParentWidth", "nullable"], outputs: ["action"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ParameterCheckboxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-parameter-checkbox',
                    template: `
    <sti-check-box [isEnabled]="isEnabled"
                   [isChecked]="checked"
                   [nullable]="nullable"
                   [captionText]="captionText"
                   [margin]="margin"
                   [width]="width"
                   [imageBlockParentWidth]="imageBlockParentWidth"
                   (action)="onAction($event)">
    </sti-check-box>
    `
                }]
        }], ctorParameters: function () { return []; }, propDecorators: { params: [{
                type: Input
            }], captionText: [{
                type: Input
            }], margin: [{
                type: Input
            }], width: [{
                type: Input
            }], imageBlockParentWidth: [{
                type: Input
            }], isEnabled: [{
                type: Input
            }], isMenuParameter: [{
                type: Input
            }], paramNull: [{
                type: Input
            }], nullable: [{
                type: Input
            }], action: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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