import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/mouse.service";
import * as i3 from "../menu/menu.service";
import * as i4 from "./button.component";
export class DropDownListComponent {
    constructor(model, mouseService, menuService) {
        this.model = model;
        this.mouseService = mouseService;
        this.menuService = menuService;
        this.showImage = false;
        this.action = new EventEmitter();
        this.over = false;
        this._readOnly = false;
        this._enabled = true;
        this.mouseService.getDocumentMouseUp().subscribe(() => {
            this.hideListMenu();
        });
    }
    ngOnInit() { }
    set readOnly(value) {
        this._readOnly = value;
        setTimeout(() => {
            try {
                this.input.nativeElement.setAttribute('unselectable', value ? 'on' : 'off');
                this.input.nativeElement.setAttribute('onselectstart', value ? 'return false' : '');
                this.input.nativeElement.readOnly = value;
            }
            catch (e) { }
        });
    }
    get readOnly() {
        return this._readOnly;
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    get key() {
        return this._key;
    }
    set key(key) {
        if (this.items != null) {
            this.items.forEach(i => i.selected = i.key === key);
        }
        this._key = key;
    }
    get inputValue() {
        if (this.items != null) {
            return this.items.find(i => i.key === this._key)?.caption || '';
        }
        return '';
    }
    get selected() {
        const vm = this.menuService.getVerticalMenu();
        return vm?.state === 'expanded' && vm?.parent === this.element;
    }
    get className() {
        return this.selected ? 'stiJsViewerDropDownListOver' : (this.enabled ? (this.over ? 'stiJsViewerDropDownListOver' : 'stiJsViewerDropDownList') : 'stiJsViewerDropDownListDisabled');
    }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
    }
    inputClick() {
        if (this.readOnly) {
            this.showListMenu();
        }
    }
    showListMenu() {
        this.menuService.addMenu({
            type: this.menuService.VERTICAL_MENU_NAME, name: this.menuService.VERTICAL_MENU_NAME, items: [], parent: this.element,
            verticalItems: this.items, itemStyleName: 'stiJsViewerMenuStandartItem', menuStyleName: 'stiJsViewerDropdownMenu',
            action: this.action, width: this.element.nativeElement.offsetWidth,
            state: ''
        });
        setTimeout(() => {
            this.menuService.showMenu(this.menuService.VERTICAL_MENU_NAME);
        });
    }
    hideListMenu() {
        if (this.menuService.getVerticalMenu()) {
            this.menuService.getVerticalMenu().state = 'initialDown';
        }
    }
}
DropDownListComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DropDownListComponent, deps: [{ token: i1.ModelService }, { token: i2.MouseService }, { token: i3.MenuService }], target: i0.ɵɵFactoryTarget.Component });
DropDownListComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DropDownListComponent, selector: "sti-drop-down-list", inputs: { toolTip: "toolTip", showImage: "showImage", width: "width", margin: "margin", items: "items", styleDisplay: "styleDisplay", verticalAlign: "verticalAlign", readOnly: "readOnly", enabled: "enabled", key: "key" }, outputs: { action: "action" }, viewQueries: [{ propertyName: "input", first: true, predicate: ["input"], descendants: true }, { propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
        <table #element [class]="className" cellpadding="0" cellspacing="0"
              [style.fontFamily]="model.options.toolbar.fontFamily"
              [style.color]="model.options.toolbar.fontColor"
              [style.margin]="margin"
              [style.verticalAlign]="verticalAlign"
              [style.display]="styleDisplay"
              [attr.title]="toolTip"
              (mouseover)="mouseover()"
              (mouseout)="mouseout()">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <input #input
                [style.width.px]="width - (model.options.isTouchDevice ? 23 : 15) - (showImage ? 38 : 0)"
                [style.border]="0"
                [style.cursor]="readOnly ? 'default' : 'text'"
                [style.fontFamily]="model.options.toolbar.fontFamily"
                [style.color]="model.options.toolbar.fontColor"
                [style.height]="model.options.isTouchDevice ? '23px' : '18px'"
                [style.lineHeight]="model.options.isTouchDevice ? '23px' : '18px'"
                [style.visibility]="enabled ? 'visible' : 'hidden'"
                [value]="inputValue"
                (click)="inputClick()"
                class="stiJsViewerDropDownList_TextBox">
              </td>

              <td class="stiJsViewerClearAllStyles">
                  <sti-button [imageName]="'Arrows.' + (model.options.isTouchDevice ? 'Big' : 'Small') + 'ArrowDown.png'"
                     [styleName]="'stiJsViewerDropDownListButton'"
                     [imageSizesWidth]="model.options.isTouchDevice ? 16 : 8"
                     [imageSizesHeight]="model.options.isTouchDevice ? 16 : 8"
                     [height]="model.options.isTouchDevice ? '26px' : '21px'"
                     [enabled]="enabled"
                     [selected]="selected"
                     [margin]="'0'"
                     (action)="showListMenu()">
                  </sti-button>
              </td>
            </tr>
          </tbody>
        </table>

  `, isInline: true, dependencies: [{ kind: "component", type: i4.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DropDownListComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-drop-down-list',
                    template: `
        <table #element [class]="className" cellpadding="0" cellspacing="0"
              [style.fontFamily]="model.options.toolbar.fontFamily"
              [style.color]="model.options.toolbar.fontColor"
              [style.margin]="margin"
              [style.verticalAlign]="verticalAlign"
              [style.display]="styleDisplay"
              [attr.title]="toolTip"
              (mouseover)="mouseover()"
              (mouseout)="mouseout()">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles">
                <input #input
                [style.width.px]="width - (model.options.isTouchDevice ? 23 : 15) - (showImage ? 38 : 0)"
                [style.border]="0"
                [style.cursor]="readOnly ? 'default' : 'text'"
                [style.fontFamily]="model.options.toolbar.fontFamily"
                [style.color]="model.options.toolbar.fontColor"
                [style.height]="model.options.isTouchDevice ? '23px' : '18px'"
                [style.lineHeight]="model.options.isTouchDevice ? '23px' : '18px'"
                [style.visibility]="enabled ? 'visible' : 'hidden'"
                [value]="inputValue"
                (click)="inputClick()"
                class="stiJsViewerDropDownList_TextBox">
              </td>

              <td class="stiJsViewerClearAllStyles">
                  <sti-button [imageName]="'Arrows.' + (model.options.isTouchDevice ? 'Big' : 'Small') + 'ArrowDown.png'"
                     [styleName]="'stiJsViewerDropDownListButton'"
                     [imageSizesWidth]="model.options.isTouchDevice ? 16 : 8"
                     [imageSizesHeight]="model.options.isTouchDevice ? 16 : 8"
                     [height]="model.options.isTouchDevice ? '26px' : '21px'"
                     [enabled]="enabled"
                     [selected]="selected"
                     [margin]="'0'"
                     (action)="showListMenu()">
                  </sti-button>
              </td>
            </tr>
          </tbody>
        </table>

  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.MouseService }, { type: i3.MenuService }]; }, propDecorators: { input: [{
                type: ViewChild,
                args: ['input']
            }], element: [{
                type: ViewChild,
                args: ['element']
            }], toolTip: [{
                type: Input
            }], showImage: [{
                type: Input
            }], width: [{
                type: Input
            }], margin: [{
                type: Input
            }], items: [{
                type: Input
            }], styleDisplay: [{
                type: Input
            }], verticalAlign: [{
                type: Input
            }], action: [{
                type: Output
            }], readOnly: [{
                type: Input
            }], enabled: [{
                type: Input
            }], key: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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