import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "../menu/menu.service";
import * as i4 from "./button.component";
export class DatePickerDayButtonComponent {
    constructor(model, helper, menuService) {
        this.model = model;
        this.helper = helper;
        this.menuService = menuService;
        this.caption = '';
        this.enabled = false;
        this.selected = false;
        this.closeOnAction = true;
    }
    action() {
        this.date.day = this.row * 7 + this.col - this.getFirstDay() + 1;
        if (this.closeOnAction && this.menuService.getMenu('datePickerMenu') != null) {
            this.menuService.getMenu('datePickerMenu').state = 'initialUp';
        }
    }
    getFirstDay() {
        let firstDay = new Date(this.date.year, this.date.month - 1, 1).getDay();
        if (firstDay === 0) {
            firstDay = 7;
        }
        if (this.model.options.appearance.datePickerFirstDayOfWeek !== 'Sunday') {
            firstDay--;
        }
        return firstDay;
    }
    ngOnInit() { }
}
DatePickerDayButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DatePickerDayButtonComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.MenuService }], target: i0.ɵɵFactoryTarget.Component });
DatePickerDayButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DatePickerDayButtonComponent, selector: "sti-date-picker-day-button", inputs: { col: "col", row: "row", caption: "caption", enabled: "enabled", selected: "selected", date: "date", closeOnAction: "closeOnAction" }, ngImport: i0, template: `
    <sti-button [styleName]="'stiJsViewerDatePickerDayButton'"
                [width]="model.options.isTouchDevice ? '25px' : '23px'"
                [height]="model.options.isTouchDevice ? '25px' : '23px'"
                [captionAlign]="'center'"
                [innerTableWidth]="'100%'"
                [captionPadding]="'0px'"
                [margin]="'1px'"
                [caption]="caption"
                [enabled]="enabled"
                [selected]="selected"
                (action)="action()">
    </sti-button>
  `, isInline: true, dependencies: [{ kind: "component", type: i4.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DatePickerDayButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-date-picker-day-button',
                    template: `
    <sti-button [styleName]="'stiJsViewerDatePickerDayButton'"
                [width]="model.options.isTouchDevice ? '25px' : '23px'"
                [height]="model.options.isTouchDevice ? '25px' : '23px'"
                [captionAlign]="'center'"
                [innerTableWidth]="'100%'"
                [captionPadding]="'0px'"
                [margin]="'1px'"
                [caption]="caption"
                [enabled]="enabled"
                [selected]="selected"
                (action)="action()">
    </sti-button>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.MenuService }]; }, propDecorators: { col: [{
                type: Input
            }], row: [{
                type: Input
            }], caption: [{
                type: Input
            }], enabled: [{
                type: Input
            }], selected: [{
                type: Input
            }], date: [{
                type: Input
            }], closeOnAction: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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