import { Component, Input, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "@angular/common";
export class CheckboxComponent {
    constructor(model) {
        this.model = model;
        this.isEnabled = true;
        this.isChecked = false;
        this.indeterminate = false;
        this.nullable = false;
        this.action = new EventEmitter();
        this.over = false;
        this.isNull = false;
    }
    ngOnInit() { }
    mouseover() {
        this.over = true;
    }
    mouseleave() {
        this.over = false;
    }
    click() {
        if (this.isEnabled) {
            this.isChecked = !this.isChecked || this.isNull;
            this.isNull = this.nullable && this.isChecked && !this.isNull;
            this.action.emit(this.isNull ? null : this.isChecked);
        }
    }
}
CheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CheckboxComponent, deps: [{ token: i1.ModelService }], target: i0.ɵɵFactoryTarget.Component });
CheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: CheckboxComponent, selector: "sti-check-box", inputs: { isEnabled: "isEnabled", isChecked: "isChecked", indeterminate: "indeterminate", captionText: "captionText", tooltip: "tooltip", margin: "margin", width: "width", styleColors: "styleColors", imageBlockParentWidth: "imageBlockParentWidth", nullable: "nullable" }, outputs: { action: "action" }, ngImport: i0, template: `
    <table cellpadding="0" cellspacing="0"
      [class]="isEnabled ? 'stiJsViewerCheckBox' : 'stiJsViewerCheckBoxDisabled'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [attr.title]="tooltip"
      [style.margin]="margin"
      [style.width]="width"
      style="box-sizing:content-box"
      (mouseover)="mouseover()"
      (mouseleave)="mouseleave()"
      (click)="click()">
       <tbody>
          <tr class="stiJsViewerClearAllStyles">
             <td style="line-height: 0"
                 [style.padding]="model.options.isTouchDevice ? '1px 3px 1px 1px' : ''"
                 [style.width]="imageBlockParentWidth"
                 class="stiJsViewerClearAllStyles">
                <div [style.width.px]="model.options.isTouchDevice ? 16 : 13"
                     [style.height.px]="model.options.isTouchDevice ? 16 : 13"
                     [class]="isEnabled ? (over ? 'stiJsViewerCheckBoxImageBlockOver' : 'stiJsViewerCheckBoxImageBlock') : 'stiJsViewerCheckBoxImageBlockDisabled'"
                     style="box-sizing: content-box">
                     <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%; height: 100%;">
                        <tbody>
                          <tr class="stiJsViewerClearAllStyles">
                            <td [style.textAlign]="model.options.isTouchDevice ? 'center' : 'right'"
                                [style.verticalAlign]="model.options.isTouchDevice ? 'middle' : 'top'"
                                style="position: relative;">
                                <img *ngIf="!isNull" [src]="model.img((indeterminate ? 'CheckBoxIndeterminate' : 'CheckBox') + (styleColors && styleColors.isDarkStyle ? 'White.png' : '.png'))"
                                    [style.visibility]="isChecked ? 'visible' : 'hidden'"
                                    [style.width.px]="indeterminate ? 13 : 12"
                                    [style.height.px]="indeterminate ? 13 : 12"
                                    [style.opacity]="isEnabled ? 1 : 0.5"
                                    style="vertical-align: baseline"/>
                                <div *ngIf="isNull" class="stiJsViewerCheckBoxNullBlock" style="left: 2px; top: 6px; width: 9px; " [style.opacity]="isEnabled ? 1 : 0.5"></div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                </div>
             </td>
             <td *ngIf="captionText != null"
                 [style.padding]="!model.options.isTouchDevice ? '1px 0 0 4px' : ''"
                 style="white-space: nowrap">
                 {{captionText}}
             </td>
          </tr>
       </tbody>
    </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CheckboxComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-check-box',
                    template: `
    <table cellpadding="0" cellspacing="0"
      [class]="isEnabled ? 'stiJsViewerCheckBox' : 'stiJsViewerCheckBoxDisabled'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [attr.title]="tooltip"
      [style.margin]="margin"
      [style.width]="width"
      style="box-sizing:content-box"
      (mouseover)="mouseover()"
      (mouseleave)="mouseleave()"
      (click)="click()">
       <tbody>
          <tr class="stiJsViewerClearAllStyles">
             <td style="line-height: 0"
                 [style.padding]="model.options.isTouchDevice ? '1px 3px 1px 1px' : ''"
                 [style.width]="imageBlockParentWidth"
                 class="stiJsViewerClearAllStyles">
                <div [style.width.px]="model.options.isTouchDevice ? 16 : 13"
                     [style.height.px]="model.options.isTouchDevice ? 16 : 13"
                     [class]="isEnabled ? (over ? 'stiJsViewerCheckBoxImageBlockOver' : 'stiJsViewerCheckBoxImageBlock') : 'stiJsViewerCheckBoxImageBlockDisabled'"
                     style="box-sizing: content-box">
                     <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="width: 100%; height: 100%;">
                        <tbody>
                          <tr class="stiJsViewerClearAllStyles">
                            <td [style.textAlign]="model.options.isTouchDevice ? 'center' : 'right'"
                                [style.verticalAlign]="model.options.isTouchDevice ? 'middle' : 'top'"
                                style="position: relative;">
                                <img *ngIf="!isNull" [src]="model.img((indeterminate ? 'CheckBoxIndeterminate' : 'CheckBox') + (styleColors && styleColors.isDarkStyle ? 'White.png' : '.png'))"
                                    [style.visibility]="isChecked ? 'visible' : 'hidden'"
                                    [style.width.px]="indeterminate ? 13 : 12"
                                    [style.height.px]="indeterminate ? 13 : 12"
                                    [style.opacity]="isEnabled ? 1 : 0.5"
                                    style="vertical-align: baseline"/>
                                <div *ngIf="isNull" class="stiJsViewerCheckBoxNullBlock" style="left: 2px; top: 6px; width: 9px; " [style.opacity]="isEnabled ? 1 : 0.5"></div>
                            </td>
                          </tr>
                        </tbody>
                      </table>
                </div>
             </td>
             <td *ngIf="captionText != null"
                 [style.padding]="!model.options.isTouchDevice ? '1px 0 0 4px' : ''"
                 style="white-space: nowrap">
                 {{captionText}}
             </td>
          </tr>
       </tbody>
    </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }]; }, propDecorators: { isEnabled: [{
                type: Input
            }], isChecked: [{
                type: Input
            }], indeterminate: [{
                type: Input
            }], captionText: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], margin: [{
                type: Input
            }], width: [{
                type: Input
            }], styleColors: [{
                type: Input
            }], imageBlockParentWidth: [{
                type: Input
            }], nullable: [{
                type: Input
            }], action: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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