import { Component, Input, ViewChild, Output, EventEmitter } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../menu/menu.service";
import * as i3 from "../services/tooltip.service";
import * as i4 from "../services/helper.service";
import * as i5 from "@angular/common";
export class ButtonComponent {
    constructor(model, menuService, tooltipService, helper) {
        this.model = model;
        this.menuService = menuService;
        this.tooltipService = tooltipService;
        this.helper = helper;
        this.margin = '1px';
        this.height = '23px';
        this.selected = false;
        this.imageCellTextAlign = 'center';
        this.imageSizesWidth = 16;
        this.imageSizesHeight = 16;
        this.closeButton = false;
        this.resourceButton = false;
        this.navagationPanelTooltip = false;
        this.helpLink = 'user-manual/index.html?viewer_reports.htm';
        this.action = new EventEmitter();
        this.closeButtonAction = new EventEmitter();
        this.over = false;
        this.showMenu = false;
        this.closeButtonPressed = false;
        this.resourceButtonPressed = false;
        this._enabled = true;
        this.canShowTooltip = true;
    }
    ngOnInit() {
        if (this.menuItems) {
            setTimeout(() => {
                this.menuObj = { type: 'buttonMenu', name: this.actionName, items: this.menuItems, parent: !this.resourceButton ? this.button : this.resButtonEl, state: '' };
                this.menuService.addMenu(this.menuObj);
            }, 500);
        }
    }
    get styleName() {
        return this._styleName || 'stiJsViewerStandartSmallButton';
    }
    set styleName(value) {
        this._styleName = value;
    }
    get enabled() {
        return this._enabled;
    }
    set enabled(value) {
        if (!value) {
            this.over = false;
        }
        this._enabled = value;
    }
    mouseover() {
        if (!this.enabled) {
            return;
        }
        this.over = true;
        if (this.model.options.toolbar.showMenuMode === 'Hover' && ['Print', 'Save', 'SendEmail', 'Zoom', 'ViewMode'].some(a => a === this.actionName)) {
            this.tooltipService.hideImmediately();
            this.menuService.showMenu(this.actionName);
        }
        else if (this.tooltip && !this.menuService.menus.some(e => e.state === 'expanded') && this.canShowTooltip) {
            const top = !this.navagationPanelTooltip ? this.model.controls.toolbar.offsetHeight + this.model.controls.dashboardsPanel.offsetHeight :
                this.helper.findPosY(this.model.controls.navigatePanel.el.nativeElement, 'stiJsViewerMainPanel');
            const tooltip = this.tooltip === true ? (this.model.localization[this.actionName + 'ToolTip'] != null ? this.model.loc(this.actionName + 'ToolTip') : this.model.loc(this.actionName)) : this.tooltip;
            this.tooltipService.show(this.helper.findPosX(this.button.nativeElement, 'stiJsViewerMainPanel'), top, tooltip, !this.navagationPanelTooltip, this.helpLink);
        }
    }
    mouseout() {
        if (!this.enabled) {
            return;
        }
        this.over = false;
        this.tooltipService.hide();
        setTimeout(() => {
            this.canShowTooltip = true;
        }, 1000);
    }
    click() {
        if (this.enabled && !this.closeButtonPressed) {
            this.tooltipService.hideImmediately();
            if (this.menuItems == null || (this.resourceButton && !this.resourceButtonPressed)) {
                this.action.emit();
            }
            else {
                this.menuService.showMenu(this.actionName);
            }
        }
        this.canShowTooltip = false;
        this.closeButtonPressed = false;
        this.resourceButtonPressed = false;
    }
    get className() {
        return this.styleName ? this.styleName + ' ' + (this.enabled ? (this.styleName + ((this.selected || this.menuObj?.state === 'expanded') ? 'Selected' : (this.over ? 'Over' : 'Default'))) : this.styleName + 'Disabled') : '';
    }
}
ButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ButtonComponent, deps: [{ token: i1.ModelService }, { token: i2.MenuService }, { token: i3.TooltipService }, { token: i4.HelperService }], target: i0.ɵɵFactoryTarget.Component });
ButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ButtonComponent, selector: "sti-button", inputs: { caption: "caption", caption2: "caption2", captionAlign: "captionAlign", captionPadding: "captionPadding", captionPaddingLeft: "captionPaddingLeft", captionWhiteSpace: "captionWhiteSpace", captionOverflow: "captionOverflow", captionTextOverflow: "captionTextOverflow", captionWidth: "captionWidth", captionMaxWidth: "captionMaxWidth", captionLineHeight: "captionLineHeight", imageName: "imageName", arrow: "arrow", arrowMarginTop: "arrowMarginTop", margin: "margin", height: "height", selected: "selected", minWidth: "minWidth", innerTableWidth: "innerTableWidth", menuItems: "menuItems", actionName: "actionName", tooltip: "tooltip", imageCellTextAlign: "imageCellTextAlign", imageCellWidth: "imageCellWidth", imageCellPadding: "imageCellPadding", imageSizesWidth: "imageSizesWidth", imageSizesHeight: "imageSizesHeight", imageMargin: "imageMargin", width: "width", display: "display", closeButton: "closeButton", resourceButton: "resourceButton", styleColors: "styleColors", boxSizing: "boxSizing", navagationPanelTooltip: "navagationPanelTooltip", cursor: "cursor", fontSize: "fontSize", helpLink: "helpLink", borderColor: "borderColor", styleName: "styleName", enabled: "enabled" }, outputs: { action: "action", closeButtonAction: "closeButtonAction" }, viewQueries: [{ propertyName: "button", first: true, predicate: ["button"], descendants: true }, { propertyName: "resButtonEl", first: true, predicate: ["resButtonEl"], descendants: true }], ngImport: i0, template: `
  <div #button
    [style.fontFamily]="model.options.toolbar.fontFamily"
    [style.cursor]="cursor"
    [style.borderColor]="borderColor"
    [class]="className"
    [style]="{height: helper.val(height, '23px'), boxSizing: helper.val(boxSizing, 'content-box'), margin: helper.val(margin, '1px'), minWidth: minWidth, width: width, display: display }"
    [style.fontSize]="fontSize"
    (mouseover)="mouseover()"
    (mouseout)="mouseout()"
    (click)="click()" >
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%;width:100%" [style.width]="innerTableWidth">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngIf="imageName != null" [style]="{lineHeight:'0', padding:helper.val(imageCellPadding, '0 3px'), textAlign: imageCellTextAlign, width: imageCellWidth}" class="stiJsViewerClearAllStyles">
            <img src="{{model.img(imageName)}}" [style.opacity]="enabled ? '1' : '0.5'"
                [style.width.px]="imageSizesWidth"
                [style.height.px]="imageSizesHeight"
                [style.margin]="imageMargin">
          </td>
          <td *ngIf="caption != null"
             [style]="{whiteSpace:'nowrap', textAlign: captionAlign || 'left', padding:captionPadding || ((arrow ? '1px 0' : '1px 5px') + (imageName ? ' 0 0' : ' 0 5px')), width: captionWidth}"
             [style.maxWidth]="captionMaxWidth"
             [style.lineHeight]="captionLineHeight"
             [style.paddingLeft]="captionPaddingLeft"
             [style.whiteSpace]="captionWhiteSpace"
             [style.overflow]="captionOverflow"
             [style.textOverflow]="captionTextOverflow"
             class="stiJsViewerClearAllStyles">
            {{caption}}
            <div *ngIf="caption2 != null">
            {{caption2}}
            </div>
          </td>
          <td *ngIf="arrow" class="stiJsViewerClearAllStyles">
            <img src="{{arrow == 'Up' || arrow == 'Down' ? model.img('Arrows.SmallArrow' + arrow + (arrow == 'Down' && styleColors && styleColors.isDarkStyle ? 'White.png' : '.png')) : model.img(arrow)}}"
            [style]="{lineHeight:'0', width:'8px', height:'8px', verticalAlign:'baseline', padding:caption ? '0 5px 0 5px' : '0 5px 0 2px', marginTop: arrowMarginTop}"
            [style.opacity]="enabled ? '1' : '0.5'"/>
          </td>

          <td *ngIf="closeButton" class="stiJsViewerClearAllStyles">
            <sti-button [imageName]="'CloseForm.png'"
              [imageMargin]="'1px 0 0 -1px'"
              [margin]="'0 2px 0 0'"
              [imageCellPadding]="'0'"
              [width]="model.options.isTouchDevice ? '22px' : '17px'"
              [height]="model.options.isTouchDevice ? '22px' : '17px'"
              (action)="closeButtonPressed = true; closeButtonAction.emit()">
            </sti-button>
          </td>

          <td #resButtonEl *ngIf="resourceButton" style="width: 1px;">
            <sti-button [imageName]="'Arrows.SmallArrowDown.png'"
              [styleName]="'stiJsViewerResourceDropDownButton'"
              [innerTableWidth]="'100%'"
              [margin]="'0 7px 0 3px'"
              [imageCellTextAlign]="'center'"
              [imageSizesWidth]="8"
              [imageSizesHeight]="8"
              [height]="model.options.isTouchDevice ? '23px' : '17px'"
              [width]="model.options.isTouchDevice ? '23px' : '17px'"
              (action)="resourceButtonPressed = true;">>
            </sti-button>
          </td>

        </tr>
      </tbody>
    </table>
  </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ButtonComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-button',
                    template: `
  <div #button
    [style.fontFamily]="model.options.toolbar.fontFamily"
    [style.cursor]="cursor"
    [style.borderColor]="borderColor"
    [class]="className"
    [style]="{height: helper.val(height, '23px'), boxSizing: helper.val(boxSizing, 'content-box'), margin: helper.val(margin, '1px'), minWidth: minWidth, width: width, display: display }"
    [style.fontSize]="fontSize"
    (mouseover)="mouseover()"
    (mouseout)="mouseout()"
    (click)="click()" >
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 100%;width:100%" [style.width]="innerTableWidth">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngIf="imageName != null" [style]="{lineHeight:'0', padding:helper.val(imageCellPadding, '0 3px'), textAlign: imageCellTextAlign, width: imageCellWidth}" class="stiJsViewerClearAllStyles">
            <img src="{{model.img(imageName)}}" [style.opacity]="enabled ? '1' : '0.5'"
                [style.width.px]="imageSizesWidth"
                [style.height.px]="imageSizesHeight"
                [style.margin]="imageMargin">
          </td>
          <td *ngIf="caption != null"
             [style]="{whiteSpace:'nowrap', textAlign: captionAlign || 'left', padding:captionPadding || ((arrow ? '1px 0' : '1px 5px') + (imageName ? ' 0 0' : ' 0 5px')), width: captionWidth}"
             [style.maxWidth]="captionMaxWidth"
             [style.lineHeight]="captionLineHeight"
             [style.paddingLeft]="captionPaddingLeft"
             [style.whiteSpace]="captionWhiteSpace"
             [style.overflow]="captionOverflow"
             [style.textOverflow]="captionTextOverflow"
             class="stiJsViewerClearAllStyles">
            {{caption}}
            <div *ngIf="caption2 != null">
            {{caption2}}
            </div>
          </td>
          <td *ngIf="arrow" class="stiJsViewerClearAllStyles">
            <img src="{{arrow == 'Up' || arrow == 'Down' ? model.img('Arrows.SmallArrow' + arrow + (arrow == 'Down' && styleColors && styleColors.isDarkStyle ? 'White.png' : '.png')) : model.img(arrow)}}"
            [style]="{lineHeight:'0', width:'8px', height:'8px', verticalAlign:'baseline', padding:caption ? '0 5px 0 5px' : '0 5px 0 2px', marginTop: arrowMarginTop}"
            [style.opacity]="enabled ? '1' : '0.5'"/>
          </td>

          <td *ngIf="closeButton" class="stiJsViewerClearAllStyles">
            <sti-button [imageName]="'CloseForm.png'"
              [imageMargin]="'1px 0 0 -1px'"
              [margin]="'0 2px 0 0'"
              [imageCellPadding]="'0'"
              [width]="model.options.isTouchDevice ? '22px' : '17px'"
              [height]="model.options.isTouchDevice ? '22px' : '17px'"
              (action)="closeButtonPressed = true; closeButtonAction.emit()">
            </sti-button>
          </td>

          <td #resButtonEl *ngIf="resourceButton" style="width: 1px;">
            <sti-button [imageName]="'Arrows.SmallArrowDown.png'"
              [styleName]="'stiJsViewerResourceDropDownButton'"
              [innerTableWidth]="'100%'"
              [margin]="'0 7px 0 3px'"
              [imageCellTextAlign]="'center'"
              [imageSizesWidth]="8"
              [imageSizesHeight]="8"
              [height]="model.options.isTouchDevice ? '23px' : '17px'"
              [width]="model.options.isTouchDevice ? '23px' : '17px'"
              (action)="resourceButtonPressed = true;">>
            </sti-button>
          </td>

        </tr>
      </tbody>
    </table>
  </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.MenuService }, { type: i3.TooltipService }, { type: i4.HelperService }]; }, propDecorators: { caption: [{
                type: Input
            }], caption2: [{
                type: Input
            }], captionAlign: [{
                type: Input
            }], captionPadding: [{
                type: Input
            }], captionPaddingLeft: [{
                type: Input
            }], captionWhiteSpace: [{
                type: Input
            }], captionOverflow: [{
                type: Input
            }], captionTextOverflow: [{
                type: Input
            }], captionWidth: [{
                type: Input
            }], captionMaxWidth: [{
                type: Input
            }], captionLineHeight: [{
                type: Input
            }], imageName: [{
                type: Input
            }], arrow: [{
                type: Input
            }], arrowMarginTop: [{
                type: Input
            }], margin: [{
                type: Input
            }], height: [{
                type: Input
            }], selected: [{
                type: Input
            }], minWidth: [{
                type: Input
            }], innerTableWidth: [{
                type: Input
            }], menuItems: [{
                type: Input
            }], actionName: [{
                type: Input
            }], tooltip: [{
                type: Input
            }], imageCellTextAlign: [{
                type: Input
            }], imageCellWidth: [{
                type: Input
            }], imageCellPadding: [{
                type: Input
            }], imageSizesWidth: [{
                type: Input
            }], imageSizesHeight: [{
                type: Input
            }], imageMargin: [{
                type: Input
            }], width: [{
                type: Input
            }], display: [{
                type: Input
            }], closeButton: [{
                type: Input
            }], resourceButton: [{
                type: Input
            }], styleColors: [{
                type: Input
            }], boxSizing: [{
                type: Input
            }], navagationPanelTooltip: [{
                type: Input
            }], cursor: [{
                type: Input
            }], fontSize: [{
                type: Input
            }], helpLink: [{
                type: Input
            }], borderColor: [{
                type: Input
            }], action: [{
                type: Output
            }], closeButtonAction: [{
                type: Output
            }], button: [{
                type: ViewChild,
                args: ['button']
            }], resButtonEl: [{
                type: ViewChild,
                args: ['resButtonEl']
            }], styleName: [{
                type: Input
            }], enabled: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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