import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/toolbar.service";
import * as i4 from "@angular/common";
import * as i5 from "./toolbar-dop.component";
export class ToolbarComponent {
    constructor(model, controller, toolbarService) {
        this.model = model;
        this.controller = controller;
        this.toolbarService = toolbarService;
    }
    ngAfterViewInit() {
        this.model.controls.toolbar.el = this.element;
    }
    ngOnInit() {
        this.toolbarService.initButtons();
    }
}
ToolbarComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.ToolbarService }], target: i0.ɵɵFactoryTarget.Component });
ToolbarComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ToolbarComponent, selector: "sti-toolbar", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode === 'Separated' ? '  stiJsViewerToolBarSeparated' : '')" style="display: block"
         [style.width.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.height.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.display]="!model.options.isMobileDevice ? (this.model.controls.toolbar.visible ? '' : 'none') : ''"
         [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
         [style.zIndex]="model.options.toolbar.autoHide ? 5 : 2"
         [style.position]="model.options.toolbar.autoHide ? 'absolute' : 'relative'"
         [style.opacity]="model.options.isMobileDevice ? (model.controls.toolbar.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
         [style.marginTop]="model.options.isMobileDevice && !model.controls.toolbar.visible ? '-0.55in' : 0">
      <div [style]="model.options.toolbar.displayMode === 'Simple' ? 'paddingTop: 2px' : ''">
        <table class="stiJsViewerToolBarTable" style="margin: 0px; box-sizing: border-box;"
               cellpadding="0" cellspacing="0"
               [style.background]="model.options.toolbar.backgroundColor !== '' ? model.options.toolbar.backgroundColor : ''"
               [style.border]="model.options.toolbar.displayMode === 'Separated' ? '0px' : (model.options.toolbar.borderColor !== '' ?  '1px solid ' + model.options.toolbar.borderColor : '')"
               [style.color]="model.options.toolbar.fontColor !== '' ? model.options.toolbar.fontColor : ''"
               [style.fontFamily]="model.options.toolbar.fontFamily">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngIf="model.options.appearance.rightToLeft">
              <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>

              <td class="stiJsViewerClearAllStyles" style="width: 100%">
                <sti-toolbar-dop
                  [align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment === 'default' ? 'left' : model.options.toolbar.alignment)"
                  [comps]="toolbarService.comps">
                </sti-toolbar-dop>
              </td>

              <td *ngIf="!model.options.appearance.rightToLeft">
                <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      <div class="stiJsViewerDisabledPanel" [style.display]="this.model.controls.toolbar.enabled ? 'none' : 'block'"></div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ToolbarDopComponent, selector: "sti-toolbar-dop", inputs: ["comps", "align"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-toolbar',
                    template: `
    <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode === 'Separated' ? '  stiJsViewerToolBarSeparated' : '')" style="display: block"
         [style.width.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.height.px]="!model.controls.toolbar.visible ? '0px' : ''"
         [style.display]="!model.options.isMobileDevice ? (this.model.controls.toolbar.visible ? '' : 'none') : ''"
         [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
         [style.zIndex]="model.options.toolbar.autoHide ? 5 : 2"
         [style.position]="model.options.toolbar.autoHide ? 'absolute' : 'relative'"
         [style.opacity]="model.options.isMobileDevice ? (model.controls.toolbar.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
         [style.marginTop]="model.options.isMobileDevice && !model.controls.toolbar.visible ? '-0.55in' : 0">
      <div [style]="model.options.toolbar.displayMode === 'Simple' ? 'paddingTop: 2px' : ''">
        <table class="stiJsViewerToolBarTable" style="margin: 0px; box-sizing: border-box;"
               cellpadding="0" cellspacing="0"
               [style.background]="model.options.toolbar.backgroundColor !== '' ? model.options.toolbar.backgroundColor : ''"
               [style.border]="model.options.toolbar.displayMode === 'Separated' ? '0px' : (model.options.toolbar.borderColor !== '' ?  '1px solid ' + model.options.toolbar.borderColor : '')"
               [style.color]="model.options.toolbar.fontColor !== '' ? model.options.toolbar.fontColor : ''"
               [style.fontFamily]="model.options.toolbar.fontFamily">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td *ngIf="model.options.appearance.rightToLeft">
              <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>

              <td class="stiJsViewerClearAllStyles" style="width: 100%">
                <sti-toolbar-dop
                  [align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment === 'default' ? 'left' : model.options.toolbar.alignment)"
                  [comps]="toolbarService.comps">
                </sti-toolbar-dop>
              </td>

              <td *ngIf="!model.options.appearance.rightToLeft">
                <sti-toolbar-dop [comps]="toolbarService.dopComps" ></sti-toolbar-dop>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
      <div class="stiJsViewerDisabledPanel" [style.display]="this.model.controls.toolbar.enabled ? 'none' : 'block'"></div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.ToolbarService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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