import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/toolbar.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
import * as i6 from "../controls/toolbar-separator.component";
import * as i7 from "../controls/page-control.component";
export class ToolbarDopComponent {
    constructor(model, controller, toolbarService) {
        this.model = model;
        this.controller = controller;
        this.toolbarService = toolbarService;
        this.marginLeft = '1px';
        this.viewInit = false;
    }
    ngAfterViewInit() {
        this.viewInit = true;
        setTimeout(() => {
            const width = this.mainTable?.nativeElement?.offsetWidth;
            this.marginLeft = this.viewInit && this.model.options.toolbar.alignment === 'Center' && width ? `calc(50% - ${Math.trunc(width / 2)}px)` : '1px';
        });
    }
    ngOnInit() { }
}
ToolbarDopComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarDopComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.ToolbarService }], target: i0.ɵɵFactoryTarget.Component });
ToolbarDopComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ToolbarDopComponent, selector: "sti-toolbar-dop", inputs: { comps: "comps", align: "align" }, viewQueries: [{ propertyName: "mainTable", first: true, predicate: ["mainTable"], descendants: true }], ngImport: i0, template: `
    <table #mainTable
      class="stiJsViewerClearAllStyles"
      cellpadding="0"
      cellspacing="0"
      style="margin: 1px;"
      [attr.align]="align"
      [style.marginLeft]="marginLeft">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="model.options.toolbar.showButtonCaptions ? comp.caption : null"
              [imageName]="comp.img"
              [arrow]="!model.options.isMobileDevice ? comp.arrow : null"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [enabled]="toolbarService.enabled(comp)"
              [display]="toolbarService.display(comp)"
              [innerTableWidth]="toolbarService.getInnerTableWidth(comp)"
              [width]="toolbarService.getButonWidth(comp)"
              [height]="model.options.toolbar.displayMode == 'Separated' ? (model.options.isMobileDevice ? '0.5in' : '28px') : null"
              (action)="controller.action({ name: comp.action });"
              [selected]="toolbarService.selected(comp)"></sti-button>
            <sti-toolbar-separator *ngIf="comp.type=='separator'"></sti-toolbar-separator>
            <sti-page-control *ngIf="comp.type=='pageControl'" [enabled]="!(model.reportParams.pagesCount <= 1 || toolbarService.disableNaviButtons())" [count]="model.reportParams.pagesCount" ></sti-page-control>
        </td>
      </tr>
    </tbody>
  </table>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i6.ToolbarSeparatorComponent, selector: "sti-toolbar-separator" }, { kind: "component", type: i7.PageControlComponent, selector: "sti-page-control", inputs: ["enabled", "count", "textBoxBorder", "margin"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ToolbarDopComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-toolbar-dop',
                    template: `
    <table #mainTable
      class="stiJsViewerClearAllStyles"
      cellpadding="0"
      cellspacing="0"
      style="margin: 1px;"
      [attr.align]="align"
      [style.marginLeft]="marginLeft">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="model.options.toolbar.showButtonCaptions ? comp.caption : null"
              [imageName]="comp.img"
              [arrow]="!model.options.isMobileDevice ? comp.arrow : null"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [enabled]="toolbarService.enabled(comp)"
              [display]="toolbarService.display(comp)"
              [innerTableWidth]="toolbarService.getInnerTableWidth(comp)"
              [width]="toolbarService.getButonWidth(comp)"
              [height]="model.options.toolbar.displayMode == 'Separated' ? (model.options.isMobileDevice ? '0.5in' : '28px') : null"
              (action)="controller.action({ name: comp.action });"
              [selected]="toolbarService.selected(comp)"></sti-button>
            <sti-toolbar-separator *ngIf="comp.type=='separator'"></sti-toolbar-separator>
            <sti-page-control *ngIf="comp.type=='pageControl'" [enabled]="!(model.reportParams.pagesCount <= 1 || toolbarService.disableNaviButtons())" [count]="model.reportParams.pagesCount" ></sti-page-control>
        </td>
      </tr>
    </tbody>
  </table>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.ToolbarService }]; }, propDecorators: { mainTable: [{
                type: ViewChild,
                args: ['mainTable']
            }], comps: [{
                type: Input
            }], align: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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