import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
export class ResourcesPanelComponent {
    constructor(model, controller, helper) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                this.model.controls.resourcesPanel.visible = this.model.reportParams.resources?.length > 0;
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.resourcesPanel.el = this.element;
    }
    action(resource) {
        const resTypesAllowedViewInBrowser = ['Image', 'Pdf', 'Txt'];
        const viewType = resTypesAllowedViewInBrowser.indexOf(resource.type) >= 0 ? 'View' : 'SaveFile';
        this.controller.postReportResource(resource.name, this.model.options.jsMode ? 'SaveFile' : viewType);
    }
    getResourceImage(resourceType) {
        if (this.model.img('BigResource' + resourceType + '.png') !== '') {
            return 'BigResource' + resourceType + '.png';
        }
        else {
            return 'BigResource.png';
        }
    }
    getMenuItems(resource) {
        const items = [];
        items.push({ name: 'Resource' + 'View', caption: this.model.loc('ButtonView'), value: resource });
        items.push({ name: 'Resource' + 'SaveFile', caption: this.model.loc('SaveFile'), value: resource });
        return items;
    }
    getActionName(resource) {
        if (!resource.id) {
            resource.id = Math.random().toString();
        }
        return 'resource' + resource.name + resource.id;
    }
}
ResourcesPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ResourcesPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Component });
ResourcesPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ResourcesPanelComponent, selector: "sti-resources-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element style="z-index: 3"
      [style.display]="this.model.controls.resourcesPanel.visible ? '' : 'none'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="model.options.toolbar.fontColor"
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" style="box-sizing: border-box; display: table;"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td *ngFor="let resource of model.reportParams.resources" class="stiJsViewerClearAllStyles">
                  <sti-button [caption]="resource.name"
                    [caption2]="helper.getHumanFileSize(resource.size, 1)"
                    [imageName]="getResourceImage(resource.type)"
                    [styleName]="'stiJsViewerFormButton'"
                    [height]="'auto'"
                    [margin]="'3px 0 3px 3px'"
                    [innerTableWidth]="'100%'"
                    [minWidth]="'80px'"
                    [captionAlign]="'left'"
                    [captionPaddingLeft]="'3px'"
                    [captionMaxWidth]="'150px'"
                    [captionLineHeight]="'14px'"
                    [captionWhiteSpace]="'nowrap'"
                    [captionOverflow]="'hidden'"
                    [captionTextOverflow]="'ellipsis'"
                    [imageCellWidth]="'1px'"
                    [imageCellPadding]="'4px 8px 4px 4px'"
                    [menuItems]="getMenuItems(resource)"
                    [resourceButton]="true"
                    [imageSizesWidth]="32"
                    [imageSizesHeight]="32"
                    [actionName]="getActionName(resource)"
                    (action)="action(resource)">
                  </sti-button>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ResourcesPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-resources-panel',
                    template: `
    <div #element style="z-index: 3"
      [style.display]="this.model.controls.resourcesPanel.visible ? '' : 'none'"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="model.options.toolbar.fontColor"
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" style="box-sizing: border-box; display: table;"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
            <tbody>
              <tr class="stiJsViewerClearAllStyles">
                <td *ngFor="let resource of model.reportParams.resources" class="stiJsViewerClearAllStyles">
                  <sti-button [caption]="resource.name"
                    [caption2]="helper.getHumanFileSize(resource.size, 1)"
                    [imageName]="getResourceImage(resource.type)"
                    [styleName]="'stiJsViewerFormButton'"
                    [height]="'auto'"
                    [margin]="'3px 0 3px 3px'"
                    [innerTableWidth]="'100%'"
                    [minWidth]="'80px'"
                    [captionAlign]="'left'"
                    [captionPaddingLeft]="'3px'"
                    [captionMaxWidth]="'150px'"
                    [captionLineHeight]="'14px'"
                    [captionWhiteSpace]="'nowrap'"
                    [captionOverflow]="'hidden'"
                    [captionTextOverflow]="'ellipsis'"
                    [imageCellWidth]="'1px'"
                    [imageCellPadding]="'4px 8px 4px 4px'"
                    [menuItems]="getMenuItems(resource)"
                    [resourceButton]="true"
                    [imageSizesWidth]="32"
                    [imageSizesHeight]="32"
                    [actionName]="getActionName(resource)"
                    (action)="action(resource)">
                  </sti-button>
                </td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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