import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/controller.service";
import * as i2 from "../services/model.service";
import * as i3 from "../services/styles.service";
import * as i4 from "../services/interactions.service";
import * as i5 from "@angular/common";
import * as i6 from "./page.component";
export class ReportPanelComponent {
    constructor(controller, model, stylesService, interactionService) {
        this.controller = controller;
        this.model = model;
        this.stylesService = stylesService;
        this.interactionService = interactionService;
        this.touchZoomFirstDistance = 0;
        this.touchZoomSecondDistance = 0;
        this.touchZoomValue = 0;
        this.maxHeights = {};
        controller.getMessage().subscribe((message) => {
            if (message.action !== 'viewer_loaded' && this.model.reportParams.pagesArray) {
                if (this.model.reportParams.repaintOnlyDashboardContent) {
                    // jsObject.controls.reportPanel.repaintDashboardContent(parameters);
                }
                else {
                    this.loadPages();
                }
            }
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                setTimeout(() => {
                    if (!this.model.options.isParametersReceived && ((this.model.reportParams.type === 'Report' && this.model.options.toolbar.showParametersButton) || this.model.reportParams.type === 'Dashboard')) {
                        interactionService.postInteraction({ action: 'InitVars' });
                    }
                    if (this.model.reportParams.autoZoom) {
                        this.controller.action({ name: this.model.reportParams.autoZoom === -1 ? 'ZoomPageWidth' : 'ZoomOnePage' });
                        this.model.reportParams.autoZoom = null;
                    }
                });
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.reportPanel.el = this.element;
    }
    loadPages() {
        this.maxHeights = {};
        const pagesArray = this.model.reportParams.pagesArray;
        this.stylesService.setupStyle(pagesArray[pagesArray.length - 2], 'page');
        const chartScript = pagesArray[pagesArray.length - 1];
        this.model.pages = pagesArray.slice(0, pagesArray.length - 2);
        setTimeout(() => {
            this.model.pages.forEach(page => this.interactionService.initializeInteractions(page.page));
            this.interactionService.updateAllHyperLinks();
            this.stylesService.addChartScript(chartScript);
        });
    }
    get position() {
        return this.model.options.heightType !== 'Percentage' || this.model.options.appearance.scrollbarsMode ? 'absolute' : 'relative';
    }
    scroll() {
        if (this.model.pagesNavigationIsActive()) {
            clearTimeout(this.scrollTimeout);
            // update current page number
            this.scrollTimeout = setTimeout(() => {
                let commonPagesHeight = 0;
                let index = 0;
                for (index = 0; index < this.model.pages.length; index++) {
                    commonPagesHeight += this.model.pages[index].page.offsetHeight + 10;
                    if (commonPagesHeight > this.element.nativeElement.scrollTop) {
                        break;
                    }
                }
                if (index < this.model.reportParams.pagesCount && index >= 0 && index !== this.model.reportParams.pageNumber) {
                    this.model.reportParams.pageNumber = index;
                }
            }, 300);
        }
    }
    eventTouchStart(e) {
        this.touchesLength++;
        this.touchStartX = parseInt(e.changedTouches[0].clientX, 10);
        if (this.model.options.appearance.allowTouchZoom && this.touchesLength === 1) {
            this.touchZoomFirstDistance = 0;
            this.touchZoomSecondDistance = 0;
            this.touchZoomValue = 0;
        }
    }
    eventTouchMove(e) {
        if (this.model.options.appearance.allowTouchZoom && e.touches.length > 1) {
            if ('preventDefault' in e) {
                e.preventDefault();
            }
            this.touchZoomSecondDistance = Math.sqrt(Math.pow(e.touches[0].pageX - e.touches[1].pageX, 2) + Math.pow(e.touches[0].pageY - e.touches[1].pageY, 2));
            if (this.touchZoomFirstDistance === 0) {
                this.touchZoomFirstDistance = Math.sqrt(Math.pow(e.touches[0].pageX - e.touches[1].pageX, 2) + Math.pow(e.touches[0].pageY - e.touches[1].pageY, 2));
            }
            const touchZoomOffset = Math.trunc((this.touchZoomSecondDistance - this.touchZoomFirstDistance) / 2.5);
            if (Math.abs(touchZoomOffset) >= 5) {
                this.touchZoomValue = Math.trunc((this.model.reportParams.zoom + touchZoomOffset) / 5) * 5;
                this.touchZoomValue = Math.min(Math.max(this.touchZoomValue, 20), 200);
                this.controller.actionSubject.next({ action: 'centerText', data: this.touchZoomValue.toString() });
            }
        }
    }
    eventTouchEnd(e) {
        if (this.touchesLength > 0) {
            this.touchesLength--;
        }
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            if (Math.trunc(this.touchStartX - e.changedTouches[0].clientX) !== 0) {
                this.controller.keepToolbar();
            }
            else {
                if (!this.model.controls.toolbar.visible) {
                    this.controller.showToolbar();
                }
                else {
                    this.controller.hideToolbar();
                }
            }
        }
        if (this.model.options.appearance.allowTouchZoom && this.touchZoomValue !== 0 && this.touchesLength === 0) {
            this.controller.actionSubject.next({ action: 'hideCenterText' });
            this.model.reportParams.zoom = this.touchZoomValue;
            this.controller.post('GetPages');
        }
    }
}
ReportPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ReportPanelComponent, deps: [{ token: i1.ControllerService }, { token: i2.ModelService }, { token: i3.StylesService }, { token: i4.InteractionsService }], target: i0.ɵɵFactoryTarget.Component });
ReportPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: ReportPanelComponent, selector: "sti-report-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
         [style.textAlign]="model.options.appearance.pageAlignment == 'default' ? 'center' : model.options.appearance.pageAlignment"
         [style.top]="0"
         [style.bottom]="0"
         [style.position]="position"
         [style.height]="model.options.heightType != 'Percentage' || model.options.appearance.scrollbarsMode ? 'auto' : 'calc(100% - 35px)'"
         [style.overflow] = "model.reportParams.type == 'Report' && model.options.appearance.scrollbarsMode ? 'auto' : 'hidden'"
         [style.marginTop.px]="model.controls.reportPanel.layout.top"
         [style.marginLeft.px]="model.controls.reportPanel.layout.left"
         [style.marginBottom.px]="position == 'absolute' ? model.controls.reportPanel.layout.bottom : 0"
         [style.paddingBottom.px]="position == 'relative' ? model.controls.reportPanel.layout.bottom : 0"
         [style.transition]="model.options.isMobileDevice ? 'margin 200ms ease' : null"
         (scroll)="scroll()"
         class="stiJsViewerReportPanel"
         (touchstart)="eventTouchStart($event)"
         (touchmove)="eventTouchMove($event)"
         (touchend)="eventTouchEnd($event)">
      <sti-page *ngFor="let page of model.pages" [pageAttributes]="page"></sti-page>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i6.PageComponent, selector: "sti-page", inputs: ["pageAttributes"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: ReportPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-report-panel',
                    template: `
    <div #element
         [style.textAlign]="model.options.appearance.pageAlignment == 'default' ? 'center' : model.options.appearance.pageAlignment"
         [style.top]="0"
         [style.bottom]="0"
         [style.position]="position"
         [style.height]="model.options.heightType != 'Percentage' || model.options.appearance.scrollbarsMode ? 'auto' : 'calc(100% - 35px)'"
         [style.overflow] = "model.reportParams.type == 'Report' && model.options.appearance.scrollbarsMode ? 'auto' : 'hidden'"
         [style.marginTop.px]="model.controls.reportPanel.layout.top"
         [style.marginLeft.px]="model.controls.reportPanel.layout.left"
         [style.marginBottom.px]="position == 'absolute' ? model.controls.reportPanel.layout.bottom : 0"
         [style.paddingBottom.px]="position == 'relative' ? model.controls.reportPanel.layout.bottom : 0"
         [style.transition]="model.options.isMobileDevice ? 'margin 200ms ease' : null"
         (scroll)="scroll()"
         class="stiJsViewerReportPanel"
         (touchstart)="eventTouchStart($event)"
         (touchmove)="eventTouchMove($event)"
         (touchend)="eventTouchEnd($event)">
      <sti-page *ngFor="let page of model.pages" [pageAttributes]="page"></sti-page>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ControllerService }, { type: i2.ModelService }, { type: i3.StylesService }, { type: i4.InteractionsService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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