import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
export class PageComponent {
    constructor(model, controller) {
        this.model = model;
        this.controller = controller;
        this.touchesLength = 0;
        this.lastTouches = [{ x: 0, y: 0, time: 0 }, { x: 0, y: 0, time: 0 }];
        this.touchAllowPageAction = false;
        this.touchAllowScroll = false;
    }
    ngOnInit() {
    }
    ngAfterViewInit() {
        const page = this.element.nativeElement;
        page.innerHTML = this.pageAttributes.content;
        this.pageAttributes.page = page;
        // Correct Watermark
        if (this.pageAttributes.existsWatermark) {
            page.style.position = 'relative';
            for (const childNode of page.childNodes) {
                if (childNode.className === 'stiWatermarkImage') {
                    childNode.style.width = 'auto';
                    childNode.style.height = 'auto';
                    break;
                }
            }
        }
        let reportDisplayMode = this.model.options.displayModeFromReport || this.model.options.appearance.reportDisplayMode;
        if (reportDisplayMode == "Div" || reportDisplayMode == "Span") {
            const childs = page.getElementsByClassName('StiPageContainer');
            if (childs && childs.length > 0) {
                const pageContainer = childs[0];
                pageContainer.style.position = 'relative';
                if (reportDisplayMode == "Span") {
                    pageContainer.style.margin = '0 1px'; // fix Chrome bug with SPAN position
                }
                page.style.width = (this.pageWidth - this.margins[1] - this.margins[3]) + 'px';
                page.style.height = (this.pageHeight - this.margins[0] - this.margins[2]) + 'px';
            }
        }
        this.element.nativeElement.pageAttributes = this.pageAttributes;
        /*const pageHeight = this.pageHeight;
        if (pageHeight !== 0) {
          // fixed bug with long time execute
          if (this.model.options.appearance.reportDisplayMode !== 'Table' && this.model.reportParams.viewMode !== 'SinglePage') {
            setTimeout(() => {
              const currentPageHeight = page.offsetHeight - this.margins[0] - this.margins[2];
              if (this.reportPanel.maxHeights[pageHeight] == null || currentPageHeight > this.reportPanel.maxHeights[pageHeight]) {
                this.reportPanel.maxHeights[pageHeight] = currentPageHeight;
              }
            });
          } else {
            const currentPageHeight = page.offsetHeight - this.margins[0] - this.margins[2];
            if (this.reportPanel.maxHeights[pageHeight] === null || currentPageHeight > this.reportPanel.maxHeights[pageHeight]) {
              this.reportPanel.maxHeights[pageHeight] = currentPageHeight;
            }
          }
        }*/
    }
    get margins() {
        const margins = [0, 0, 0, 0];
        if (this.pageAttributes.margins) {
            const marginsPx = this.pageAttributes.margins.split(' ');
            for (let i = 0; i < marginsPx.length; i++) {
                margins[i] = parseInt(marginsPx[i].replace('px', ''), 10);
            }
        }
        return margins;
    }
    get pageWidth() {
        const pageSizes = this.pageAttributes.sizes ? this.pageAttributes.sizes.split(';') : null;
        if (pageSizes) {
            return parseInt(pageSizes[0], 10);
        }
        return 0;
    }
    get pageHeight() {
        const pageSizes = this.pageAttributes.sizes ? this.pageAttributes.sizes.split(';') : null;
        if (pageSizes) {
            return parseInt(pageSizes[1], 10);
        }
        return 0;
    }
    eventTouchStart(e) {
        const reportPanel = this.model.controls.reportPanel.el.nativeElement;
        this.touchAllowPageAction = this.touchesLength === 0 && Math.abs(reportPanel.offsetWidth - reportPanel.scrollWidth) <= 10;
        this.touchAllowScroll = reportPanel.offsetWidth === reportPanel.scrollWidth;
        this.touchesLength++;
        if (this.touchAllowPageAction) {
            this.touchStartX = parseInt(e.changedTouches[0].clientX, 10);
            this.touchStartScrollY = reportPanel.scrollTop;
        }
    }
    eventTouchMove(e) {
        const reportPanel = this.model.controls.reportPanel.el.nativeElement;
        if (this.touchAllowPageAction) {
            this.lastTouches.shift();
            this.lastTouches.push({
                x: e.changedTouches[0].clientX,
                y: e.changedTouches[0].clientY,
                time: new Date().getTime()
            });
            if (this.touchAllowScroll && this.touchStartScrollY === reportPanel.scrollTop) {
                this.touchPosX = Math.trunc(this.lastTouches[1].x - this.touchStartX);
                if (scrollX === 0) {
                    this.element.nativeElement.style.transform = `translateX(${this.touchPosX}px)`;
                }
            }
        }
    }
    eventTouchEnd(e) {
        const reportPanel = this.model.controls.reportPanel.el.nativeElement;
        if (this.touchesLength > 0) {
            this.touchesLength--;
        }
        if (this.touchAllowPageAction && this.touchesLength === 0) {
            const dX = this.lastTouches[1].x - this.lastTouches[0].x;
            const dT = new Date().getTime() - this.lastTouches[1].time;
            if (this.touchStartScrollY !== reportPanel.scrollTop ||
                (dX <= 0 && this.model.reportParams.pageNumber >= this.model.reportParams.pagesCount - 1) ||
                (dX >= 0 && this.model.reportParams.pageNumber <= 0)) {
                this.translateX(0);
            }
            else if ((dX < -5 && dT <= 14 && this.lastTouches[1].x < this.touchStartX) ||
                (dX < 0 && this.touchPosX < -this.pageWidth / 3)) {
                this.controller.action({ name: 'NextPage' });
                this.translateX(-this.pageWidth);
            }
            else if ((dX > 5 && dT <= 14 && this.lastTouches[1].x > this.touchStartX) ||
                (dX > 0 && this.touchPosX > this.pageWidth / 3)) {
                this.controller.action({ name: 'PrevPage' });
                this.translateX(this.pageWidth);
            }
            else {
                this.translateX(0);
            }
        }
    }
    translateX(value) {
        this.element.nativeElement.style.transitionDuration = '300ms';
        this.element.nativeElement.style.transform = value === 0 ? '' : `translateX(${value}px)`;
        setTimeout(() => {
            this.element.nativeElement.style.transitionDuration = '';
        }, 300);
    }
}
PageComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }], target: i0.ɵɵFactoryTarget.Component });
PageComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: PageComponent, selector: "sti-page", inputs: { pageAttributes: "pageAttributes" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
      style="overflow: hidden; text-align: left; vertical-align: top; color: #000000; box-sizing: content-box; display:inline-block"
      [style.margin]="model.reportParams.viewMode === 'Continuous' ? '10px auto 10px auto' : '10px'"
      [style.display]="this.model.reportParams.viewMode === 'Continuous' ? 'table' : 'inline-block'"
      [style.border]="'1px solid ' + this.model.options.appearance.pageBorderColor"
      [style.background]="pageAttributes['background'] == 'Transparent' || pageAttributes.background == 'rgba(255,255,255,0)' ? 'White' : pageAttributes['background']"
      [style.padding]="pageAttributes['margins']"
      [style.width]="!pageAttributes['content'] ? pageWidth + 'px' : ''"
      [style.height]="!pageAttributes['content'] ? pageHeight + 'px' : ''"
      [class]="model.options.appearance.showPageShadow ? 'stiJsViewerPageShadow' : 'stiJsViewerPage'"
      (touchstart)="eventTouchStart($event)"
      (touchmove)="eventTouchMove($event)"
      (touchend)="eventTouchEnd($event)">
      </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: PageComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-page',
                    template: `
    <div #element
      style="overflow: hidden; text-align: left; vertical-align: top; color: #000000; box-sizing: content-box; display:inline-block"
      [style.margin]="model.reportParams.viewMode === 'Continuous' ? '10px auto 10px auto' : '10px'"
      [style.display]="this.model.reportParams.viewMode === 'Continuous' ? 'table' : 'inline-block'"
      [style.border]="'1px solid ' + this.model.options.appearance.pageBorderColor"
      [style.background]="pageAttributes['background'] == 'Transparent' || pageAttributes.background == 'rgba(255,255,255,0)' ? 'White' : pageAttributes['background']"
      [style.padding]="pageAttributes['margins']"
      [style.width]="!pageAttributes['content'] ? pageWidth + 'px' : ''"
      [style.height]="!pageAttributes['content'] ? pageHeight + 'px' : ''"
      [class]="model.options.appearance.showPageShadow ? 'stiJsViewerPageShadow' : 'stiJsViewerPage'"
      (touchstart)="eventTouchStart($event)"
      (touchmove)="eventTouchMove($event)"
      (touchend)="eventTouchEnd($event)">
      </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], pageAttributes: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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