import { Component, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "@angular/common";
export class OpenDialogComponent {
    constructor(model, controller) {
        this.model = model;
        this.controller = controller;
    }
    ngOnChanges(changes) {
        if (this.fileMask != null && this.model.openDialogFileMask != null) {
            setTimeout(() => {
                this.element.nativeElement.focus();
                this.element.nativeElement.click();
            });
        }
    }
    ngOnInit() { }
    onchange(event) {
        const files = event.target.files;
        const fileName = files[0] ? files[0].name : 'Report';
        const filePath = event.target.value;
        const reader = new FileReader();
        reader.onload = (e) => {
            this.controller.loadFile(fileName, e.target.result);
        };
        this.model.openDialogFileMask = null;
        reader.readAsDataURL(files[0]);
    }
}
OpenDialogComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: OpenDialogComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }], target: i0.ɵɵFactoryTarget.Component });
OpenDialogComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: OpenDialogComponent, selector: "sti-open-dialog", inputs: { fileMask: "fileMask" }, viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <input #element *ngIf="model.openDialogFileMask != null"  type="file" name="files[]" multiple="" style="display: none;"
      [attr.accept]="model.openDialogFileMask"
      (change)="onchange($event)">
  `, isInline: true, dependencies: [{ kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: OpenDialogComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-open-dialog',
                    template: `
    <input #element *ngIf="model.openDialogFileMask != null"  type="file" name="files[]" multiple="" style="display: none;"
      [attr.accept]="model.openDialogFileMask"
      (change)="onchange($event)">
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], fileMask: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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