import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
import * as i4 from "../services/page.service";
import * as i5 from "@angular/common";
import * as i6 from "../controls/button.component";
import * as i7 from "../controls/page-control.component";
export class NavigatePanelComponent {
    constructor(model, controller, helper, pageService) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.pageService = pageService;
        this.comps = [];
    }
    ngOnInit() {
        if (this.model.options.toolbar.displayMode === 'Separated') {
            this.initButtons();
        }
        this.controller.getMessage().subscribe((message) => {
            if (message.action !== 'viewer_loaded') {
                this.updateButtons();
            }
        });
        this.model.controls.navigatePanel.visible = this.model.options.toolbar.displayMode === 'Separated';
    }
    ngAfterViewInit() {
        this.model.controls.navigatePanel.el = this.element;
    }
    updateButtons() {
        this.comps.filter(i => i.action === 'ViewMode').forEach(m => m.caption = this.model.loc(this.model.reportParams.viewMode));
        this.comps.filter(i => i.action === 'Zoom').forEach((m) => {
            m.menuItems.forEach(n => n.selected = n.name === ('Zoom' + this.model.reportParams.zoom));
            m.caption = Math.round(this.model.reportParams.zoom) + '%';
        });
        this.comps.filter(i => i.action === 'ShowFind').forEach((m) => {
            m.selected = this.model.controls.findPanel.visible;
        });
    }
    initButtons() {
        const comps = [];
        if (this.model.options.toolbar.showFirstPageButton) {
            comps.push({ type: 'button', action: 'FirstPage', img: 'PageFirst20.png', tooltip: true });
        }
        if (this.model.options.toolbar.showPreviousPageButton) {
            comps.push({ type: 'button', action: 'PrevPage', img: 'PagePrevious20.png', tooltip: true });
        }
        if (this.model.options.toolbar.showCurrentPageControl) {
            comps.push({ type: 'separator' });
            comps.push({ type: 'pageControl' });
            comps.push({ type: 'separator' });
        }
        if (this.model.options.toolbar.showNextPageButton) {
            comps.push({ type: 'button', action: 'NextPage', img: 'PageNext20.png', tooltip: true });
        }
        if (this.model.options.toolbar.showLastPageButton) {
            comps.push({ type: 'button', action: 'LastPage', img: 'PageLast20.png', tooltip: true });
        }
        comps.push({ type: 'space' });
        comps.push({ type: 'button', action: 'ZoomPageWidth', img: 'ZoomPageWidth20.png', tooltip: true });
        comps.push({ type: 'button', action: 'ZoomOnePage', img: 'ZoomOnePage20.png', tooltip: true });
        if (this.model.options.toolbar.showZoomButton) {
            comps.push({ type: 'separator' });
            comps.push({
                type: 'button', action: 'Zoom', caption: '100%', tooltip: true, arrow: 'Arrows.SmallArrowUpWhite.png',
                menuItems: this.helper.getZoomMenuItems()
            });
        }
        this.comps = comps;
    }
    enabled(desc) {
        const disableNaviButtons = this.disableNaviButtons();
        switch (desc.action) {
            case 'FirstPage':
            case 'PrevPage':
                return this.model.reportParams.pageNumber > 0 && !disableNaviButtons;
            case 'NextPage':
            case 'LastPage':
                return this.model.reportParams.pageNumber < this.model.reportParams.pagesCount - 1 && !disableNaviButtons;
        }
        return true;
    }
    selected(desc) {
        switch (desc.action) {
            case 'ZoomPageWidth':
                return Math.round(this.model.reportParams.zoom) === Math.round(this.pageService.getZoomByPageWidth());
            case 'ZoomOnePage':
                return Math.round(this.model.reportParams.zoom) === Math.round(this.pageService.getZoomByPageHeight());
        }
        return false;
    }
    disableNaviButtons() {
        return this.model.reportParams.viewMode === 'MultiplePages' || this.model.reportParams.viewMode === 'WholeReport' ||
            (this.model.reportParams.viewMode === 'Continuous' && !this.model.options.appearance.scrollbarsMode && !this.model.options.appearance.fullScreenMode);
    }
}
NavigatePanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NavigatePanelComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }, { token: i4.PageService }], target: i0.ɵɵFactoryTarget.Component });
NavigatePanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: NavigatePanelComponent, selector: "sti-navigate-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
  <div #element class="stiJsViewerNavigatePanel" style="display: block;"
    [style.display]="!model.options.isMobileDevice ? (this.model.controls.navigatePanel.visible ? '' : 'none') : ''"
    [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
    [style.zIndex]="model.options.isMobileDevice ? (model.options.toolbar.autoHide ? 5 : 2) : null"
    [style.opacity]="model.options.isMobileDevice ? (model.controls.navigatePanel.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
    [style.marginBottom]="model.options.isMobileDevice && !model.controls.navigatePanel.visible ? '-0.55in' : 0">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles" [style.width]="comp.type == 'space' ? '100%' : null">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="comp.caption"
              [imageName]="comp.img"
              [arrow]="comp.arrow"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [styleName]="'stiJsViewerNavigateButton'"
              [height]="model.options.isMobileDevice ? '0.5in' : '35px'"
              [width]="model.options.isMobileDevice ? '0.4in' : '35px'"
              [boxSizing]="'border-box'"
              [arrowMarginTop]="'1px'"
              [enabled]="enabled(comp)"
              [imageCellTextAlign]="'center'"
              [innerTableWidth]="'100%'"
              [navagationPanelTooltip]="true"
              [margin]="comp.action == 'FirstPage' ? '0 1px 0 3px' : (comp.action == 'Zoom' ? '0 3px 0 1px' : '0px 1px 0 1px')"
              [selected]="selected(comp)"
              (action)="controller.action({ name: comp.action })">
            </sti-button>

            <div *ngIf="comp.type=='separator'"
              [style.height]="model.options.isMobileDevice ? '0.5in' : '35px'"
              [style.margin]="'0px 1px 0 1px'"
              class="stiJsViewerNavigatePanelSeparator"></div>

            <sti-page-control *ngIf="comp.type=='pageControl'"
              [enabled]="!(model.reportParams.pagesCount <= 1 || disableNaviButtons())"
              [count]="model.reportParams.pagesCount"
              [margin]="'0px 1px 0 1px'"
              [textBoxBorder]="'0px'"></sti-page-control>
          </td>
        </tr>
      </tbody>
    </table>
    <div class="stiJsViewerNavigatePanelDisabledPanel" [style.display]="this.model.controls.navigatePanel.enabled ? 'none' : 'block'"></div>
  </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i7.PageControlComponent, selector: "sti-page-control", inputs: ["enabled", "count", "textBoxBorder", "margin"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: NavigatePanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-navigate-panel',
                    template: `
  <div #element class="stiJsViewerNavigatePanel" style="display: block;"
    [style.display]="!model.options.isMobileDevice ? (this.model.controls.navigatePanel.visible ? '' : 'none') : ''"
    [style.transition]="model.options.isMobileDevice ? 'margin 300ms ease, opacity 300ms ease' : null"
    [style.zIndex]="model.options.isMobileDevice ? (model.options.toolbar.autoHide ? 5 : 2) : null"
    [style.opacity]="model.options.isMobileDevice ? (model.controls.navigatePanel.visible ? (model.options.toolbar.autoHide ? 0.9 : 1) : 0) : 1"
    [style.marginBottom]="model.options.isMobileDevice && !model.controls.navigatePanel.visible ? '-0.55in' : 0">
    <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
      <tbody>
        <tr class="stiJsViewerClearAllStyles">
          <td *ngFor="let comp of comps" class="stiJsViewerClearAllStyles" [style.width]="comp.type == 'space' ? '100%' : null">
            <sti-button *ngIf="comp.type=='button'"
              [caption]="comp.caption"
              [imageName]="comp.img"
              [arrow]="comp.arrow"
              [menuItems]="comp.menuItems"
              [actionName]="comp.action"
              [tooltip]="comp.tooltip"
              [styleName]="'stiJsViewerNavigateButton'"
              [height]="model.options.isMobileDevice ? '0.5in' : '35px'"
              [width]="model.options.isMobileDevice ? '0.4in' : '35px'"
              [boxSizing]="'border-box'"
              [arrowMarginTop]="'1px'"
              [enabled]="enabled(comp)"
              [imageCellTextAlign]="'center'"
              [innerTableWidth]="'100%'"
              [navagationPanelTooltip]="true"
              [margin]="comp.action == 'FirstPage' ? '0 1px 0 3px' : (comp.action == 'Zoom' ? '0 3px 0 1px' : '0px 1px 0 1px')"
              [selected]="selected(comp)"
              (action)="controller.action({ name: comp.action })">
            </sti-button>

            <div *ngIf="comp.type=='separator'"
              [style.height]="model.options.isMobileDevice ? '0.5in' : '35px'"
              [style.margin]="'0px 1px 0 1px'"
              class="stiJsViewerNavigatePanelSeparator"></div>

            <sti-page-control *ngIf="comp.type=='pageControl'"
              [enabled]="!(model.reportParams.pagesCount <= 1 || disableNaviButtons())"
              [count]="model.reportParams.pagesCount"
              [margin]="'0px 1px 0 1px'"
              [textBoxBorder]="'0px'"></sti-page-control>
          </td>
        </tr>
      </tbody>
    </table>
    <div class="stiJsViewerNavigatePanelDisabledPanel" [style.display]="this.model.controls.navigatePanel.enabled ? 'none' : 'block'"></div>
  </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }, { type: i4.PageService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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