import { Component, ViewChild } from '@angular/core';
import { trigger, state, transition, style, keyframes, animate } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "../services/interactions.service";
import * as i4 from "../menu/menu.service";
import * as i5 from "../services/controller.service";
import * as i6 from "@angular/common";
import * as i7 from "../controls/form-button.component";
import * as i8 from "../controls/parameters/parameter.component";
export class InteractionsPanelComponent {
    constructor(model, helper, interactionService, menuService, controller) {
        this.model = model;
        this.helper = helper;
        this.interactionService = interactionService;
        this.menuService = menuService;
        this.controller = controller;
        this.currentOpeningParameter = null;
        this.dropDownButtonWasClicked = false;
        this.dateTimeButtonWasClicked = false;
    }
    ngAfterViewInit() {
        this.model.controls.parametersPanel.el = this.element;
    }
    ngOnInit() { }
    getNameAlign(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        if (index < this.length() &&
            this.model.interactions.paramsVariables[index].basicType === 'Range' &&
            this.model.options.appearance.parametersPanelPosition === 'Left') {
            return 'top';
        }
        return '';
    }
    getNamePadding(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        if (index < this.length() &&
            this.model.interactions.paramsVariables[index].basicType === 'Range' &&
            this.model.options.appearance.parametersPanelPosition === 'Left') {
            return this.model.options.isTouchDevice ? '11px' : '9px';
        }
        return '';
    }
    getCaption(indexRow, indexColumn, checkLeft = true) {
        const index = this.index(indexRow, indexColumn);
        if (checkLeft && this.ifLeftRange(indexRow, indexColumn)) {
            return '';
        }
        return index < this.length() ? this.model.interactions.paramsVariables[index].alias : '';
    }
    ifLeftRange(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        return this.model.interactions.paramsVariables[index].basicType === 'Range' && this.model.options.appearance.parametersPanelPosition === 'Left';
    }
    getTitle(indexRow, indexColumn) {
        const index = this.index(indexRow, indexColumn);
        return index < this.length() ? this.model.interactions.paramsVariables[index].description : '';
    }
    index(indexRow, indexColumn) {
        return indexColumn * this.model.interactions.countInColumn.length + indexRow;
    }
    length() {
        return this.model.interactions?.paramsVariables != null ? Object.keys(this.model.interactions?.paramsVariables).length : 0;
    }
    get className() {
        let className = 'stiJsViewerParametersPanel';
        if (this.model.options.appearance.parametersPanelPosition === 'Top') {
            className += ' stiJsViewerParametersPanelTop';
            if (this.model.options.toolbar.displayMode === 'Separated') {
                className += ' stiJsViewerParametersPanelSeparatedTop';
            }
        }
        return className;
    }
    get top() {
        let styleTop = this.model.options.toolbar.visible ? this.model.controls.toolbar.offsetHeight : 0;
        if (this.model.options.isMobileDevice && this.model.options.toolbar.autoHide) {
            styleTop = 0;
        }
        styleTop += this.model.controls.drillDownPanel.exists ? this.model.controls.drillDownPanel.offsetHeight : 0;
        styleTop += this.model.controls.findPanel.exists ? this.model.controls.findPanel.offsetHeight : 0;
        styleTop += this.model.controls.resourcesPanel.exists ? this.model.controls.resourcesPanel.offsetHeight : 0;
        return styleTop;
    }
    get bottom() {
        if (this.model.options.appearance.parametersPanelPosition === 'Left') {
            if (this.model.options.isMobileDevice) {
                return this.model.options.toolbar.autoHide ? '0' : '0.5in';
            }
            else {
                return this.model.options.toolbar.displayMode === 'Separated' && this.model.options.toolbar.visible ? '35px' : '0';
            }
        }
        return '';
    }
    get innerClassName() {
        let className = this.model.options.toolbar.displayMode === 'Simple' ? 'stiJsViewerInnerParametersPanelSimple' : '';
        if (this.model.options.appearance.parametersPanelPosition === 'Left') {
            className += ' stiJsViewerInnerParametersPanelLeft';
            if (this.model.options.toolbar.displayMode === 'Separated') {
                className += ' stiJsViewerInnerParametersPanelSeparatedLeft';
            }
        }
        return className;
    }
}
InteractionsPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.InteractionsService }, { token: i4.MenuService }, { token: i5.ControllerService }], target: i0.ɵɵFactoryTarget.Component });
InteractionsPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: InteractionsPanelComponent, selector: "sti-interactions-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element [class]="className"
       [style.display]="!this.model.options.isMobileDevice ? (model.controls.parametersPanel.visible ? '' : 'none') : null"
       [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbar.fontColor"
       [style.top.px]="top"
       [style.left.px]="model.controls.parametersPanel.layout.left"
       [style.bottom]="bottom"
       [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
       [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.parametersPanel.visible ? 'visible' : 'hidden')">
       <div [class]="innerClassName" [style.marginTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''" (scroll)="menuService.closeAllMenus()">
         <div class="stiJsViewerInnerContainerParametersPanel"
              [style.background]="helper.val(model.options.toolbar.backgroundColor, '')"
              [style.border]="helper.val(model.options.toolbar.backgroundColor, '') != '' ? '1px solid ' + helper.val(model.options.toolbar.backgroundColor, '') : ''"
              [style.maxHeight]="model.options.appearance.parametersPanelPosition == 'Top' ? model.options.appearance.parametersPanelMaxHeight + 'px' : ''"
              (scroll)="menuService.closeAllMenus()">
            <table *ngIf="model.interactions" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="border: 0px;">
              <tbody>
                <tr *ngFor="let item of model.interactions.countInColumn; let indexRow=index" >
                  <ng-container *ngFor="let item2 of model.interactions.countColumns; let indexColumn=index">
                    <ng-container *ngIf="index(indexRow, indexColumn) < length()">
                        <td [style.padding]="'0 10px 0 ' + (indexColumn > 0 ? '30px' : '0')"
                            [style.whiteSpace]="'nowrap'"
                            [style.verticalAlign]='getNameAlign(indexRow, indexColumn)'
                            [style.paddingTop]='getNamePadding(indexRow, indexColumn)'
                            [attr.title]='getTitle(indexRow, indexColumn)'>
                            {{getCaption(indexRow, indexColumn)}}
                              <table *ngIf="ifLeftRange(indexRow, indexColumn)" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 60px;">
                                <tbody>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" rowspan="2" style="vertical-align: top; padding-top: 9px;">
                                      {{getCaption(indexRow, indexColumn, false)}}
                                    </td>
                                    <td class="stiJsViewerClearAllStyles" style="padding-left: 12px;">
                                      {{model.loc('RangeFrom')}}
                                    </td>
                                  </tr>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" style="padding-left: 12px;">
                                      {{model.loc('RangeTo')}}
                                    </td>
                                  </tr>
                                </tbody>
                              </table>
                            </td>
                        <td [style.padding]="'0px'">
                          <sti-parameter *ngIf="index(indexRow, indexColumn) != length()"  [params]="model.interactions.paramsVariables[index(indexRow, indexColumn)]"></sti-parameter>

                          <!--table *ngIf="index(indexRow, indexColumn) == length()" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                            align="right" style="margin: 5px 2px 10px 0px;">
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                              </td>
                              <td class="stiJsViewerClearAllStyles" style="padding-left: 10px;">
                                <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                              </td>
                            </tr>
                          </table-->
                        </td>
                    </ng-container>
                  </ng-container>
                </tr>
                <tr><!--*ngIf="length() == model.interactions.countInColumn.length * model.interactions.countColumns.length"-->
                  <td></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td [style.padding]="'0px'">
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                         align="right" style="margin: 5px 2px 10px 0px;">
                         <tr class="stiJsViewerClearAllStyles">
                           <td class="stiJsViewerClearAllStyles">
                             <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                           </td>
                           <td class="stiJsViewerClearAllStyles" style="padding-left: 10px;">
                              <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                           </td>
                         </tr>
                       </table>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i6.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.FormButtonComponent, selector: "sti-form-button", inputs: ["caption", "actionName", "imageName", "imageCellWidth", "captionPadding", "margin", "captionAlign"], outputs: ["action"] }, { kind: "component", type: i8.ParameterComponent, selector: "sti-parameter", inputs: ["params"] }], animations: [
        trigger('visibility', [
            state('visible', style({ opacity: 1, display: 'block' })),
            state('hidden', style({ opacity: 0, display: 'none' })),
            transition('hidden => visible', [
                animate('300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 0, offset: 0 }),
                    style({ display: 'block', opacity: 1, offset: 1 }),
                ]))
            ]),
            transition('visible => hidden', [
                animate('300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 1, offset: 0 }),
                    style({ display: 'none', opacity: 0, offset: 1 }),
                ]))
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: InteractionsPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-interactions-panel',
                    template: `
    <div #element [class]="className"
       [style.display]="!this.model.options.isMobileDevice ? (model.controls.parametersPanel.visible ? '' : 'none') : null"
       [style.fontFamily]="model.options.toolbar.fontFamily"
       [style.color]="model.options.toolbar.fontColor"
       [style.top.px]="top"
       [style.left.px]="model.controls.parametersPanel.layout.left"
       [style.bottom]="bottom"
       [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
       [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.parametersPanel.visible ? 'visible' : 'hidden')">
       <div [class]="innerClassName" [style.marginTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''" (scroll)="menuService.closeAllMenus()">
         <div class="stiJsViewerInnerContainerParametersPanel"
              [style.background]="helper.val(model.options.toolbar.backgroundColor, '')"
              [style.border]="helper.val(model.options.toolbar.backgroundColor, '') != '' ? '1px solid ' + helper.val(model.options.toolbar.backgroundColor, '') : ''"
              [style.maxHeight]="model.options.appearance.parametersPanelPosition == 'Top' ? model.options.appearance.parametersPanelMaxHeight + 'px' : ''"
              (scroll)="menuService.closeAllMenus()">
            <table *ngIf="model.interactions" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="border: 0px;">
              <tbody>
                <tr *ngFor="let item of model.interactions.countInColumn; let indexRow=index" >
                  <ng-container *ngFor="let item2 of model.interactions.countColumns; let indexColumn=index">
                    <ng-container *ngIf="index(indexRow, indexColumn) < length()">
                        <td [style.padding]="'0 10px 0 ' + (indexColumn > 0 ? '30px' : '0')"
                            [style.whiteSpace]="'nowrap'"
                            [style.verticalAlign]='getNameAlign(indexRow, indexColumn)'
                            [style.paddingTop]='getNamePadding(indexRow, indexColumn)'
                            [attr.title]='getTitle(indexRow, indexColumn)'>
                            {{getCaption(indexRow, indexColumn)}}
                              <table *ngIf="ifLeftRange(indexRow, indexColumn)" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="height: 60px;">
                                <tbody>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" rowspan="2" style="vertical-align: top; padding-top: 9px;">
                                      {{getCaption(indexRow, indexColumn, false)}}
                                    </td>
                                    <td class="stiJsViewerClearAllStyles" style="padding-left: 12px;">
                                      {{model.loc('RangeFrom')}}
                                    </td>
                                  </tr>
                                  <tr class="stiJsViewerClearAllStyles">
                                    <td class="stiJsViewerClearAllStyles" style="padding-left: 12px;">
                                      {{model.loc('RangeTo')}}
                                    </td>
                                  </tr>
                                </tbody>
                              </table>
                            </td>
                        <td [style.padding]="'0px'">
                          <sti-parameter *ngIf="index(indexRow, indexColumn) != length()"  [params]="model.interactions.paramsVariables[index(indexRow, indexColumn)]"></sti-parameter>

                          <!--table *ngIf="index(indexRow, indexColumn) == length()" class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                            align="right" style="margin: 5px 2px 10px 0px;">
                            <tr class="stiJsViewerClearAllStyles">
                              <td class="stiJsViewerClearAllStyles">
                                <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                              </td>
                              <td class="stiJsViewerClearAllStyles" style="padding-left: 10px;">
                                <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                              </td>
                            </tr>
                          </table-->
                        </td>
                    </ng-container>
                  </ng-container>
                </tr>
                <tr><!--*ngIf="length() == model.interactions.countInColumn.length * model.interactions.countColumns.length"-->
                  <td></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td *ngIf="model.interactions.countColumns.length > 1"></td>
                  <td [style.padding]="'0px'">
                      <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0"
                         align="right" style="margin: 5px 2px 10px 0px;">
                         <tr class="stiJsViewerClearAllStyles">
                           <td class="stiJsViewerClearAllStyles">
                             <sti-form-button [caption]="model.loc('Reset')" (action)="controller.action({name: 'Reset'})"></sti-form-button>
                           </td>
                           <td class="stiJsViewerClearAllStyles" style="padding-left: 10px;">
                              <sti-form-button [caption]="model.loc('Submit')" (action)="controller.action({name: 'Submit'})"></sti-form-button>
                           </td>
                         </tr>
                       </table>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
      </div>
    </div>
  `,
                    animations: [
                        trigger('visibility', [
                            state('visible', style({ opacity: 1, display: 'block' })),
                            state('hidden', style({ opacity: 0, display: 'none' })),
                            transition('hidden => visible', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ]),
                            transition('visible => hidden', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 1, offset: 0 }),
                                    style({ display: 'none', opacity: 0, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.InteractionsService }, { type: i4.MenuService }, { type: i5.ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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