import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/find.service";
import * as i3 from "../services/controller.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
import * as i6 from "../controls/text-box.componet";
import * as i7 from "../controls/text-block.component";
export class FindPanelComponent {
    constructor(model, findService, controller) {
        this.model = model;
        this.findService = findService;
        this.controller = controller;
        this.changeFind = false;
        this.initItems();
        controller.getMessage().subscribe((message) => {
            switch (message.action) {
                case 'GetReport':
                case 'GetPages':
                case 'OpenReport':
                case 'Variables':
                    if (model.controls.findPanel.visible) {
                        setTimeout(() => {
                            this.findService.hideFindLabels();
                            this.find('Next');
                        });
                    }
                    break;
            }
        });
    }
    ngAfterViewInit() {
        this.model.controls.findPanel.el = this.element;
        this.model.controls.findPanel.getVisibility().subscribe(() => {
            if (this.model.controls.findPanel.visible) {
                this.findService.text = '';
                setTimeout(() => {
                    this.textBox.element.nativeElement.focus();
                });
            }
        });
    }
    ngOnInit() { }
    selected(item) {
        switch (item.action) {
            case 'MatchCase':
                return this.findService.matchCase;
            case 'MatchWholeWord':
                return this.findService.matchWholeWord;
        }
        return false;
    }
    textBoxAction(target) {
        this.findService.text = target.value;
        this.find('Next');
    }
    find(direction) {
        if (this.findService.text === '') {
            this.findService.hideFindLabels();
            return;
        }
        if (this.findService.lastFindText !== this.findService.text || this.changeFind) {
            this.changeFind = false;
            this.findService.showFindLabels();
        }
        else {
            this.findService.selectFindLabel(direction);
        }
    }
    initItems() {
        this.items = [
            { type: 'button', action: 'close', img: 'CloseForm.png', margin: '2px' },
            { type: 'textBlock', action: 'text', caption: this.model.loc('FindWhat').replace(":", ""), margin: '2px' },
            { type: 'textBox', action: 'findTextBox', margin: '2px' },
            { type: 'button', action: 'FindPreviows', caption: this.model.loc('FindPrevious'), img: 'Arrows.ArrowUpBlue.png', margin: '2px' },
            { type: 'button', action: 'FindNext', caption: this.model.loc('FindNext'), img: 'Arrows.ArrowDownBlue.png', margin: '2px' },
            { type: 'button', action: 'MatchCase', caption: this.model.loc('MatchCase').replace('&', ''), margin: '2px' },
            { type: 'button', action: 'MatchWholeWord', caption: this.model.loc('MatchWholeWord').replace('&', ''), margin: '2px' }
        ];
    }
    action(action) {
        switch (action) {
            case 'close':
                this.model.controls.findPanel.visible = false;
                break;
            case 'MatchCase':
                this.findService.matchCase = !this.findService.matchCase;
                this.changeFind = true;
                break;
            case 'MatchWholeWord':
                this.findService.matchWholeWord = !this.findService.matchWholeWord;
                this.changeFind = true;
                break;
            case 'FindPreviows':
                this.findService.text = this.textBox.element.nativeElement.value;
                this.find('Previous');
                break;
            case 'FindNext':
                this.findService.text = this.textBox.element.nativeElement.value;
                this.find('Next');
                break;
        }
    }
}
FindPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.FindService }, { token: i3.ControllerService }], target: i0.ɵɵFactoryTarget.Component });
FindPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: FindPanelComponent, selector: "sti-find-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "textBox", first: true, predicate: ["textBox"], descendants: true }], ngImport: i0, template: `
    <div #element [style.display]="model.controls.findPanel.visible ? '' : 'none'"
    [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''" style="box-sizing: border-box">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 0">
            <tbody>
                <tr class="stiJsViewerClearAllStyles">
                   <td *ngFor="let item of items"  class="stiJsViewerClearAllStyles">
                      <sti-button *ngIf="item.type=='button'"
                        [actionName]="item.action"
                        [imageName]="item.img"
                        [caption]="item.caption"
                        [margin]="item.margin"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : ''"
                        (action)="action(item.action)"
                        [selected]="selected(item)"
                        ></sti-button>
                      <sti-text-box #textBox *ngIf="item.type=='textBox'" [width]="170"
                        [margin]="item.margin"
                        [focusOnCreate]="true"
                        (action)="textBoxAction($event)"
                        [value]="findService.text"></sti-text-box>
                      <sti-text-block *ngIf="item.type=='textBlock'" [margin]="item.margin" [text]="item.caption"></sti-text-block>
                  </td>
                </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i6.TextBoxComponent, selector: "sti-text-box", inputs: ["width", "actionLostFocus", "tooltip", "enabled", "value", "margin", "focusOnCreate", "maxLength", "color", "type", "padding", "border", "variable", "readOnly"], outputs: ["action", "onchange", "onblur"] }, { kind: "component", type: i7.TextBlockComponent, selector: "sti-text-block", inputs: ["text", "margin"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FindPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-find-panel',
                    template: `
    <div #element [style.display]="model.controls.findPanel.visible ? '' : 'none'"
    [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <div class="stiJsViewerToolBarTable" [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''" style="box-sizing: border-box">
          <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0" style="margin: 0">
            <tbody>
                <tr class="stiJsViewerClearAllStyles">
                   <td *ngFor="let item of items"  class="stiJsViewerClearAllStyles">
                      <sti-button *ngIf="item.type=='button'"
                        [actionName]="item.action"
                        [imageName]="item.img"
                        [caption]="item.caption"
                        [margin]="item.margin"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : ''"
                        (action)="action(item.action)"
                        [selected]="selected(item)"
                        ></sti-button>
                      <sti-text-box #textBox *ngIf="item.type=='textBox'" [width]="170"
                        [margin]="item.margin"
                        [focusOnCreate]="true"
                        (action)="textBoxAction($event)"
                        [value]="findService.text"></sti-text-box>
                      <sti-text-block *ngIf="item.type=='textBlock'" [margin]="item.margin" [text]="item.caption"></sti-text-block>
                  </td>
                </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.FindService }, { type: i3.ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], textBox: [{
                type: ViewChild,
                args: ['textBox']
            }] } });
//# sourceMappingURL=data:application/json;base64,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