import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/drill-down.service";
import * as i3 from "../services/controller.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
export class DrillDownPanelComponent {
    constructor(model, drillDownService, controller) {
        this.model = model;
        this.drillDownService = drillDownService;
        this.controller = controller;
        controller.getMessage().subscribe((message) => {
            if (message?.action === 'DrillDown' && this.element) {
                this.element.nativeElement.scrollTop = 0;
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.drillDownPanel.el = this.element;
    }
    action(button) {
        this.drillDownService.saveState();
        this.model.drillDownButtons.forEach(b => b.selected = false);
        button.selected = true;
        this.model.setReportParams(button.reportParams);
        this.element.nativeElement.scrollTop = 0;
        this.controller.getPages();
    }
    close(button) {
        this.model.drillDownButtons.splice(this.model.drillDownButtons.indexOf(button), 1);
        button.visible = false;
        if (button.selected) {
            this.action(this.model.drillDownButtons[0]);
        }
    }
}
DrillDownPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.DrillDownService }, { token: i3.ControllerService }], target: i0.ɵɵFactoryTarget.Component });
DrillDownPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DrillDownPanelComponent, selector: "sti-drill-down-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
  <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
    [style.display]="model.controls.drillDownPanel.visible ? '' : 'none'">
    <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
      <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin: 0px; box-sizing: border-box;"
        [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                <tbody>
                  <tr class="stiJsViewerClearAllStyles">
                    <td *ngFor="let button of model.drillDownButtons; index as i" class="stiJsViewerClearAllStyles" style="padding: 0px; border: 0px; line-height: 0;">
                      <sti-button [display]="button.visible ? 'inline-block': 'none'"
                        [margin]="'2px 1px 2px 2px'"
                        [caption]="button.caption"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : null"
                        [display]="'inline-block'"
                        [selected]="button.selected"
                        [closeButton]="i > 0"
                        (action)="action(button)"
                        (closeButtonAction)="close(button)">
                      </sti-button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DrillDownPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-drill-down-panel',
                    template: `
  <div #element [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
    [style.display]="model.controls.drillDownPanel.visible ? '' : 'none'">
    <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
      <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin: 0px; box-sizing: border-box;"
        [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
        [style.color]="model.options.toolbar.fontColor"
        [style.fontFamily]="model.options.toolbar.fontFamily">
        <tbody>
          <tr class="stiJsViewerClearAllStyles">
            <td class="stiJsViewerClearAllStyles">
              <table class="stiJsViewerClearAllStyles" cellpadding="0" cellspacing="0">
                <tbody>
                  <tr class="stiJsViewerClearAllStyles">
                    <td *ngFor="let button of model.drillDownButtons; index as i" class="stiJsViewerClearAllStyles" style="padding: 0px; border: 0px; line-height: 0;">
                      <sti-button [display]="button.visible ? 'inline-block': 'none'"
                        [margin]="'2px 1px 2px 2px'"
                        [caption]="button.caption"
                        [height]="model.options.toolbar.displayMode == 'Separated' ? '28px' : null"
                        [display]="'inline-block'"
                        [selected]="button.selected"
                        [closeButton]="i > 0"
                        (action)="action(button)"
                        (closeButtonAction)="close(button)">
                      </sti-button>
                    </td>
                  </tr>
                </tbody>
              </table>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.DrillDownService }, { type: i3.ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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