import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "../services/dashboard.service";
import * as i4 from "@angular/common";
import * as i5 from "../controls/button.component";
import * as i6 from "../controls/dashboard-panel-button.component";
export class DashboardsPanelComponent {
    constructor(model, helper, dashboardService) {
        this.model = model;
        this.helper = helper;
        this.dashboardService = dashboardService;
        this.imagesPath = 'Dashboards.Actions.Light.';
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.model.controls.navigatePanel.el = this.element;
    }
    get dbsMode() {
        return this.dashboardsCount > 0 && this.reportsCount === 0;
    }
    get dashboardsCount() {
        let count = 0;
        if (this.model?.reportParams?.dashboards) {
            this.model.reportParams.dashboards.forEach(i => {
                if (i['type'] === 'Dashboard') {
                    count++;
                }
            });
        }
        return count;
    }
    get reportsCount() {
        if (this.model?.reportParams?.dashboards) {
            return this.model.reportParams.dashboards.length - this.dashboardsCount;
        }
        return 0;
    }
    get previewSettings() {
        return this.model.reportParams.previewSettings || {};
    }
}
DashboardsPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardsPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.DashboardService }], target: i0.ɵɵFactoryTarget.Component });
DashboardsPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: DashboardsPanelComponent, selector: "sti-dashboards-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="helper.val(model.options.toolbar.fontColor)"
      [style.display]="model.controls.dashboardsPanel.visible ? '' : 'none'"
      [style.background]="dbsMode ? 'transparent' : ''"
      [style.borderColor]="dbsMode ? 'transparent' : ''">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin: 0px; box-sizing: border-box;"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
          [style.background]="dbsMode ? 'transparent' : ''"
          [style.borderColor]="dbsMode ? 'transparent' : ''">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="width: 100%;">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0"
                  [style.align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment == 'default' ? 'left' : model.options.toolbar.alignment)">
                  <tbody>
                      <tr>
                         <td *ngFor="let info of model.reportParams.dashboards; let i=index">
                            <sti-dashboard-button
                              [info]="info"
                              [dbsMode]="dbsMode"
                              [display]="dashboardsCount == 1 && reportsCount == 0 ? 'none': null">
                            </sti-dashboard-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>

              <!-- actions table -->
              <td class="stiJsViewerClearAllStyles">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin-right:2px">
                  <tbody>
                      <tr>
                        <td *ngIf="model.options.toolbar.showRefreshButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Refresh.png'"
                            [tooltip]="model.loc('Refresh')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Refresh'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardRefreshButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showParametersButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Parameters.png'"
                            [tooltip]="model.loc('Parameters')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Parameters'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showOpenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Open.png'"
                            [tooltip]="model.loc('Open')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'OpenDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardOpenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showDesignButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Edit.png'"
                            [tooltip]="model.loc('Edit')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postDesign'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardEditButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showFullScreenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'CloseFullScreen.png'"
                            [caption]="model.loc('Close')"
                            [tooltip]="model.loc('FullScreen')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postFullScreen'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardFullScreenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showSaveButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Menu.png'"
                            [tooltip]="model.loc('Save')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'ExportDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardMenuButton && ((previewSettings.dashboardShowReportSnapshots && !model.options.jsMode) || previewSettings.dashboardShowExports) ? '' :'none'">
                          </sti-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ButtonComponent, selector: "sti-button", inputs: ["caption", "caption2", "captionAlign", "captionPadding", "captionPaddingLeft", "captionWhiteSpace", "captionOverflow", "captionTextOverflow", "captionWidth", "captionMaxWidth", "captionLineHeight", "imageName", "arrow", "arrowMarginTop", "margin", "height", "selected", "minWidth", "innerTableWidth", "menuItems", "actionName", "tooltip", "imageCellTextAlign", "imageCellWidth", "imageCellPadding", "imageSizesWidth", "imageSizesHeight", "imageMargin", "width", "display", "closeButton", "resourceButton", "styleColors", "boxSizing", "navagationPanelTooltip", "cursor", "fontSize", "helpLink", "borderColor", "styleName", "enabled"], outputs: ["action", "closeButtonAction"] }, { kind: "component", type: i6.DashboardButtonComponent, selector: "sti-dashboard-button", inputs: ["showCloseButton", "info", "dbsMode", "display"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: DashboardsPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-dashboards-panel',
                    template: `
    <div #element
      [class]="'stiJsViewerToolBar' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerToolBarSeparated' : '')"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.fontColor]="helper.val(model.options.toolbar.fontColor)"
      [style.display]="model.controls.dashboardsPanel.visible ? '' : 'none'"
      [style.background]="dbsMode ? 'transparent' : ''"
      [style.borderColor]="dbsMode ? 'transparent' : ''">
      <div [style.paddingTop]="model.options.toolbar.displayMode == 'Simple' ? '2px' : ''">
        <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin: 0px; box-sizing: border-box;"
          [style.border]="model.options.toolbar.displayMode == 'Separated' ? '0px' : ''"
          [style.background]="dbsMode ? 'transparent' : ''"
          [style.borderColor]="dbsMode ? 'transparent' : ''">
          <tbody>
            <tr class="stiJsViewerClearAllStyles">
              <td class="stiJsViewerClearAllStyles" style="width: 100%;">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0"
                  [style.align]="model.options.appearance.rightToLeft ? 'right' : (model.options.toolbar.alignment == 'default' ? 'left' : model.options.toolbar.alignment)">
                  <tbody>
                      <tr>
                         <td *ngFor="let info of model.reportParams.dashboards; let i=index">
                            <sti-dashboard-button
                              [info]="info"
                              [dbsMode]="dbsMode"
                              [display]="dashboardsCount == 1 && reportsCount == 0 ? 'none': null">
                            </sti-dashboard-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>

              <!-- actions table -->
              <td class="stiJsViewerClearAllStyles">
                <table class="stiJsViewerToolBarTable" cellpadding="0" cellspacing="0" style="margin-right:2px">
                  <tbody>
                      <tr>
                        <td *ngIf="model.options.toolbar.showRefreshButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Refresh.png'"
                            [tooltip]="model.loc('Refresh')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Refresh'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardRefreshButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showParametersButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Parameters.png'"
                            [tooltip]="model.loc('Parameters')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'Parameters'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showOpenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Open.png'"
                            [tooltip]="model.loc('Open')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'OpenDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardOpenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showDesignButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Edit.png'"
                            [tooltip]="model.loc('Edit')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postDesign'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardEditButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showFullScreenButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'CloseFullScreen.png'"
                            [caption]="model.loc('Close')"
                            [tooltip]="model.loc('FullScreen')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'postFullScreen'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardFullScreenButton ? '' : 'none'">
                          </sti-button>
                        </td>

                        <td *ngIf="model.options.toolbar.showSaveButton && model.options.toolbar.visible">
                          <sti-button [imageName]="imagesPath + 'Menu.png'"
                            [tooltip]="model.loc('Save')"
                            [helpLink]="helper.helpLinks['DashboardToolbar']"
                            [margin]="'2px 0 2px 2px'"
                            [actionName]="'ExportDashboard'"
                            [height]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [width]="model.options.toolbar.displayMode == 'Separated' ? (dbsMode ? (model.options.isTouchDevice ? '28px' : '23px') : '28px') : null"
                            [innerTableWidth]="model.options.toolbar.displayMode == 'Separated' ? '100%': null"
                            [imageCellTextAlign]="model.options.toolbar.displayMode == 'Separated' ? 'center': null"
                            [display]="previewSettings.dashboardToolBar && previewSettings.dashboardMenuButton && ((previewSettings.dashboardShowReportSnapshots && !model.options.jsMode) || previewSettings.dashboardShowExports) ? '' :'none'">
                          </sti-button>
                        </td>
                      </tr>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.DashboardService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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