import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
export class CenterTextComponent {
    constructor(model, controller, helper) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.text = '';
        this.opacity = 0;
        this.display = 'none';
        controller.getActionMessage().subscribe((message) => {
            switch (message.action) {
                case 'centerText':
                    this.show(message.data);
                    break;
                case 'hideCenterText':
                    this.hide();
                    break;
            }
        });
    }
    ngOnInit() { }
    show(text) {
        this.display = '';
        this.opacity = 0;
        this.text = text;
        setTimeout(() => {
            this.helper.setObjectToCenter(this.element.nativeElement);
            this.opacity = 1;
        });
        if (this.hideTimer) {
            clearTimeout(this.hideTimer);
        }
        this.hideTimer = setTimeout(() => {
            this.hide();
        }, 2000);
    }
    hide() {
        this.opacity = 0;
        if (this.hideTimer) {
            clearTimeout(this.hideTimer);
        }
        this.hideTimer = setTimeout(() => {
            this.display = 'none';
        }, 300);
    }
}
CenterTextComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CenterTextComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }], target: i0.ɵɵFactoryTarget.Component });
CenterTextComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: CenterTextComponent, selector: "sti-center-text", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element
      style="position: absolute; z-index: 1000; transition-property: opacity; transition-duration: 300ms; text-shadow: rgb(0, 0, 0) -1px -1px 0px, rgb(0, 0, 0) 1px -1px 0px, rgb(0, 0, 0) -1px 1px 0px, rgb(0, 0, 0) 1px 1px 0px; font-size: 100px;"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [style.opacity]="opacity"
      [style.display]="display">
      <div>
        {{text}}
      </div>
    </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: CenterTextComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-center-text',
                    template: `
    <div #element
      style="position: absolute; z-index: 1000; transition-property: opacity; transition-duration: 300ms; text-shadow: rgb(0, 0, 0) -1px -1px 0px, rgb(0, 0, 0) 1px -1px 0px, rgb(0, 0, 0) -1px 1px 0px, rgb(0, 0, 0) 1px 1px 0px; font-size: 100px;"
      [style.fontFamily]="model.options.toolbar.fontFamily"
      [style.color]="model.options.toolbar.fontColor"
      [style.opacity]="opacity"
      [style.display]="display">
      <div>
        {{text}}
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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