import { Component, ViewChild } from '@angular/core';
import { trigger, state, transition, animate, style, keyframes } from '@angular/animations';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/helper.service";
import * as i3 from "../services/controller.service";
import * as i4 from "@angular/common";
export class BookmarksPanelComponent {
    constructor(model, helper, controller) {
        this.model = model;
        this.helper = helper;
        this.controller = controller;
        controller.getMessage().subscribe((message) => {
            if (message.action === 'GetReport' || message.action === 'OpenReport') {
                setTimeout(() => {
                    if (this.model.reportParams.bookmarksContent != null) {
                        this.create();
                    }
                    this.model.controls.bookmarksPanel.visible = this.model.reportParams.bookmarksContent !== null && !this.model.options.isMobileDevice;
                });
            }
            else {
                // Go to the bookmark, if it present
                setTimeout(() => {
                    if (this.model.options.bookmarkAnchor != null) {
                        this.helper.scrollToAnchor(this.model.options.bookmarkAnchor, this.model.options.componentGuid);
                        this.model.options.bookmarkAnchor = null;
                        this.model.options.componentGuid = null;
                    }
                });
            }
        });
        this.model.controls.bookmarksPanel.getVisibility().subscribe((value) => {
            if (!value) {
                this.helper.removeBookmarksLabel();
                this.clearSelected();
            }
        });
    }
    ngAfterViewInit() {
        this.model.controls.bookmarksPanel.el = this.element;
    }
    ngOnInit() { }
    getImg1(node, i) {
        if (node.nodes?.length === 0) {
            return i !== this.model.nodes.length - 1 ? this.model.imagesForBookmark['join'] : this.model.imagesForBookmark['joinBottom'];
        }
        return node.open ? (i === this.model.nodes.length - 1 ? this.model.imagesForBookmark['minusBottom'] : this.model.imagesForBookmark['minus']) :
            (i === this.model.nodes.length - 1 ? this.model.imagesForBookmark['plusBottom'] : this.model.imagesForBookmark['plus']);
    }
    postAction(node) {
        this.clearSelected();
        this.controller.postBookmarkNodeAction(node);
    }
    clearSelected() {
        this.model.nodes?.forEach((n) => {
            n.selected = false;
            n.nodes.forEach(element => element.selected = false);
        });
    }
    create() {
        let bookmarks;
        if (this.model.reportParams.bookmarksContent.indexOf('bookmarks.add(') >= 0) {
            bookmarks = this.model.reportParams.bookmarksContent.split('bookmarks.add(');
        }
        else {
            bookmarks = this.model.reportParams.bookmarksContent.split('window.StiBookmarks.add(');
        }
        const root = bookmarks[1].replace('0,-1,\'', '');
        this.rootName = root.substr(0, root.indexOf('\''));
        const nodes = [];
        this.parseNodes(bookmarks.splice(2), 0, nodes);
        this.model.nodes = nodes;
    }
    parseNodes(bookmarks, index, nodes) {
        let folder;
        bookmarks.forEach((bookmark) => {
            const str = bookmark.substr(bookmark.indexOf(',') + 1);
            const nodeType = parseInt(str.substr(0, str.indexOf(',')), 10);
            const node = this.parseNode(str);
            if (nodeType === 0) {
                nodes.push(node);
                folder = node;
            }
            else {
                folder.nodes.push(node);
            }
        });
    }
    parseNode(str) {
        str = str.substr(str.indexOf(',') + 2);
        const name = this.unescape(str.substr(0, str.indexOf('\',')));
        str = str.substr(str.indexOf('\',') + 3);
        const url = str.substr(0, str.indexOf('\','));
        str = str.substr(str.indexOf('\',') + 3);
        const pageTitle = str.substr(0, str.indexOf('\','));
        str = str.substr(str.indexOf('\',') + 3);
        const componentGuid = str.substr(0, str.length - 3);
        return { name, url, page: parseInt(pageTitle.substr(5), 10) - 1, compunentGuid: componentGuid, nodes: [], open: false, selected: false };
    }
    unescape(str) {
        return str.replace(/\\&apos;/g, '\'')
            .replace(/\\&quot;/g, '"')
            .replace(/\\&gt;/g, '>')
            .replace(/\\&lt;/g, '<')
            .replace(/\\&amp;/g, '&');
    }
    get bottom() {
        if (this.model.options.isMobileDevice) {
            return this.model.options.toolbar.autoHide ? '0' : '0.5in';
        }
        else {
            return this.model.options.toolbar.displayMode === 'Separated' && this.model.options.toolbar.visible ? '35px' : '0';
        }
    }
}
BookmarksPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: BookmarksPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.HelperService }, { token: i3.ControllerService }], target: i0.ɵɵFactoryTarget.Component });
BookmarksPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: BookmarksPanelComponent, selector: "sti-bookmarks-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }, { propertyName: "bookmarksPanel", first: true, predicate: ["bookmarksPanel"], descendants: true }], ngImport: i0, template: `
    <div #element [style]="{fontFamily: model.options.toolbar.fontFamily, fontColor: helper.val(model.options.toolbar.fontColor)}"
      [class]="'stiJsViewerBookmarksPanel' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerBookmarksPanelSeparated' : '')"
      [style.width.px]="model.options.appearance.bookmarksTreeWidth - (model.options.toolbar.displayMode == 'Simple' ? 0 : 1)"
      [style.bottom]="bottom"
      [style.top.px]="model.controls.bookmarksPanel.layout.top"
      [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
      [style.display]="!this.model.options.isMobileDevice ? (model.controls.bookmarksPanel.visible ? '' : 'none') : null"
      [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.bookmarksPanel.visible ? 'visible' : 'hidden')">
      <div #bookmarksPanel [class]="'stiJsViewerBookmarksContainer' + (model.options.toolbar.displayMode == 'Simple' ? ' stiJsViewerBookmarksContainerSimple' : '')"
           [style.background]="helper.val(model.options.toolbar.backgroundColor)"
           [style.border]="helper.val(model.options.toolbar.borderColor) != '' ? '1px solid ' + helper.val(model.options.toolbar.borderColor): ''">
           <div class="stiTree">
              <div class="stiTreeNode">
                <img style="width: 16px; height: 16px;" [src]="model.imagesForBookmark['root']"/>
                <a class="node">{{rootName}}</a>
              </div>
              <div class="clip" style="display:block;">
                <ng-container *ngFor="let node of model.nodes; index as i">
                    <div class="stiTreeNode">
                        <a (click)="node.open = !node.open">
                            <img style="width: 18px; height: 18px"
                             [src]="getImg1(node, i)"/>
                        </a>
                        <img style="width: 16px; height: 16px;" [src]="node.nodes?.length == 0 ? model.imagesForBookmark['node'] :(node.open ? model.imagesForBookmark['folderOpen'] : model.imagesForBookmark['folder'])"/>
                        <a [class]="node.selected ? 'nodeSel' : 'node'" (click)="postAction(node)">{{node.name}}</a>
                    </div>
                    <div class="clip" [style.display]="node.open ? 'block' : 'none'">
                      <div *ngFor="let subNode of node.nodes; index as k" class="stiTreeNode">
                        <img style="width: 18px; height: 18px;" [src]="i != model.nodes.length - 1 ? model.imagesForBookmark['line'] : model.imagesForBookmark['empty']"/>
                        <img style="width: 18px; height: 18px;" [src]="k == node.nodes.length - 1 ? model.imagesForBookmark['joinBottom'] : model.imagesForBookmark['join']"/>
                        <img style="width: 16px; height: 16px;" [src]="model.imagesForBookmark['node']" />
                        <a [class]="subNode.selected ? 'nodeSel' : 'node'" (click)="postAction(subNode)">{{subNode.name}}</a>
                      </div>
                    </div>
                </ng-container>
              </div>
          </div>
      </div>
    </div>
  `, isInline: true, dependencies: [{ kind: "directive", type: i4.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }], animations: [
        trigger('visibility', [
            state('visible', style({ opacity: 1, display: 'block' })),
            state('hidden', style({ opacity: 0, display: 'none' })),
            transition('hidden => visible', [
                animate('300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 0, offset: 0 }),
                    style({ display: 'block', opacity: 1, offset: 1 }),
                ]))
            ]),
            transition('visible => hidden', [
                animate('300ms ease-in-out', keyframes([
                    style({ display: 'block', opacity: 1, offset: 0 }),
                    style({ display: 'none', opacity: 0, offset: 1 }),
                ]))
            ])
        ])
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: BookmarksPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-bookmarks-panel',
                    template: `
    <div #element [style]="{fontFamily: model.options.toolbar.fontFamily, fontColor: helper.val(model.options.toolbar.fontColor)}"
      [class]="'stiJsViewerBookmarksPanel' + (model.options.toolbar.displayMode == 'Separated' ? ' stiJsViewerBookmarksPanelSeparated' : '')"
      [style.width.px]="model.options.appearance.bookmarksTreeWidth - (model.options.toolbar.displayMode == 'Simple' ? 0 : 1)"
      [style.bottom]="bottom"
      [style.top.px]="model.controls.bookmarksPanel.layout.top"
      [style.transition]="model.options.isMobileDevice ? 'opacity 300ms ease' : null"
      [style.display]="!this.model.options.isMobileDevice ? (model.controls.bookmarksPanel.visible ? '' : 'none') : null"
      [@visibility]="!this.model.options.isMobileDevice ? null : (model.controls.bookmarksPanel.visible ? 'visible' : 'hidden')">
      <div #bookmarksPanel [class]="'stiJsViewerBookmarksContainer' + (model.options.toolbar.displayMode == 'Simple' ? ' stiJsViewerBookmarksContainerSimple' : '')"
           [style.background]="helper.val(model.options.toolbar.backgroundColor)"
           [style.border]="helper.val(model.options.toolbar.borderColor) != '' ? '1px solid ' + helper.val(model.options.toolbar.borderColor): ''">
           <div class="stiTree">
              <div class="stiTreeNode">
                <img style="width: 16px; height: 16px;" [src]="model.imagesForBookmark['root']"/>
                <a class="node">{{rootName}}</a>
              </div>
              <div class="clip" style="display:block;">
                <ng-container *ngFor="let node of model.nodes; index as i">
                    <div class="stiTreeNode">
                        <a (click)="node.open = !node.open">
                            <img style="width: 18px; height: 18px"
                             [src]="getImg1(node, i)"/>
                        </a>
                        <img style="width: 16px; height: 16px;" [src]="node.nodes?.length == 0 ? model.imagesForBookmark['node'] :(node.open ? model.imagesForBookmark['folderOpen'] : model.imagesForBookmark['folder'])"/>
                        <a [class]="node.selected ? 'nodeSel' : 'node'" (click)="postAction(node)">{{node.name}}</a>
                    </div>
                    <div class="clip" [style.display]="node.open ? 'block' : 'none'">
                      <div *ngFor="let subNode of node.nodes; index as k" class="stiTreeNode">
                        <img style="width: 18px; height: 18px;" [src]="i != model.nodes.length - 1 ? model.imagesForBookmark['line'] : model.imagesForBookmark['empty']"/>
                        <img style="width: 18px; height: 18px;" [src]="k == node.nodes.length - 1 ? model.imagesForBookmark['joinBottom'] : model.imagesForBookmark['join']"/>
                        <img style="width: 16px; height: 16px;" [src]="model.imagesForBookmark['node']" />
                        <a [class]="subNode.selected ? 'nodeSel' : 'node'" (click)="postAction(subNode)">{{subNode.name}}</a>
                      </div>
                    </div>
                </ng-container>
              </div>
          </div>
      </div>
    </div>
  `,
                    animations: [
                        trigger('visibility', [
                            state('visible', style({ opacity: 1, display: 'block' })),
                            state('hidden', style({ opacity: 0, display: 'none' })),
                            transition('hidden => visible', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 0, offset: 0 }),
                                    style({ display: 'block', opacity: 1, offset: 1 }),
                                ]))
                            ]),
                            transition('visible => hidden', [
                                animate('300ms ease-in-out', keyframes([
                                    style({ display: 'block', opacity: 1, offset: 0 }),
                                    style({ display: 'none', opacity: 0, offset: 1 }),
                                ]))
                            ])
                        ])
                    ]
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.HelperService }, { type: i3.ControllerService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }], bookmarksPanel: [{
                type: ViewChild,
                args: ['bookmarksPanel']
            }] } });
//# sourceMappingURL=data:application/json;base64,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